/*
 * Decompiled with CFR 0.152.
 */
package android.content.resource.parser;

import android.content.pm.APKInfo;
import android.content.resource.parser.ResourceConfig;
import android.content.resource.parser.ResourcePackage;
import android.content.resource.parser.ResourceReader;
import android.content.resource.parser.ReturnValue;
import android.content.resource.parser.StringBlock;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.Arrays;
import java.util.HashSet;

public class ResourceDecoder {
    public InputStream is = null;
    public short chunkType = (short)-1;
    public int chunkSize = 0;
    public static final short TYPE_NONE = -1;
    public static final short TYPE_TABLE = 2;
    public static final short TYPE_PACKAGE = 512;
    public static final short TYPE_TYPE = 514;
    public static final short TYPE_CONFIG = 513;
    public int memberCount = 0;
    public boolean mKeepBroken = false;
    public StringBlock sb = new StringBlock();
    public ResourcePackage[] blocks = null;
    public static int counter = -1;
    public static final CharsetDecoder UTF16LE_DECODER = Charset.forName("UTF-16LE").newDecoder();
    public static final CharsetDecoder UTF8_DECODER = Charset.forName("UTF-8").newDecoder();
    public ReturnValue rt = new ReturnValue();
    public boolean bPrint = false;

    public void addQury(int input) {
        this.rt.addQuery(input);
    }

    public void setQuery() {
        this.rt.setQuery();
    }

    public ResourceDecoder(InputStream is) {
        this.is = is;
    }

    public void Decoder(APKInfo info, boolean keepBroken) throws Exception {
        this.mKeepBroken = keepBroken;
        this.nextChunk();
        if (this.chunkType != 2) {
            throw new Exception("YYY !=2");
        }
        this.memberCount = ResourceReader.readInt(this.is);
        this.readBlock(this.sb);
        this.nextChunk();
        this.blocks = new ResourcePackage[this.memberCount];
        for (int i = 0; i < this.memberCount; ++i) {
            this.blocks[i] = new ResourcePackage();
            this.readPackage(this.blocks[i], info);
        }
    }

    public void Decoder(boolean keepBroken) throws Exception {
        this.mKeepBroken = keepBroken;
        this.nextChunk();
        if (this.chunkType != 2) {
            throw new Exception("YYY !=2");
        }
        this.memberCount = ResourceReader.readInt(this.is);
        this.readBlock(this.sb);
        this.nextChunk();
        this.blocks = new ResourcePackage[this.memberCount];
        for (int i = 0; i < this.memberCount; ++i) {
            this.blocks[i] = new ResourcePackage();
            this.readPackage(this.blocks[i]);
        }
    }

    public int nextChunk() throws Exception {
        if (this.is.available() < 2) {
            this.chunkType = (short)-1;
            return -1;
        }
        this.chunkType = ResourceReader.readShort(this.is);
        ResourceReader.skipBytes(this.is, 2);
        this.chunkSize = ResourceReader.readInt(this.is);
        return 0;
    }

    public void readBlock(StringBlock sb) throws Exception {
        int i2;
        int chunk = ResourceReader.readInt(this.is);
        if (chunk != 0x1C0001) {
            throw new Exception("ZZZ1835009");
        }
        sb._chunkSize = ResourceReader.readInt(this.is);
        sb._stringCount = ResourceReader.readInt(this.is);
        sb._styleOffsetCount = ResourceReader.readInt(this.is);
        int m = ResourceReader.readInt(this.is);
        sb._stringsOffset = ResourceReader.readInt(this.is);
        sb._stylesOffset = ResourceReader.readInt(this.is);
        sb.m_isUTF8 = (m & 0x100) != 0;
        sb.m_stringOffsets = ResourceReader.readIntArray(this.is, sb._stringCount);
        if (sb._styleOffsetCount != 0) {
            sb.m_styleOffsets = ResourceReader.readIntArray(this.is, sb._styleOffsetCount);
        }
        if ((i2 = (sb._stylesOffset == 0 ? sb._chunkSize : sb._stylesOffset) - sb._stringsOffset) % 4 != 0) {
            throw new IOException("String data size is not multiple of 4 (" + i2 + ").");
        }
        sb.m_strings = new byte[i2];
        ResourceReader.readFully(this.is, sb.m_strings);
        if (sb._stylesOffset != 0) {
            i2 = sb._chunkSize - sb._stylesOffset;
            if (i2 % 4 != 0) {
                throw new IOException("Style data size is not multiple of 4 (" + i2 + ").");
            }
            sb.m_styles = ResourceReader.readIntArray(this.is, i2 / 4);
        }
    }

    public void readType(ResourcePackage sb, APKInfo info) throws Exception {
        byte i = ResourceReader.readByte(this.is);
        ResourceReader.skipBytes(this.is, 3);
        int j = ResourceReader.readInt(this.is);
        sb.mMissingResSpecs = new boolean[j];
        Arrays.fill(sb.mMissingResSpecs, true);
        ResourceReader.skipBytes(this.is, j * 4);
        sb.mResId = 0xFF000000 & sb.mResId | i << 16;
        this.nextChunk();
        while (this.chunkType == 513) {
            int chunk;
            this.readConfig(sb);
            if (sb.mConfig != null) {
                if (sb.mConfig.country == null && sb.mConfig.language == null) continue;
                if (info.country_lang_set == null) {
                    info.country_lang_set = new HashSet();
                }
                StringBuilder _sb = new StringBuilder();
                if (sb.mConfig.language != null) {
                    _sb.append(sb.mConfig.language);
                } else {
                    _sb.append(' ');
                }
                _sb.append('@');
                if (sb.mConfig.country != null) {
                    _sb.append(sb.mConfig.country);
                } else {
                    _sb.append(' ');
                }
                info.country_lang_set.add(_sb.toString());
            }
            if ((chunk = this.nextChunk()) >= 0) continue;
            this.chunkType = (short)-1;
            return;
        }
    }

    public void readType(ResourcePackage sb) throws Exception {
        byte i = ResourceReader.readByte(this.is);
        ResourceReader.skipBytes(this.is, 3);
        int j = ResourceReader.readInt(this.is);
        sb.mMissingResSpecs = new boolean[j];
        Arrays.fill(sb.mMissingResSpecs, true);
        ResourceReader.skipBytes(this.is, j * 4);
        sb.mResId = 0xFF000000 & sb.mResId | i << 16;
        this.nextChunk();
        while (this.chunkType == 513) {
            this.readConfig(sb);
            int chunk = this.nextChunk();
            if (chunk >= 0) continue;
            this.chunkType = (short)-1;
            return;
        }
    }

    public void readPackage(ResourcePackage sb, APKInfo info) throws Exception {
        if (this.chunkType != 512) {
            throw new Exception("xxxx512");
        }
        int i = ResourceReader.readInt(this.is);
        String str = ResourceReader.readNulEndString(this.is, 128, true);
        ResourceReader.skipBytes(this.is, 4);
        ResourceReader.skipBytes(this.is, 4);
        ResourceReader.skipBytes(this.is, 4);
        ResourceReader.skipBytes(this.is, 4);
        this.readBlock(sb.mTypeNames);
        this.readBlock(sb.mSpecNames);
        sb.mResId = i << 24;
        sb.mName = str;
        System.out.println("package:" + sb.mName + " --" + sb.mResId);
        this.nextChunk();
        while (this.chunkType == 514) {
            this.readType(sb, info);
        }
    }

    public void readPackage(ResourcePackage sb) throws Exception {
        if (this.chunkType != 512) {
            throw new Exception("xxxx512");
        }
        int i = ResourceReader.readInt(this.is);
        String str = ResourceReader.readNulEndString(this.is, 128, true);
        ResourceReader.skipBytes(this.is, 4);
        ResourceReader.skipBytes(this.is, 4);
        ResourceReader.skipBytes(this.is, 4);
        ResourceReader.skipBytes(this.is, 4);
        this.readBlock(sb.mTypeNames);
        this.readBlock(sb.mSpecNames);
        sb.mResId = i << 24;
        sb.mName = str;
        this.nextChunk();
        while (this.chunkType == 514) {
            this.readType(sb);
        }
    }

    public void readConfig(ResourcePackage sp) throws Exception {
        ResourceReader.skipBytes(this.is, 4);
        int i = ResourceReader.readInt(this.is);
        ResourceReader.skipBytes(this.is, 4);
        sp.mConfig = this.readConfigFlags();
        int[] arrayOfInt = ResourceReader.readIntArray(this.is, i);
        if (sp.mConfig != null) {
            if (sp.mConfig.isInvalid) {
                String str = sp.mName + sp.mConfig.mQualifiers;
                if (this.mKeepBroken) {
                    // empty if block
                }
            }
            ResourceConfig resourceConfig = sp.mConfig = sp.mConfig.isInvalid && !this.mKeepBroken ? null : sp.getOrCreateConfig(sp.mConfig);
            if (sp.mConfig != null) {
                this.bPrint = new String(sp.mConfig.language).equals("ZH") && new String(sp.mConfig.country).equals("CN");
            }
        }
        for (int j = 0; j < arrayOfInt.length; ++j) {
            if (arrayOfInt[j] == -1) continue;
            sp.mMissingResSpecs[j] = false;
            int id = sp.mResId & 0xFFFF0000 | j;
            if (sp.mConfig == null) continue;
            this.readEntry(sp, id);
        }
    }

    public void readEntry(ResourcePackage sp, int id) throws Exception {
        ResourceReader.skipBytes(this.is, 2);
        short i = ResourceReader.readShort(this.is);
        int j = ResourceReader.readInt(this.is);
        if ((i & 1) == 0) {
            ++counter;
            String value = this.readValue(sp);
            if (this.rt.result != null) {
                int index = -1;
                for (int k = 0; k < this.rt.result.length; ++k) {
                    if (this.rt.result[k].key != id) continue;
                    index = k;
                    break;
                }
                if (index >= 0 && new String(sp.mConfig.language).equals("ZH") && new String(sp.mConfig.country).equals("CN")) {
                    this.rt.result[index].value = value;
                } else if (index >= 0 && this.rt.result[index].value == null) {
                    this.rt.result[index].value = value;
                }
            }
        } else {
            ++counter;
            String[] strs = this.readComplexEntry(sp);
            if (this.rt.result != null) {
                int index = -1;
                for (int k = 0; k < this.rt.result.length; ++k) {
                    if (this.rt.result[k].key != id) continue;
                    index = k;
                    break;
                }
                if (index >= 0 && sp.mConfig != null && new String(sp.mConfig.language).equals("ZH") && new String(sp.mConfig.country).equals("CN")) {
                    this.rt.result[index].value = strs[0];
                } else if (index >= 0 && this.rt.result[index].value == null) {
                    this.rt.result[index].value = strs[0];
                }
            }
        }
    }

    public ResourceConfig readConfigFlags() throws Exception {
        int j;
        int i = ResourceReader.readInt(this.is);
        if (i < 28) {
            throw new Exception("nweeeexx");
        }
        boolean bool = false;
        short s1 = ResourceReader.readShort(this.is);
        short s2 = ResourceReader.readShort(this.is);
        char[] arrayOfChar1 = new char[]{(char)ResourceReader.readByte(this.is), (char)ResourceReader.readByte(this.is)};
        char[] arrayOfChar2 = new char[]{(char)ResourceReader.readByte(this.is), (char)ResourceReader.readByte(this.is)};
        byte b1 = ResourceReader.readByte(this.is);
        byte b2 = ResourceReader.readByte(this.is);
        short s3 = ResourceReader.readShort(this.is);
        byte b3 = ResourceReader.readByte(this.is);
        byte b4 = ResourceReader.readByte(this.is);
        byte b5 = ResourceReader.readByte(this.is);
        ResourceReader.skipBytes(this.is, 1);
        short s4 = ResourceReader.readShort(this.is);
        short s5 = ResourceReader.readShort(this.is);
        short s6 = ResourceReader.readShort(this.is);
        ResourceReader.skipBytes(this.is, 2);
        byte b6 = 0;
        byte b7 = 0;
        if (i >= 32) {
            b6 = ResourceReader.readByte(this.is);
            b7 = ResourceReader.readByte(this.is);
            ResourceReader.skipBytes(this.is, 2);
        }
        if ((j = i - 32) > 0) {
            byte[] arrayOfByte = new byte[j];
            ResourceReader.readFully(this.is, arrayOfByte);
            BigInteger localBigInteger = new BigInteger(arrayOfByte);
            if (!localBigInteger.equals(BigInteger.ZERO)) {
                bool = true;
            }
        }
        return new ResourceConfig(s1, s2, arrayOfChar1, arrayOfChar2, b1, b2, s3, b3, b4, b5, s4, s5, s6, b6, b7, bool);
    }

    public String readValue(ResourcePackage sp) throws Exception {
        ResourceReader.readShort(this.is);
        ResourceReader.readByte(this.is);
        byte i = ResourceReader.readByte(this.is);
        int j = ResourceReader.readInt(this.is);
        if (i == 3) {
            return ResourceDecoder.getString(j, this.sb);
        }
        return null;
    }

    public String[] readComplexEntry(ResourcePackage sp) throws Exception {
        int i = ResourceReader.readInt(this.is);
        int j = ResourceReader.readInt(this.is);
        String[] strs = new String[j];
        for (int k = 0; k < j; ++k) {
            String str;
            ResourceReader.readInt(this.is);
            strs[k] = str = this.readValue(sp);
        }
        return strs;
    }

    public String getHTML(int paramInt, StringBlock sb) {
        String str = ResourceDecoder.getString(paramInt, sb);
        if (str == null) {
            return str;
        }
        int[] arrayOfInt1 = this.getStyle(paramInt, sb);
        if (arrayOfInt1 == null) {
            return ResourceDecoder.escapeTextForResXml(str);
        }
        StringBuilder localStringBuilder = new StringBuilder(str.length() + 32);
        int[] arrayOfInt2 = new int[arrayOfInt1.length / 3];
        int i = 0;
        int j = 0;
        while (true) {
            int i1;
            int i2;
            int k = -1;
            for (int m = 0; m != arrayOfInt1.length; m += 3) {
                if (arrayOfInt1[m + 1] == -1 || k != -1 && arrayOfInt1[k + 1] <= arrayOfInt1[m + 1]) continue;
                k = m;
            }
            int n = k != -1 ? arrayOfInt1[k + 1] : str.length();
            int m = 0;
            for (m = j - 1; m >= 0 && (i2 = arrayOfInt1[(i1 = arrayOfInt2[m]) + 2]) < n; --m) {
                if (i <= i2) {
                    localStringBuilder.append(ResourceDecoder.escapeCharsForResXml(str.substring(i, i2 + 1)));
                    i = i2 + 1;
                }
                this.outputStyleTag(ResourceDecoder.getString(arrayOfInt1[i1], sb), localStringBuilder, true);
            }
            j = m + 1;
            if (i < n) {
                localStringBuilder.append(ResourceDecoder.escapeCharsForResXml(str.substring(i, n)));
                i = n;
            }
            if (k == -1) break;
            String paramString = ResourceDecoder.getString(arrayOfInt1[k], sb);
            if (paramString != null) {
                this.outputStyleTag(paramString, localStringBuilder, false);
            }
            arrayOfInt1[k + 1] = -1;
            arrayOfInt2[j++] = k;
        }
        return ResourceDecoder.escapeTextForResXml(localStringBuilder.toString(), false);
    }

    public static String getString(int paramInt, StringBlock sb) {
        if (paramInt < 0 || sb == null || paramInt >= sb.m_stringOffsets.length) {
            return null;
        }
        int i = sb.m_stringOffsets[paramInt];
        int j = 0;
        if (!sb.m_isUTF8) {
            j = ResourceDecoder.getShort(sb.m_strings, i) * 2;
            i += 2;
        } else {
            i += ResourceDecoder.getVarint(sb.m_strings, i)[1];
            int[] arrayOfInt = ResourceDecoder.getVarint(sb.m_strings, i);
            i += arrayOfInt[1];
            j = arrayOfInt[0];
        }
        return ResourceDecoder.decodeString(sb, i, j);
    }

    public static String escapeTextForResXml(String paramString) {
        return ResourceDecoder.escapeTextForResXml(paramString, true);
    }

    public static String escapeTextForResXml(String paramString, boolean paramBoolean) {
        if (TextUtils.isEmpty((CharSequence)paramString)) {
            return paramString;
        }
        if (paramBoolean) {
            paramString = ResourceDecoder.escapeCharsForResXml(paramString);
        }
        StringBuilder localStringBuilder = new StringBuilder(paramString.length() + 10);
        char[] arrayOfChar1 = paramString.toCharArray();
        switch (arrayOfChar1[0]) {
            case '#': 
            case '?': 
            case '@': {
                localStringBuilder.append('\\');
            }
        }
        boolean i = true;
        for (char c : arrayOfChar1) {
            if (c == ' ') {
                if (i) {
                    localStringBuilder.append("\\u0020");
                    continue;
                }
                localStringBuilder.append(c);
                i = true;
                continue;
            }
            i = false;
            localStringBuilder.append(c);
        }
        if (i && localStringBuilder.charAt(localStringBuilder.length() - 1) == ' ') {
            localStringBuilder.deleteCharAt(localStringBuilder.length() - 1);
            localStringBuilder.append("\\u0020");
        }
        return localStringBuilder.toString();
    }

    public static String escapeCharsForResXml(String paramString) {
        if (TextUtils.isEmpty((CharSequence)paramString)) {
            return paramString;
        }
        StringBuilder localStringBuilder = new StringBuilder(paramString.length() + 10);
        for (char c : paramString.toCharArray()) {
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    localStringBuilder.append('\\');
                    break;
                }
                case '\n': {
                    localStringBuilder.append("\\n");
                    break;
                }
                case '&': {
                    localStringBuilder.append("&amp;");
                    break;
                }
                case '<': {
                    localStringBuilder.append("&lt;");
                }
            }
            localStringBuilder.append(c);
        }
        return localStringBuilder.toString();
    }

    public int[] getStyle(int paramInt, StringBlock sb) {
        if (sb.m_styleOffsets == null || sb.m_styles == null || paramInt >= sb.m_styleOffsets.length) {
            return null;
        }
        int i = sb.m_styleOffsets[paramInt] / 4;
        int j = 0;
        for (int k = i; k < sb.m_styles.length && sb.m_styles[k] != -1; ++k) {
            ++j;
        }
        if (j == 0 || j % 3 != 0) {
            return null;
        }
        int[] arrayOfInt = new int[j];
        j = i;
        int k = 0;
        while (j < sb.m_styles.length && sb.m_styles[j] != -1) {
            arrayOfInt[k++] = sb.m_styles[j++];
        }
        return arrayOfInt;
    }

    public static int getShort(byte[] paramArrayOfByte, int paramInt) {
        return (paramArrayOfByte[paramInt + 1] & 0xFF) << 8 | paramArrayOfByte[paramInt] & 0xFF;
    }

    public static final int[] getVarint(byte[] paramArrayOfByte, int paramInt) {
        int i = paramArrayOfByte[paramInt];
        boolean j = (i & 0x80) != 0;
        i &= 0x7F;
        if (!j) {
            return new int[]{i, 1};
        }
        return new int[]{i << 8 | paramArrayOfByte[paramInt + 1] & 0xFF, 2};
    }

    public static String decodeString(StringBlock sb, int paramInt1, int paramInt2) {
        try {
            return (sb.m_isUTF8 ? UTF8_DECODER : UTF16LE_DECODER).decode(ByteBuffer.wrap(sb.m_strings, paramInt1, paramInt2)).toString();
        }
        catch (CharacterCodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void outputStyleTag(String paramString, StringBuilder paramStringBuilder, boolean paramBoolean) {
        paramStringBuilder.append('<');
        if (paramBoolean) {
            paramStringBuilder.append('/');
        }
        if (paramString != null) {
            int i = paramString.indexOf(59);
            if (i == -1) {
                paramStringBuilder.append(paramString);
            } else {
                paramStringBuilder.append(paramString.substring(0, i));
                if (!paramBoolean) {
                    boolean j = true;
                    while (j) {
                        String str;
                        int k = paramString.indexOf(61, i + 1);
                        paramStringBuilder.append(' ').append(paramString.substring(i + 1, k)).append("=\"");
                        i = paramString.indexOf(59, k + 1);
                        if (i != -1) {
                            str = paramString.substring(k + 1, i);
                        } else {
                            j = false;
                            str = paramString.substring(k + 1);
                        }
                        paramStringBuilder.append(ResourceDecoder.escapeCharsForResXml(str)).append('\"');
                    }
                }
            }
        }
        paramStringBuilder.append('>');
    }
}

