/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.pm.APKInfo;
import android.content.res.AXmlResourceParser;
import android.os.Bundle;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;

public class AXMLPrinter {
    public static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.051758E-5f, 1.192093E-7f, 4.656613E-10f};
    public static final String[] DIMENSION_UNITS = new String[]{"px", "dip", "sp", "pt", "in", "mm", "", ""};
    public static final String[] FRACTION_UNITS = new String[]{"%", "%p", "", "", "", "", "", ""};

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void parserXML(InputStream is, APKInfo info, int flag) {
        parser = new AXmlResourceParser();
        parser.open(is);
        bGetMetaData = false;
        if ((flag & 2) > 0) {
            bGetMetaData = true;
            info.metaData = new Bundle();
        }
        try {
            block11: while (true) {
                if ((type = parser.next()) == 1) {
                    return;
                }
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        strTagName = parser.getName();
                        namespaceCountBefore = parser.getNamespaceCount(parser.getDepth() - 1);
                        namespaceCount = parser.getNamespaceCount(parser.getDepth());
                        for (i = namespaceCountBefore; i != namespaceCount; ++i) {
                        }
                        android_name = null;
                        android_value = null;
                        i = 0;
                        while (true) {
                            if (i == parser.getAttributeCount()) continue block11;
                            strValue = parser.getAttributeValue(i);
                            str = parser.getAttributeName(i);
                            if (!str.equals("package")) ** GOTO lbl30
                            info.packageName = strValue;
                            ** GOTO lbl76
lbl30:
                            // 1 sources

                            if (!str.equals("versionCode")) ** GOTO lbl37
                            try {
                                info.versionCode = Integer.parseInt(strValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ** GOTO lbl76
lbl37:
                            // 1 sources

                            if (!str.equals("versionName")) ** GOTO lbl40
                            info.versionName = strValue;
                            ** GOTO lbl76
lbl40:
                            // 1 sources

                            if (!str.equals("minSdkVersion")) ** GOTO lbl47
                            try {
                                info.miniSDKVersion = Integer.parseInt(strValue);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            ** GOTO lbl76
lbl47:
                            // 1 sources

                            if (!strTagName.equals("uses-permission") || !str.equals("name")) ** GOTO lbl58
                            index = strValue.indexOf("permission");
                            if (index > 0) {
                                if (info.permission_list == null) {
                                    info.permission_list = new ArrayList<E>();
                                    info.permission_list.add(strValue);
                                } else {
                                    info.permission_list.add(strValue);
                                }
                            }
                            ** GOTO lbl76
lbl58:
                            // 1 sources

                            if (strTagName.equals("application") && str.equals("icon")) {
                                info.iconResName = strValue;
                            } else if (strTagName.equals("application") && str.equals("label")) {
                                info.application_res_name = strValue;
                                if (!info.application_res_name.startsWith("@")) {
                                    info.application_name = info.application_res_name;
                                }
                            } else if (bGetMetaData && strTagName.equals("meta-data")) {
                                if (str.equals("name")) {
                                    android_name = strValue;
                                } else if (str.equals("value")) {
                                    android_value = strValue;
                                }
                                if (android_name != null && android_value != null) {
                                    info.metaData.putString(android_name, android_value);
                                    android_name = null;
                                    android_value = null;
                                }
                            }
lbl76:
                            // 15 sources

                            ++i;
                        }
                    }
                    case 3: {
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] arguments) {
        try {
            int type;
            AXmlResourceParser parser = new AXmlResourceParser();
            parser.open(new FileInputStream("E:\\wifi_dialog.xml"));
            StringBuilder indent = new StringBuilder(10);
            String indentStep = "\t";
            while ((type = parser.next()) != 1) {
                switch (type) {
                    case 0: {
                        AXMLPrinter.log("<?xml version=\"1.0\" encoding=\"utf-8\"?>", new Object[0]);
                        break;
                    }
                    case 2: {
                        int i;
                        AXMLPrinter.log("%s<%s%s", indent, AXMLPrinter.getNamespacePrefix(parser.getPrefix()), parser.getName());
                        indent.append("\t");
                        int namespaceCountBefore = parser.getNamespaceCount(parser.getDepth() - 1);
                        int namespaceCount = parser.getNamespaceCount(parser.getDepth());
                        for (i = namespaceCountBefore; i != namespaceCount; ++i) {
                            AXMLPrinter.log("%sxmlns:%s=\"%s\"", indent, parser.getNamespacePrefix(i), parser.getNamespaceUri(i));
                        }
                        for (i = 0; i != parser.getAttributeCount(); ++i) {
                            AXMLPrinter.log("%s%s%s=\"%s\"", indent, AXMLPrinter.getNamespacePrefix(parser.getAttributePrefix(i)), parser.getAttributeName(i), AXMLPrinter.getAttributeValue(parser, i));
                        }
                        AXMLPrinter.log("%s>", indent);
                        break;
                    }
                    case 3: {
                        indent.setLength(indent.length() - "\t".length());
                        AXMLPrinter.log("%s</%s%s>", indent, AXMLPrinter.getNamespacePrefix(parser.getPrefix()), parser.getName());
                        break;
                    }
                    case 4: {
                        AXMLPrinter.log("%s%s", indent, parser.getText());
                    }
                }
            }
            System.out.println("xxx");
            parser.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getNamespacePrefix(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        return prefix + ":";
    }

    public static String getAttributeValue(AXmlResourceParser parser, int index) {
        int type = parser.getAttributeValueType(index);
        int data = parser.getAttributeValueData(index);
        if (type == 3) {
            return parser.getAttributeValue(index);
        }
        if (type == 2) {
            return String.format("?%s%08X", AXMLPrinter.getPackage(data), data);
        }
        if (type == 1) {
            return String.format("@%s%08X", AXMLPrinter.getPackage(data), data);
        }
        if (type == 4) {
            return String.valueOf(Float.intBitsToFloat(data));
        }
        if (type == 17) {
            return String.format("0x%08X", data);
        }
        if (type == 18) {
            return data != 0 ? "true" : "false";
        }
        if (type == 5) {
            return Float.toString(AXMLPrinter.complexToFloat(data)) + DIMENSION_UNITS[data & 0xF];
        }
        if (type == 6) {
            return Float.toString(AXMLPrinter.complexToFloat(data)) + FRACTION_UNITS[data & 0xF];
        }
        if (type >= 28 && type <= 31) {
            return String.format("#%08X", data);
        }
        if (type >= 16 && type <= 31) {
            return String.valueOf(data);
        }
        return String.format("<0x%X, type 0x%02X>", data, type);
    }

    public static String getPackage(int id) {
        if (id >>> 24 == 1) {
            return "android:";
        }
        return "";
    }

    public static void log(String format, Object ... arguments) {
        System.out.printf(format, arguments);
        System.out.println();
    }

    public static float complexToFloat(int complex) {
        return (float)(complex & 0xFFFFFF00) * RADIX_MULTS[complex >> 4 & 3];
    }
}

