/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.lib.adapter;

import android.content.Context;
import android.support.annotation.Nullable;
import android.view.View;
import com.bihe0832.android.lib.adapter.CardBaseHolder;
import com.bihe0832.android.lib.adapter.CardBaseInnerModule;
import com.bihe0832.android.lib.log.ZLog;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class CardInfoHelper {
    private static final String TAG = "CardInfoHelper";
    private HashMap<Integer, Class<CardBaseHolder>> mCardList = new HashMap();
    private static volatile CardInfoHelper instance;
    private boolean mAutoAddItem = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CardInfoHelper getInstance() {
        if (instance != null) return instance;
        Class<CardInfoHelper> clazz = CardInfoHelper.class;
        synchronized (CardInfoHelper.class) {
            if (instance != null) return instance;
            instance = new CardInfoHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CardInfoHelper() {
    }

    public void setAutoAddItem(boolean autoAddItem) {
        this.mAutoAddItem = autoAddItem;
    }

    public boolean autoAddItem() {
        return this.mAutoAddItem;
    }

    public int getResIdByCardInfo(Class<? extends CardBaseInnerModule> module) {
        CardBaseInnerModule moduleItem = this.getItemByClass(module);
        if (null == moduleItem) {
            return -404;
        }
        return moduleItem.getResID();
    }

    public final void addCardItem(Class<? extends CardBaseInnerModule> module) {
        CardBaseInnerModule moduleItem = this.getItemByClass(module);
        if (null != moduleItem) {
            this.addCardItem(moduleItem.getResID(), moduleItem.getViewHolderClass());
        }
    }

    private CardBaseInnerModule getItemByClass(Class<? extends CardBaseInnerModule> module) {
        try {
            Constructor<?> ct = module.getConstructors()[0];
            ZLog.d((String)TAG, (String)("Constructor = " + ct.toString()));
            Class<?>[] params = ct.getParameterTypes();
            Object[] cArg = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                cArg[i] = this.getDefaultValue(params[i]);
            }
            CardBaseInnerModule moduleItem = (CardBaseInnerModule)ct.newInstance(cArg);
            return moduleItem;
        }
        catch (Exception e) {
            ZLog.e((String)TAG, (String)("class " + module + " should hava a no params Constructor!!!"));
            e.printStackTrace();
            return null;
        }
    }

    private Object getDefaultValue(Class clazz) {
        if (clazz.equals(Boolean.TYPE)) {
            return true;
        }
        if (clazz.equals(Byte.TYPE)) {
            return (byte)-128;
        }
        if (clazz.equals(Short.TYPE)) {
            return (short)Short.MIN_VALUE;
        }
        if (clazz.equals(Integer.TYPE)) {
            return Integer.MIN_VALUE;
        }
        if (clazz.equals(Long.TYPE)) {
            return Long.MIN_VALUE;
        }
        if (clazz.equals(Float.TYPE)) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        if (clazz.equals(Double.TYPE)) {
            return Double.MIN_VALUE;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public final void addCardItem(int resID, Class<? extends CardBaseHolder> holderCalss) {
        ZLog.d((String)TAG, (String)("addCardItem:" + resID + " " + holderCalss.toString()));
        if (!this.mCardList.containsKey(resID) && holderCalss != null && CardBaseHolder.class.isAssignableFrom(holderCalss)) {
            ZLog.w((String)TAG, (String)("added CardItem:" + resID + " " + holderCalss.toString()));
            this.mCardList.put(resID, holderCalss);
        }
    }

    @Nullable
    public final CardBaseHolder createViewHolder(int cardType, @Nullable View itemView, @Nullable Context context) {
        try {
            Class<CardBaseHolder> holderClass = this.mCardList.get(cardType);
            if (holderClass != null) {
                return holderClass.getConstructor(View.class, Context.class).newInstance(itemView, context);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

