/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.framework.image;

import android.app.ActivityManager;
import android.content.Context;
import com.bihe0832.android.framework.ZixieContext;
import com.bumptech.glide.Glide;
import com.bumptech.glide.GlideBuilder;
import com.bumptech.glide.Registry;
import com.bumptech.glide.annotation.GlideModule;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPoolAdapter;
import com.bumptech.glide.load.engine.bitmap_recycle.LruArrayPool;
import com.bumptech.glide.load.engine.bitmap_recycle.LruBitmapPool;
import com.bumptech.glide.load.engine.cache.DiskCache;
import com.bumptech.glide.load.engine.cache.InternalCacheDiskCacheFactory;
import com.bumptech.glide.load.engine.cache.LruResourceCache;
import com.bumptech.glide.load.engine.cache.MemoryCache;
import com.bumptech.glide.load.engine.cache.MemorySizeCalculator;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.module.AppGlideModule;
import com.bumptech.glide.request.RequestOptions;

@GlideModule
public class AAFAppGlideModule
extends AppGlideModule {
    public boolean isManifestParsingEnabled() {
        return false;
    }

    public void applyOptions(Context context, GlideBuilder builder) {
        super.applyOptions(context, builder);
        MemorySizeCalculator calculator = new MemorySizeCalculator.Builder(context).setMemoryCacheScreens(2.0f).build();
        int defaultMemoryCacheSize = calculator.getMemoryCacheSize();
        builder.setMemoryCache((MemoryCache)new LruResourceCache((long)(defaultMemoryCacheSize / 2)));
        int defaultBitmapPoolSize = calculator.getBitmapPoolSize();
        if (defaultBitmapPoolSize > 0) {
            builder.setBitmapPool((BitmapPool)new LruBitmapPool((long)(defaultBitmapPoolSize / 2)));
        } else {
            builder.setBitmapPool((BitmapPool)new BitmapPoolAdapter());
        }
        int defaultArrayPoolSize = calculator.getArrayPoolSizeInBytes();
        builder.setArrayPool((ArrayPool)new LruArrayPool(defaultArrayPoolSize / 2));
        int diskCacheSizeBytes = 524288000;
        builder.setDiskCache((DiskCache.Factory)new InternalCacheDiskCacheFactory(context, "glide_cache", (long)diskCacheSizeBytes));
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo info = new ActivityManager.MemoryInfo();
        if (null != activityManager) {
            activityManager.getMemoryInfo(info);
        }
        builder.setDefaultRequestOptions((RequestOptions)((RequestOptions)((RequestOptions)new RequestOptions().downsample(DownsampleStrategy.CENTER_INSIDE)).format(info.lowMemory ? DecodeFormat.PREFER_RGB_565 : DecodeFormat.PREFER_ARGB_8888)).disallowHardwareConfig());
        int logLevel = 6;
        logLevel = ZixieContext.INSTANCE.isOfficial() ? 6 : (ZixieContext.INSTANCE.isDebug() ? 3 : 5);
        builder.setLogLevel(logLevel);
    }

    public void registerComponents(Context context, Glide glide, Registry registry) {
        super.registerComponents(context, glide, registry);
    }
}

