/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.framework.log;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.framework.log.LoggerFile;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.time.DateUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u000e\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u0007J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\nJ\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u0004J\u0016\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0007J\u0010\u0010*\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u000e\u0010+\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0010\u001a\u00020\u00118BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lcom/bihe0832/android/framework/log/LoggerFile;", "", "()V", "DEFAULT_DURATION", "", "mBufferedWriters", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/io/BufferedWriter;", "mCanSaveSpecialFile", "", "mContext", "Landroid/content/Context;", "mDuration", "mLogFiles", "Ljava/io/File;", "mLoggerFileHandler", "Landroid/os/Handler;", "getMLoggerFileHandler", "()Landroid/os/Handler;", "mLoggerFileHandler$delegate", "Lkotlin/Lazy;", "mLoggerHandlerThread", "Landroid/os/HandlerThread;", "getMLoggerHandlerThread", "()Landroid/os/HandlerThread;", "mLoggerHandlerThread$delegate", "bufferSave", "", "fileName", "msg", "checkOldFile", "file", "getZixieFileLogPathByModule", "module", "init", "context", "isDebug", "duration", "log", "filePath", "openLog", "reset", "sendLog", "Framework_release"})
public final class LoggerFile {
    private static boolean mCanSaveSpecialFile;
    private static Context mContext;
    private static final ConcurrentHashMap<String, File> mLogFiles;
    private static final ConcurrentHashMap<String, BufferedWriter> mBufferedWriters;
    private static final long DEFAULT_DURATION = 3600000L;
    private static long mDuration;
    private static final Lazy mLoggerHandlerThread$delegate;
    private static final Lazy mLoggerFileHandler$delegate;
    public static final LoggerFile INSTANCE;

    private final HandlerThread getMLoggerHandlerThread() {
        Lazy lazy = mLoggerHandlerThread$delegate;
        LoggerFile loggerFile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (HandlerThread)lazy.getValue();
    }

    private final Handler getMLoggerFileHandler() {
        Lazy lazy = mLoggerFileHandler$delegate;
        LoggerFile loggerFile = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Handler)lazy.getValue();
    }

    public final synchronized void init(@NotNull Context context, boolean isDebug, long duration) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        mContext = context;
        mCanSaveSpecialFile = isDebug;
        mDuration = duration > 3600000L ? duration : 3600000L;
    }

    public final synchronized void init(@NotNull Context context, boolean isDebug) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.init(context, isDebug, 604800000L);
    }

    private final synchronized void reset(String fileName) {
        if (mCanSaveSpecialFile && (mLogFiles.get(fileName) == null || mBufferedWriters.get(fileName) == null)) {
            try {
                File file = new File(fileName);
                if (!FileUtils.INSTANCE.checkFileExist(fileName)) {
                    file.createNewFile();
                }
                this.checkOldFile(file);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                ((Map)mLogFiles).put(fileName, file);
                ((Map)mBufferedWriters).put(fileName, bufferedWriter);
            }
            catch (Exception e) {
                ZLog.e((String)"ZLog FLIE ERROR !!!!");
                e.printStackTrace();
            }
        }
    }

    private final void checkOldFile(File file) {
        File file2 = file.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file.parentFile");
        FileUtils.INSTANCE.deleteOldAsync(file2, mDuration);
    }

    private final void bufferSave(String fileName, String msg) {
        this.getMLoggerFileHandler().post(new Runnable(fileName, msg){
            final /* synthetic */ String $fileName;
            final /* synthetic */ String $msg;

            public final void run() {
                try {
                    BufferedWriter bufferedWriter = (BufferedWriter)LoggerFile.access$getMBufferedWriters$p(LoggerFile.INSTANCE).get(this.$fileName);
                    if (bufferedWriter != null) {
                        bufferedWriter.write(DateUtil.getCurrentDateEN() + ' ' + this.$msg);
                    }
                    BufferedWriter bufferedWriter2 = (BufferedWriter)LoggerFile.access$getMBufferedWriters$p(LoggerFile.INSTANCE).get(this.$fileName);
                    if (bufferedWriter2 != null) {
                        bufferedWriter2.newLine();
                    }
                    BufferedWriter bufferedWriter3 = (BufferedWriter)LoggerFile.access$getMBufferedWriters$p(LoggerFile.INSTANCE).get(this.$fileName);
                    if (bufferedWriter3 != null) {
                        bufferedWriter3.flush();
                    }
                }
                catch (Exception e) {
                    ZLog.e((String)"ZLog FLIE  ERROR !!!!");
                    e.printStackTrace();
                }
            }
            {
                this.$fileName = string2;
                this.$msg = string3;
            }
        });
    }

    @NotNull
    public final String getZixieFileLogPathByModule(@NotNull String module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return ZixieContext.INSTANCE.getLogFolder() + module + '_' + DateUtil.getCurrentDateEN((String)"yyyyMMdd") + ".txt";
    }

    public final void log(@NotNull String filePath, @NotNull String msg) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        ZLog.info((String)FileUtils.INSTANCE.getFileNameWithoutEx(filePath), (String)msg);
        try {
            if (mCanSaveSpecialFile) {
                this.reset(filePath);
                this.bufferSave(filePath, msg);
            }
        }
        catch (Exception e) {
            ZLog.e((String)"Logger ERROR !!!!");
            e.printStackTrace();
        }
    }

    public final void openLog(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            Context context = mContext;
            if (context != null) {
                Context context2 = context;
                boolean bl = false;
                boolean bl2 = false;
                Context it = context2;
                boolean bl3 = false;
                FileUtils.INSTANCE.openFile(it, filePath, "*/*");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void sendLog(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        try {
            Context context = mContext;
            if (context != null) {
                Context context2 = context;
                boolean bl = false;
                boolean bl2 = false;
                Context context3 = context2;
                boolean bl3 = false;
                try {
                    Boolean bl4 = FileUtils.INSTANCE.sendFile(context3, filePath, "*/*");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        catch (Exception e) {
            ZLog.e((String)"Logger ERROR !!!!");
            e.printStackTrace();
        }
    }

    private LoggerFile() {
    }

    static {
        LoggerFile loggerFile;
        INSTANCE = loggerFile = new LoggerFile();
        mLogFiles = new ConcurrentHashMap();
        mBufferedWriters = new ConcurrentHashMap();
        mDuration = 3600000L;
        mLoggerHandlerThread$delegate = LazyKt.lazy((Function0)mLoggerHandlerThread.2.INSTANCE);
        mLoggerFileHandler$delegate = LazyKt.lazy((Function0)mLoggerFileHandler.2.INSTANCE);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getMBufferedWriters$p(LoggerFile $this) {
        LoggerFile loggerFile = $this;
        return mBufferedWriters;
    }

    public static final /* synthetic */ HandlerThread access$getMLoggerHandlerThread$p(LoggerFile $this) {
        return $this.getMLoggerHandlerThread();
    }
}

