/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.framework.debug;

import android.content.Context;
import android.view.View;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.lib.debug.DebugTools;
import com.bihe0832.android.lib.lifecycle.LifecycleHelper;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.apk.APKUtils;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bihe0832.android.lib.utils.os.ManufacturerUtil;
import com.bihe0832.android.lib.utils.time.DateUtil;

public class ShowDebugClick
implements View.OnClickListener {
    private static final String TAG = "ShowDebugClick";
    private static final long MIN_CLICK_INTERVAL = 500L;
    private long mLastClickTime;
    private int mSecretNumber = 0;

    protected void onClickAction() {
    }

    protected void onDebugAction() {
    }

    protected String getExtraInfo() {
        return "";
    }

    public void onClick(View v) {
        long currentClickTime = System.currentTimeMillis();
        long elapsedTime = currentClickTime - this.mLastClickTime;
        ZLog.d((String)("ShowDebugClickcurrentClickTime:" + currentClickTime));
        ZLog.d((String)("ShowDebugClickmLastClickTime:" + this.mLastClickTime));
        ZLog.d((String)("ShowDebugClickelapsedTime:" + elapsedTime));
        ZLog.d((String)"ShowDebugClickduration:500");
        ZLog.d((String)("ShowDebugClicknum:" + this.mSecretNumber));
        this.mLastClickTime = currentClickTime;
        if (elapsedTime < 500L) {
            ++this.mSecretNumber;
            if (4 == this.mSecretNumber) {
                this.sendInfo(v.getContext());
                this.onDebugAction();
                this.mSecretNumber = 0;
            }
        } else {
            this.mSecretNumber = 0;
        }
        this.onClickAction();
    }

    protected void sendInfo(Context ctx) {
        String result = this.getDebugInfo(ctx) + "\u5176\u4ed6\u4fe1\u606f: \n" + this.getExtraInfo() + "\n";
        DebugTools.sendInfo((Context)ctx, (String)"\u8bf7\u8f6c\u53d1\u7ed9\u5f00\u53d1\u8005", (String)result, (boolean)true);
    }

    public String getDebugInfo(Context ctx) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDebugVersionInfo(ctx));
        builder.append(this.getDebugDeviceInfo());
        return builder.toString();
    }

    public String getDebugVersionInfo(Context ctx) {
        StringBuilder builder = new StringBuilder();
        builder.append("\u7248\u672c\u4fe1\u606f: \n");
        builder.append("version: " + ZixieContext.INSTANCE.getVersionName() + "." + ZixieContext.INSTANCE.getVersionCode() + "\n");
        builder.append("Tag: " + ZixieContext.INSTANCE.getVersionTag() + "\n");
        builder.append("\u5b89\u88c5\u65f6\u95f4:" + DateUtil.getDateEN((long)LifecycleHelper.INSTANCE.getVersionInstalledTime()) + "\n");
        builder.append("channel: " + ZixieContext.INSTANCE.getChannelID() + "\n");
        builder.append("\u7b7e\u540dMD5: " + APKUtils.getSigMd5ByPkgName((Context)ctx, (String)ctx.getPackageName()) + "\n");
        builder.append("official: " + ZixieContext.INSTANCE.isOfficial() + "\n\n");
        return builder.toString();
    }

    public String getDebugDeviceInfo() {
        StringBuilder builder = new StringBuilder();
        builder.append("\u8bbe\u5907\u4fe1\u606f: \n");
        builder.append("\u5382\u5546&\u578b\u53f7: " + ManufacturerUtil.INSTANCE.getMANUFACTURER() + ", " + ManufacturerUtil.INSTANCE.getMODEL() + "\n");
        if (ManufacturerUtil.INSTANCE.isHarmonyOs()) {
            builder.append("\u7cfb\u7edf\u7248\u672c: " + BuildUtils.INSTANCE.getRELEASE() + ", " + BuildUtils.INSTANCE.getSDK_INT() + ", Harmony(" + ManufacturerUtil.INSTANCE.getHarmonyVersion() + ")\n");
        } else {
            builder.append("\u7cfb\u7edf\u7248\u672c: " + BuildUtils.INSTANCE.getRELEASE() + ", " + BuildUtils.INSTANCE.getSDK_INT() + "\n");
        }
        builder.append("\u7cfb\u7edf\u6307\u7eb9: " + ManufacturerUtil.INSTANCE.getFINGERPRINT() + "\n");
        builder.append("deviceId: " + ZixieContext.INSTANCE.getDeviceId() + "\n\n");
        return builder.toString();
    }
}

