/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.webview.base;

import android.content.Context;
import android.net.Uri;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.tencent.smtt.sdk.CookieManager;
import com.tencent.smtt.sdk.CookieSyncManager;
import com.tencent.smtt.sdk.WebView;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0006J\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J&\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015J8\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\f\u00a8\u0006\u0017"}, d2={"Lcom/bihe0832/android/common/webview/base/CookieManagerForZixie;", "", "()V", "getCookieManager", "Lcom/tencent/smtt/sdk/CookieManager;", "getCookieString", "", "name", "value", "path", "domain", "init", "", "mWebView", "Lcom/tencent/smtt/sdk/WebView;", "logCookieForDomain", "url", "removeAllCookie", "removeCookiesForDomain", "setCookie", "time", "", "syncCookie", "CommonWebview_release"})
public final class CookieManagerForZixie {
    public static final CookieManagerForZixie INSTANCE;

    public final void init(@NotNull WebView mWebView) {
        Intrinsics.checkParameterIsNotNull((Object)mWebView, (String)"mWebView");
        CookieSyncManager.createInstance((Context)mWebView.getContext());
        this.getCookieManager().setAcceptCookie(true);
        if (BuildUtils.INSTANCE.getSDK_INT() >= 21) {
            this.getCookieManager().setAcceptThirdPartyCookies(mWebView, true);
        }
        this.syncCookie();
    }

    @NotNull
    public final CookieManager getCookieManager() {
        CookieManager cookieManager = CookieManager.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)cookieManager, (String)"CookieManager.getInstance()");
        return cookieManager;
    }

    public final void syncCookie() {
        if (BuildUtils.INSTANCE.getSDK_INT() >= 22) {
            CookieManager.getInstance().flush();
        } else {
            CookieSyncManager.getInstance().sync();
        }
    }

    public final void removeAllCookie() {
        this.getCookieManager().removeAllCookie();
        this.syncCookie();
    }

    public final void removeCookiesForDomain(@NotNull String url) {
        String cookiesForDomain;
        String domain;
        int n;
        String string;
        block12: {
            String string2;
            block11: {
                Uri uri;
                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                Uri uri2 = uri = Uri.parse((String)url);
                Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
                if (uri2.getHost() == null) {
                    return;
                }
                string2 = uri.getHost();
                if (string2 == null) break block11;
                string = string2;
                n = 0;
                String string3 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                string2 = string4;
                if (string4 != null) break block12;
            }
            string2 = domain = "";
        }
        if (BuildUtils.INSTANCE.getSDK_INT() < 11 && StringsKt.startsWith$default((String)domain, (String)".", (boolean)false, (int)2, null)) {
            string = domain;
            n = 1;
            boolean bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            domain = string6;
        }
        if ((cookiesForDomain = this.getCookieManager().getCookie(domain)) != null) {
            String[] cookies;
            CharSequence charSequence = cookiesForDomain;
            String string7 = ";";
            int n2 = 0;
            string7 = new Regex(string7);
            n2 = 0;
            int n3 = 0;
            Collection $this$toTypedArray$iv = string7.split(charSequence, n2);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String cookieTuple : cookies = stringArray) {
                String[] cookieParts;
                CharSequence charSequence2 = cookieTuple;
                String string8 = "=";
                int n4 = 0;
                string8 = new Regex(string8);
                n4 = 0;
                boolean bl = false;
                Collection $this$toTypedArray$iv2 = string8.split(charSequence2, n4);
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv2;
                if (thisCollection$iv2.toArray(new String[0]) == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                this.getCookieManager().setCookie(url, this.getCookieString(cookieParts[0], "", domain) + "; Expires=Thu, 12 Aug 2021 21:13:52 GMT");
            }
            this.syncCookie();
        }
    }

    public final void logCookieForDomain(@NotNull String url) {
        String string;
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        ZLog.d((String)"Cookie", (String)("========= Cookies for url:" + url + " ========="));
        Uri uri2 = uri = Uri.parse((String)url);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
        if (uri2.getHost() == null) {
            return;
        }
        CookieManager cookieManager = this.getCookieManager();
        String string2 = uri.getHost();
        if (string2 != null) {
            String string3 = string2;
            CookieManager cookieManager2 = cookieManager;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
            String string6 = string5;
            cookieManager = cookieManager2;
            string = string6;
        } else {
            string = null;
        }
        String cookiesForDomain = cookieManager.getCookie(string);
        if (cookiesForDomain != null) {
            String[] cookies;
            CharSequence charSequence = cookiesForDomain;
            String string7 = ";";
            int n = 0;
            string7 = new Regex(string7);
            n = 0;
            int n2 = 0;
            Collection $this$toTypedArray$iv = string7.split(charSequence, n);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            for (String cookieTuple : cookies = stringArray) {
                ZLog.d((String)"Cookie", (String)cookieTuple);
            }
        }
        ZLog.d((String)"Cookie", (String)("========= Cookies for url:" + url + " ========="));
    }

    @NotNull
    public final String getCookieString(@NotNull String name, @NotNull String value, @Nullable String domain) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.getCookieString(name, value, "/", domain);
    }

    @NotNull
    public final String getCookieString(@NotNull String name, @NotNull String value, @NotNull String path, @Nullable String domain) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        String v = name + '=' + value;
        if (domain != null) {
            v = v + "; path=" + path;
            v = v + "; domain=" + domain;
        }
        return v;
    }

    public final void setCookie(@NotNull String url, @NotNull String name, @NotNull String value, @NotNull String path, @Nullable String domain, long time) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.getCookieManager().setCookie(url, this.getCookieString(name, value, path, domain) + "; MAX-Age=" + time);
    }

    public final void setCookie(@NotNull String url, @NotNull String name, @NotNull String value, @NotNull String path, long time) {
        String string;
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Uri uri2 = uri = Uri.parse((String)url);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri2, (String)"uri");
        if (uri2.getHost() == null) {
            return;
        }
        CookieManagerForZixie cookieManagerForZixie = this;
        String string2 = url;
        String string3 = name;
        String string4 = value;
        String string5 = path;
        String string6 = uri.getHost();
        if (string6 != null) {
            String string7 = string6;
            String string8 = string5;
            String string9 = string4;
            String string10 = string3;
            String string11 = string2;
            CookieManagerForZixie cookieManagerForZixie2 = cookieManagerForZixie;
            boolean bl = false;
            String string12 = string7;
            if (string12 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string13 = string12.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.String).toLowerCase()");
            String string14 = string13;
            cookieManagerForZixie = cookieManagerForZixie2;
            string2 = string11;
            string3 = string10;
            string4 = string9;
            string5 = string8;
            string = string14;
        } else {
            string = null;
        }
        cookieManagerForZixie.setCookie(string2, string3, string4, string5, string, time);
    }

    public final void setCookie(@NotNull String url, @NotNull String name, @NotNull String value, long time) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.setCookie(url, name, value, "/", time);
    }

    public final void setCookie(@NotNull String url, @NotNull String name, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.setCookie(url, name, value, 86400L);
    }

    private CookieManagerForZixie() {
    }

    static {
        CookieManagerForZixie cookieManagerForZixie;
        INSTANCE = cookieManagerForZixie = new CookieManagerForZixie();
    }
}

