/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.webview.base;

import android.arch.lifecycle.LifecycleOwner;
import android.arch.lifecycle.Observer;
import android.arch.lifecycle.ViewModelProviders;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.text.TextUtils;
import android.view.View;
import com.bihe0832.android.common.webview.R;
import com.bihe0832.android.common.webview.base.BaseWebviewFragment;
import com.bihe0832.android.common.webview.base.WebViewViewModel;
import com.bihe0832.android.common.webview.log.WebviewLoggerFile;
import com.bihe0832.android.framework.ui.main.CommonActivity;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.bihe0832.android.lib.utils.intent.IntentUtils;
import com.tencent.smtt.sdk.QbSdk;
import java.net.URLDecoder;
import me.yokeyword.fragmentation.ISupportFragment;

public abstract class BaseWebviewActivity
extends CommonActivity {
    private static final String TAG = "WebPageActivity";
    private WebViewViewModel mWebViewViewModel;
    protected String mURL = "";

    protected abstract BaseWebviewFragment getWebViewFragment();

    protected abstract Class getWebViewFragmentClass();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mWebViewViewModel = (WebViewViewModel)ViewModelProviders.of((FragmentActivity)this).get(WebViewViewModel.class);
        WebviewLoggerFile.INSTANCE.log("BaseWebviewActivity mWebViewViewModel: " + ((Object)((Object)this.mWebViewViewModel)).hashCode());
        ZLog.d((String)(TAG + QbSdk.getTbsVersion((Context)this)));
        this.handleIntent(this.getIntent());
    }

    protected void onNewIntent(Intent intent) {
        try {
            if ("android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
                this.handleIntent(intent);
                ((BaseWebviewFragment)this.findFragment(this.getWebViewFragmentClass())).loadUrl(this.mURL, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void handleIntent(Intent intent) {
        if ("android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
            this.mURL = intent.getData().toString();
        } else if (intent.hasExtra("url")) {
            this.mURL = URLDecoder.decode(intent.getStringExtra("url"));
        } else if (intent.hasExtra("redirect")) {
            String redirectURL = URLDecoder.decode(intent.getStringExtra("redirect"));
            IntentUtils.openWebPage((String)redirectURL, (Context)this);
            this.finish();
        } else {
            WebviewLoggerFile.INSTANCE.log("handle intent, but extra is bad");
        }
        if (intent.hasExtra("showtitle") && ConvertUtils.parseInt((String)intent.getStringExtra("showtitle"), (int)1) == 0) {
            this.findViewById(R.id.common_toolbar).setVisibility(8);
        } else {
            this.initToolbar();
        }
    }

    protected void initToolbar() {
        this.initToolbar(R.id.common_toolbar, "", true);
        this.getMToolbar().setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BaseWebviewActivity.this.finish();
            }
        });
        this.mWebViewViewModel.getTitleLiveData().observe((LifecycleOwner)this, (Observer)new Observer<String>(){

            public void onChanged(@Nullable String s) {
                if (!s.equals("about:blank")) {
                    BaseWebviewActivity.this.updateTitle(s);
                }
                WebviewLoggerFile.INSTANCE.log("mWebViewViewModel: " + this.hashCode() + "  title: " + s);
            }
        });
    }

    protected void onResume() {
        super.onResume();
        if (TextUtils.isEmpty((CharSequence)this.mURL)) {
            WebviewLoggerFile.INSTANCE.log("WebPageActivity onResume, extra is good, but value is bad");
            this.finish();
            return;
        }
        WebviewLoggerFile.INSTANCE.log("WebPageActivity onResume:" + this.mURL);
        if (this.findFragment(this.getWebViewFragmentClass()) == null) {
            this.loadRootFragment(R.id.common_fragment_content, (ISupportFragment)this.getWebViewFragment());
        }
    }
}

