/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.svga;

import android.content.Context;
import android.net.http.HttpResponseCache;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.lib.download.DownloadItem;
import com.bihe0832.android.lib.download.DownloadListener;
import com.bihe0832.android.lib.download.wrapper.DownloadFile;
import com.bihe0832.android.lib.download.wrapper.SimpleDownloadListener;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.utils.encrypt.SHA256;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAParser;
import com.opensource.svgaplayer.SVGASoundManager;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.opensource.svgaplayer.utils.log.SVGALogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u0012\u001a\u00020\u0013\u00a8\u0006\u0015"}, d2={"Lcom/bihe0832/android/common/svga/SVGAHelper;", "", "()V", "playAssets", "", "svgaName", "", "callback", "Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "playFile", "path", "playInputStream", "inputStream", "Ljava/io/InputStream;", "key", "playURL", "url", "md5", "shareParser", "Lcom/opensource/svgaplayer/SVGAParser;", "CommonSVGAParserParseCompletion", "CommonSvga_release"})
public final class SVGAHelper {
    @NotNull
    public static final SVGAHelper INSTANCE = new SVGAHelper();

    private SVGAHelper() {
    }

    @NotNull
    public final SVGAParser shareParser() {
        return SVGAParser.Companion.shareParser();
    }

    public final void playInputStream(@NotNull InputStream inputStream, @NotNull String key, @NotNull SVGAParser.ParseCompletion callback) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        SVGAParser.decodeFromInputStream$default((SVGAParser)this.shareParser(), (InputStream)inputStream, (String)key, (SVGAParser.ParseCompletion)callback, (boolean)false, null, null, (int)56, null);
    }

    public final void playAssets(@NotNull String svgaName, @NotNull SVGAParser.ParseCompletion callback) {
        Intrinsics.checkNotNullParameter((Object)svgaName, (String)"svgaName");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            Context context = ZixieContext.INSTANCE.getApplicationContext();
            Intrinsics.checkNotNull((Object)context);
            InputStream inputStream = context.getAssets().open(svgaName);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"ZixieContext.application\u2026t!!.assets.open(svgaName)");
            this.playInputStream(inputStream, "assets_" + SHA256.getSHA256((String)("file:///assets/" + svgaName)), callback);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void playFile(@NotNull String path, @NotNull SVGAParser.ParseCompletion callback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (FileUtils.INSTANCE.checkFileExist(path)) {
            try {
                this.playInputStream(new FileInputStream(new File(path)), "file_" + FileUtils.INSTANCE.getFileSHA256(path), callback);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final void playURL(@NotNull String url, @NotNull String md5, @NotNull SVGAParser.ParseCompletion callback) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)md5, (String)"md5");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        try {
            Context context = ZixieContext.INSTANCE.getApplicationContext();
            Intrinsics.checkNotNull((Object)context);
            DownloadFile.INSTANCE.forceDownload(context, url, "", md5, (DownloadListener)new SimpleDownloadListener(callback){
                final /* synthetic */ SVGAParser.ParseCompletion $callback;
                {
                    this.$callback = $callback;
                }

                public void onComplete(@NotNull String filePath, @NotNull DownloadItem item) {
                    Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    SVGAHelper.INSTANCE.playFile(filePath, this.$callback);
                }

                public void onFail(int errorCode, @NotNull String msg, @NotNull DownloadItem item) {
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                }

                public void onProgress(@NotNull DownloadItem item) {
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SVGAParser sVGAParser = INSTANCE.shareParser();
        Context context = ZixieContext.INSTANCE.getApplicationContext();
        Intrinsics.checkNotNull((Object)context);
        sVGAParser.init(context);
        SVGALogger.INSTANCE.setLogEnabled(!ZixieContext.INSTANCE.isOfficial());
        SVGASoundManager.INSTANCE.init();
        File cacheDir = new File(ZixieContext.INSTANCE.getZixieFolder(), "temp/svga");
        FileUtils.INSTANCE.deleteOldAsync(cacheDir, 5184000000L);
        HttpResponseCache.install((File)cacheDir, (long)0x8000000L);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/bihe0832/android/common/svga/SVGAHelper$CommonSVGAParserParseCompletion;", "Lcom/opensource/svgaplayer/SVGAParser$ParseCompletion;", "mSVGAImageView", "Lcom/opensource/svgaplayer/SVGAImageView;", "(Lcom/opensource/svgaplayer/SVGAImageView;)V", "onComplete", "", "videoItem", "Lcom/opensource/svgaplayer/SVGAVideoEntity;", "onError", "CommonSvga_release"})
    public static final class CommonSVGAParserParseCompletion
    implements SVGAParser.ParseCompletion {
        @Nullable
        private final SVGAImageView mSVGAImageView;

        public CommonSVGAParserParseCompletion(@Nullable SVGAImageView mSVGAImageView) {
            this.mSVGAImageView = mSVGAImageView;
        }

        public void onComplete(@NotNull SVGAVideoEntity videoItem) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)videoItem, (String)"videoItem");
                SVGAImageView sVGAImageView = this.mSVGAImageView;
                if (sVGAImageView != null) {
                    sVGAImageView.setVideoItem(videoItem);
                }
                SVGAImageView sVGAImageView2 = this.mSVGAImageView;
                if (sVGAImageView2 == null) break block1;
                sVGAImageView2.startAnimation();
            }
        }

        public void onError() {
        }
    }
}

