/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import com.bihe0832.android.framework.ZixieContext;
import com.bihe0832.android.lib.log.ZLog;
import com.bihe0832.android.lib.network.DeviceInfoManager;
import com.bihe0832.android.lib.network.MobileUtil;
import com.bihe0832.android.lib.network.NetworkUtil;
import com.bihe0832.android.lib.network.WifiManagerWrapper;
import com.bihe0832.android.lib.thread.ThreadManager;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class NetworkChangeManager {
    private static final String TAG = "NetworkChangeManager";
    private int mNetType = 0;
    private boolean canGetNetType = false;
    private boolean canGetBSSID = false;
    private boolean canGetCELLID = false;
    private String mWifiBssId = "unknown";
    private String mCellID = "-1_-1_-1_-1";
    private BroadcastReceiver mNetReceiver = null;
    private Handler mBgHandler = null;
    private ArrayList<NetworkChangeListener> networkChangeListeners = new ArrayList();
    private static volatile NetworkChangeManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetworkChangeManager getInstance() {
        if (instance != null) return instance;
        Class<NetworkChangeManager> clazz = NetworkChangeManager.class;
        synchronized (NetworkChangeManager.class) {
            if (instance != null) return instance;
            instance = new NetworkChangeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private NetworkChangeManager() {
    }

    public void init(Context context, boolean getNetType) {
        this.init(context, getNetType, false, false);
    }

    public void init(Context context, boolean getNetType, boolean getBssID, boolean curCellId) {
        DeviceInfoManager.getInstance().init(context.getApplicationContext());
        this.canGetNetType = getNetType;
        this.canGetBSSID = getBssID;
        this.canGetCELLID = curCellId;
        this.mBgHandler = new Handler(ThreadManager.getInstance().getLooper(1));
        WifiManagerWrapper.INSTANCE.init(context, ZixieContext.INSTANCE.isDebug());
        if (this.canGetNetType) {
            this.mNetType = WifiManagerWrapper.INSTANCE.getNetType(context);
        }
        if (NetworkUtil.isWifiNet((int)this.mNetType) && this.canGetBSSID) {
            this.mWifiBssId = WifiManagerWrapper.INSTANCE.getBSSID();
        } else if (NetworkUtil.isMobileNet((int)this.mNetType) && this.canGetCELLID) {
            this.mCellID = MobileUtil.getPhoneCellInfo((Context)context);
        }
        this.listenNetChange(context);
    }

    private void listenNetChange(Context ctx) {
        this.mNetReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                NetworkChangeManager.this.change(context.getApplicationContext(), intent);
            }
        };
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        ctx.registerReceiver(this.mNetReceiver, intentFilter);
    }

    private void change(final Context context, final Intent intent) {
        ZLog.d((String)TAG, (String)"change");
        if (this.mBgHandler == null) {
            this.init(context, this.canGetNetType, this.canGetBSSID, this.canGetCELLID);
            return;
        }
        ThreadManager.getInstance().start(new Runnable(){

            @Override
            public void run() {
                int curNetType = WifiManagerWrapper.INSTANCE.getNetType(context);
                ZLog.d((String)NetworkChangeManager.TAG, (String)("network change >> netType: " + curNetType + ", sPreNetType: " + NetworkChangeManager.this.mNetType));
                String curBssid = "unknown";
                String curCellId = "-1_-1_-1_-1";
                String curWifiSsid = "";
                int curWifiSignal = 0;
                boolean needPost = false;
                ZLog.d((String)NetworkChangeManager.TAG, (String)("network change >> netType correctAfter: " + curNetType + ",intent.getAction():" + intent.getAction()));
                if (NetworkUtil.isWifiNet((int)curNetType) && NetworkChangeManager.this.canGetBSSID) {
                    curBssid = WifiManagerWrapper.INSTANCE.getBSSID();
                    curWifiSsid = WifiManagerWrapper.INSTANCE.getSSID();
                    curWifiSignal = WifiManagerWrapper.INSTANCE.getSignalLevel();
                    if (curNetType != NetworkChangeManager.this.mNetType || NetworkChangeManager.this.mWifiBssId != null && !NetworkChangeManager.this.mWifiBssId.equals(curBssid)) {
                        needPost = true;
                    }
                } else if (NetworkUtil.isMobileNet((int)curNetType) && NetworkChangeManager.this.canGetCELLID) {
                    curCellId = MobileUtil.getPhoneCellInfo((Context)context);
                    if (curNetType != NetworkChangeManager.this.mNetType || NetworkChangeManager.this.mCellID != null && !NetworkChangeManager.this.mCellID.equals(curCellId)) {
                        needPost = true;
                    }
                } else if (curNetType != NetworkChangeManager.this.mNetType) {
                    needPost = true;
                }
                if (needPost) {
                    ZLog.e((String)NetworkChangeManager.TAG, (String)("notify change: preNetType:" + NetworkChangeManager.this.mNetType + " curNetType:" + curNetType + " curWifiSsid:" + curWifiSsid + " preBssId:" + NetworkChangeManager.this.mWifiBssId + " bssId:" + curBssid + " curWifiSignal:" + curWifiSignal + " curCellId:" + curCellId));
                    NetworkChangeManager.this.postNetworkChangeEvent(NetworkChangeManager.this.mNetType, curNetType, intent);
                    NetworkChangeManager.this.mWifiBssId = curBssid;
                    NetworkChangeManager.this.mCellID = curCellId;
                    NetworkChangeManager.this.mNetType = curNetType;
                }
            }
        });
    }

    public final void addListener(@NotNull NetworkChangeListener networkChangeListener) {
        if (null != networkChangeListener) {
            this.networkChangeListeners.add(networkChangeListener);
        }
    }

    public final void removeListener(@NotNull NetworkChangeListener networkChangeListener) {
        if (null != networkChangeListener) {
            this.networkChangeListeners.remove(networkChangeListener);
        }
    }

    public final void postNetworkChangeEvent(int sPreNetType, int curNetType, Intent intent) {
        for (NetworkChangeListener networkChangeListener : this.networkChangeListeners) {
            networkChangeListener.onNetworkChange(sPreNetType, curNetType, intent);
        }
    }

    public String getNetworkName() {
        return NetworkUtil.getNetworkName((int)this.mNetType);
    }

    public int getCachedNetType() {
        return this.mNetType;
    }

    public String getCachedWifiBssId() {
        return this.mWifiBssId;
    }

    public String getCachedCellID() {
        return this.mCellID;
    }

    public static interface NetworkChangeListener {
        public void onNetworkChange(int var1, int var2, Intent var3);
    }
}

