/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.image.blur;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.renderscript.RSRuntimeException;
import android.support.annotation.NonNull;
import com.bihe0832.android.common.image.blur.FastBlur;
import com.bihe0832.android.common.image.blur.RSBlur;
import com.bihe0832.android.lib.utils.os.BuildUtils;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import java.security.MessageDigest;

public class BlurTransformation
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "com.bihe0832.android.common.image.blur.BlurTransformation.1";
    private static int DEFAULT_RADIUS = 25;
    private static int DEFAULT_DOWN_SAMPLING = 1;
    private Context mContext;
    private int mRadius;
    private int mSampling;

    public BlurTransformation(Context context) {
        this(context, DEFAULT_RADIUS, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, int radius) {
        this(context, radius, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, int radius, int sampling) {
        this.mContext = context.getApplicationContext();
        this.mRadius = radius;
        this.mSampling = sampling;
    }

    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        int height;
        int scaledHeight;
        int width = toTransform.getWidth();
        int scaledWidth = width / this.mSampling;
        Bitmap bitmap = pool.get(scaledWidth, scaledHeight = (height = toTransform.getHeight()) / this.mSampling, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mSampling, 1.0f / (float)this.mSampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(toTransform, 0.0f, 0.0f, paint);
        if (BuildUtils.INSTANCE.getSDK_INT() >= 18) {
            try {
                bitmap = RSBlur.blur(this.mContext, bitmap, this.mRadius);
            }
            catch (RSRuntimeException e) {
                bitmap = FastBlur.blur(bitmap, this.mRadius, true);
            }
        } else {
            bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        }
        return bitmap;
    }

    public String toString() {
        return "BlurTransformation(radius=" + this.mRadius + ", sampling=" + this.mSampling + ")";
    }

    public boolean equals(Object o) {
        return o instanceof BlurTransformation && ((BlurTransformation)((Object)o)).mRadius == this.mRadius && ((BlurTransformation)((Object)o)).mSampling == this.mSampling;
    }

    public int hashCode() {
        return ID.hashCode() + this.mRadius * 1000 + this.mSampling * 10;
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.mRadius + this.mSampling).getBytes(CHARSET));
    }
}

