/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug.log;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.TextView;
import com.bihe0832.android.common.debug.R;
import com.bihe0832.android.common.debug.log.SectionDataContent;
import com.bihe0832.android.framework.file.AAFFileTools;
import com.bihe0832.android.framework.router.RouterHelperWrapperKt;
import com.bihe0832.android.lib.adapter.CardBaseHolder;
import com.bihe0832.android.lib.adapter.CardBaseModule;
import com.bihe0832.android.lib.text.TextFactoryUtils;

public class SectionHolderContent
extends CardBaseHolder {
    public TextView log_title;
    public TextView log_open;
    public TextView log_send;
    public View log_layout;

    public SectionHolderContent(View itemView, Context context) {
        super(itemView, context);
    }

    public void initView() {
        this.log_layout = this.getView(R.id.log_layout);
        this.log_title = (TextView)this.getView(R.id.log_title);
        this.log_open = (TextView)this.getView(R.id.log_open);
        this.log_send = (TextView)this.getView(R.id.log_send);
    }

    @SuppressLint(value={"UseCompatLoadingForDrawables"})
    public void initData(CardBaseModule item) {
        final SectionDataContent data = (SectionDataContent)item;
        this.log_title.setText((CharSequence)TextFactoryUtils.getSpannedTextByHtml((String)data.mTitleName));
        View.OnClickListener openListener = v -> {
            if (data.mActionListener != null) {
                data.mActionListener.onClick(v, 1);
            } else {
                try {
                    RouterHelperWrapperKt.showLog((String)data.mLogFileName, (boolean)data.mSort, (boolean)data.mShowLine);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        if (data.mShowAction) {
            this.log_open.setOnClickListener(openListener);
            this.log_open.setVisibility(0);
            this.log_send.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (data.mActionListener != null) {
                        data.mActionListener.onClick(v, 2);
                    } else {
                        try {
                            AAFFileTools.INSTANCE.sendFile(data.mLogFileName);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            this.log_send.setVisibility(0);
            this.log_layout.setBackground(null);
            this.log_layout.setOnClickListener(null);
        } else {
            this.log_send.setVisibility(8);
            this.log_open.setVisibility(8);
            this.log_layout.setOnClickListener(openListener);
            this.log_layout.setBackground(this.getContext().getResources().getDrawable(R.drawable.common_button_bg_shape));
        }
    }
}

