/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug.audio;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.bihe0832.android.common.debug.R;
import com.bihe0832.android.common.debug.audio.DebugWAVListFragment;
import com.bihe0832.android.common.debug.audio.SearchFileUtils;
import com.bihe0832.android.common.debug.audio.card.AudioData;
import com.bihe0832.android.common.debug.item.DebugItemData;
import com.bihe0832.android.common.debug.item.DebugItemToolsKt;
import com.bihe0832.android.common.debug.module.DebugEnvFragment;
import com.bihe0832.android.common.list.CommonListLiveData;
import com.bihe0832.android.framework.file.AAFFileWrapper;
import com.bihe0832.android.lib.adapter.CardBaseAdapter;
import com.bihe0832.android.lib.adapter.CardBaseModule;
import com.bihe0832.android.lib.file.FileUtils;
import com.bihe0832.android.lib.file.select.FileSelectTools;
import com.bihe0832.android.lib.thread.ThreadManager;
import com.bihe0832.android.lib.ui.dialog.callback.OnDialogListener;
import com.bihe0832.android.lib.ui.dialog.tools.DialogUtils;
import com.bihe0832.lib.audio.player.block.AudioPLayerManager;
import com.chad.library.adapter.base.BaseQuickAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u0015\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0018\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,H\u0016J\u0018\u0010-\u001a\u0012\u0012\u0004\u0012\u00020$0#j\b\u0012\u0004\u0012\u00020$`%H\u0016J\n\u0010.\u001a\u0004\u0018\u00010 H\u0016J\u0010\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u0014J\u0018\u00102\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u00103\u001a\u00020\rH\u0016J\u0018\u00104\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u00105\u001a\u000206H\u0016J\"\u00107\u001a\u00020\u00182\u0006\u00108\u001a\u0002062\u0006\u00109\u001a\u0002062\b\u0010\u0019\u001a\u0004\u0018\u00010:H\u0016J\b\u0010;\u001a\u00020\u0018H\u0016J\u0018\u0010<\u001a\u00020\u00182\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\rH\u0014J\u000e\u0010@\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\u0007\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016\u00a8\u0006A"}, d2={"Lcom/bihe0832/android/common/debug/audio/DebugWAVListFragment;", "Lcom/bihe0832/android/common/debug/module/DebugEnvFragment;", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG", "()Ljava/lang/String;", "folder", "getFolder", "setFolder", "(Ljava/lang/String;)V", "isPlay", "", "mAudioPLayerManager", "Lcom/bihe0832/lib/audio/player/block/AudioPLayerManager;", "getMAudioPLayerManager", "()Lcom/bihe0832/lib/audio/player/block/AudioPLayerManager;", "mAudioPLayerManager$delegate", "Lkotlin/Lazy;", "mListLiveData", "com/bihe0832/android/common/debug/audio/DebugWAVListFragment$mListLiveData$1", "Lcom/bihe0832/android/common/debug/audio/DebugWAVListFragment$mListLiveData$1;", "audioIconClickAction", "", "data", "Lcom/bihe0832/android/common/debug/audio/card/AudioData;", "audioIconLongClickAction", "audioData", "filterFile", "filePath", "getChangeAutoPlayItem", "Lcom/bihe0832/android/common/debug/item/DebugItemData;", "getChangeFolderItem", "getDataList", "Ljava/util/ArrayList;", "Lcom/bihe0832/android/lib/adapter/CardBaseModule;", "Lkotlin/collections/ArrayList;", "getDataLiveData", "Lcom/bihe0832/android/common/list/CommonListLiveData;", "getFileItem", "file", "Ljava/io/File;", "getFileList", "", "getHeader", "getTips", "initView", "view", "Landroid/view/View;", "itemClickAction", "play", "itemLongClickAction", "index", "", "onActivityResult", "requestCode", "resultCode", "Landroid/content/Intent;", "onDestroy", "parseBundle", "bundle", "Landroid/os/Bundle;", "isOnCreate", "playAudioData", "CommonDebug_release"})
public class DebugWAVListFragment
extends DebugEnvFragment {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    @NotNull
    private final Lazy mAudioPLayerManager$delegate = LazyKt.lazy((Function0)mAudioPLayerManager.2.INSTANCE);
    @NotNull
    private String folder = AAFFileWrapper.INSTANCE.getMediaTempFolder();
    private boolean isPlay;
    @NotNull
    private final mListLiveData.1 mListLiveData = new CommonListLiveData(this){
        final /* synthetic */ DebugWAVListFragment this$0;
        {
            this.this$0 = $receiver;
        }

        public void initData() {
            ThreadManager.getInstance().start(() -> mListLiveData.1.initData$lambda$2(this.this$0, this));
        }

        public void refresh() {
            this.initData();
        }

        public void loadMore() {
        }

        public boolean hasMore() {
            return false;
        }

        public boolean canRefresh() {
            return true;
        }

        private static final void initData$lambda$2$lambda$1$lambda$0(mListLiveData.1 this$0, ArrayList $it) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
            this$0.postValue($it);
        }

        private static final void initData$lambda$2(DebugWAVListFragment this$0, mListLiveData.1 this$1) {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)this$1), (String)"this$1");
            ArrayList<CardBaseModule> it = this$0.getDataList();
            boolean bl = false;
            ThreadManager.getInstance().runOnUIThread(() -> mListLiveData.1.initData$lambda$2$lambda$1$lambda$0(this$1, it));
        }
    };

    public final String getTAG() {
        return this.TAG;
    }

    @NotNull
    protected final AudioPLayerManager getMAudioPLayerManager() {
        Lazy lazy = this.mAudioPLayerManager$delegate;
        return (AudioPLayerManager)lazy.getValue();
    }

    @NotNull
    protected final String getFolder() {
        return this.folder;
    }

    protected final void setFolder(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.folder = string;
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        block1: {
            if (requestCode != 1 || resultCode != -1) break block1;
            Object object = data;
            if (object != null && (object = object.getExtras()) != null && (object = object.getString("url", "")) != null) {
                Object filePath = object;
                boolean bl = false;
                this.folder = filePath;
                this.mListLiveData.refresh();
            }
        }
    }

    @Override
    @NotNull
    public CommonListLiveData getDataLiveData() {
        return this.mListLiveData;
    }

    public void onDestroy() {
        super.onDestroy();
        this.getMAudioPLayerManager().stopAll(true);
    }

    protected void parseBundle(@NotNull Bundle bundle, boolean isOnCreate) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        super.parseBundle(bundle, isOnCreate);
        String it = bundle.getString("url", "");
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        if (!StringsKt.isBlank((CharSequence)it)) {
            this.folder = it;
        }
    }

    @Override
    protected void initView(@NotNull View view) {
        CardBaseAdapter cardBaseAdapter;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.initView(view);
        CardBaseAdapter $this$initView_u24lambda_u248 = cardBaseAdapter = this.getMAdapter();
        boolean bl = false;
        $this$initView_u24lambda_u248.setOnItemChildClickListener((arg_0, arg_1, arg_2) -> DebugWAVListFragment.initView$lambda$8$lambda$5(this, arg_0, arg_1, arg_2));
        $this$initView_u24lambda_u248.setOnItemChildLongClickListener((arg_0, arg_1, arg_2) -> DebugWAVListFragment.initView$lambda$8$lambda$7(this, arg_0, arg_1, arg_2));
    }

    @Nullable
    public DebugItemData getTips() {
        String tips = "1. <b><font color='#3AC8EF'>\u70b9\u51fb</font>\u56fe\u6807</b>\uff0c\u64ad\u653e\u97f3\u9891\uff0c<b><font color='#3AC8EF'>\u70b9\u51fb</font>\u6807\u9898\u548c\u5185\u5bb9</b>\uff0c" + (this.isPlay ? "\u64ad\u653e\u97f3\u9891\u5e76\u5904\u7406\u97f3\u9891\u5185\u5bb9" : "\u5904\u7406\u97f3\u9891\u5185\u5bb9") + "<BR>2. <b><font color='#3AC8EF'>\u957f\u6309</font>\u56fe\u6807</b>\uff0c\u53ef\u4ee5\u5220\u9664\u97f3\u9891\uff0c<b><font color='#3AC8EF'>\u957f\u6309</font>\u6807\u9898\u548c\u5185\u5bb9</b>\uff0c\u53ef\u4ee5\u53d1\u9001\u97f3\u9891";
        return DebugItemToolsKt.getTipsItem(tips);
    }

    @NotNull
    public final DebugItemData getChangeFolderItem() {
        return DebugItemToolsKt.getDebugItem("<font color ='#3AC8EF'><b>\u70b9\u51fb\u5207\u6362\u67e5\u770b\u7684\u97f3\u9891\u76ee\u5f55</b></font>", arg_0 -> DebugWAVListFragment.getChangeFolderItem$lambda$9(this, arg_0));
    }

    @NotNull
    public final DebugItemData getChangeAutoPlayItem() {
        return DebugItemToolsKt.getDebugItem("<font color ='#3AC8EF'><b>\u70b9\u51fb\u5207\u6362\u8bc6\u522b\u65f6\u662f\u5426\u64ad\u653e\uff0c\u5f53\u524d\uff1a" + this.isPlay + "</b></font>", arg_0 -> DebugWAVListFragment.getChangeAutoPlayItem$lambda$10(this, arg_0));
    }

    @NotNull
    public AudioData getFileItem(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new AudioData(file.getAbsolutePath());
    }

    public boolean filterFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return FileUtils.INSTANCE.checkFileExist(filePath);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<File> getFileList() {
        void $this$sortedByDescending$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        File it = new File(this.folder);
        boolean bl = false;
        File file = it.isFile() ? it.getParentFile() : it;
        boolean bl2 = false;
        String[] stringArray = new String[]{".wav"};
        List<File> list = SearchFileUtils.search(file, stringArray);
        Intrinsics.checkNotNullExpressionValue(list, (String)"search(file, arrayOf(\".wav\"))");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it2 = (File)element$iv$iv;
            boolean bl3 = false;
            String string = it2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
            if (!this.filterFile(string)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                File it = (File)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (File)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.lastModified()));
            }
        });
    }

    @NotNull
    public ArrayList<CardBaseModule> getHeader() {
        ArrayList<CardBaseModule> arrayList;
        ArrayList<CardBaseModule> $this$getHeader_u24lambda_u2416 = arrayList = new ArrayList<CardBaseModule>();
        boolean bl = false;
        DebugItemData debugItemData = this.getTips();
        if (debugItemData != null) {
            DebugItemData it = debugItemData;
            boolean bl2 = false;
            $this$getHeader_u24lambda_u2416.add(it);
        }
        $this$getHeader_u24lambda_u2416.add(this.getChangeFolderItem());
        $this$getHeader_u24lambda_u2416.add(this.getChangeAutoPlayItem());
        ArrayList<CardBaseModule> data = arrayList;
        return data;
    }

    @Override
    @NotNull
    public ArrayList<CardBaseModule> getDataList() {
        ArrayList<CardBaseModule> arrayList;
        ArrayList<CardBaseModule> $this$getDataList_u24lambda_u2417 = arrayList = new ArrayList<CardBaseModule>();
        boolean bl = false;
        $this$getDataList_u24lambda_u2417.addAll((Collection)this.getHeader());
        ArrayList<CardBaseModule> data = arrayList;
        Iterable $this$forEach$iv = this.getFileList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File item = (File)element$iv;
            boolean bl2 = false;
            data.add(this.getFileItem(item));
        }
        return data;
    }

    public void itemClickAction(@NotNull AudioData data, boolean play) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        if (play) {
            this.playAudioData(data);
        }
        Log.i((String)this.TAG, (String)data.toString());
    }

    public void audioIconClickAction(@NotNull AudioData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        AudioPLayerManager audioPLayerManager = this.getMAudioPLayerManager();
        String string = data.filePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.filePath");
        audioPLayerManager.play(string);
    }

    public void itemLongClickAction(@NotNull AudioData audioData, int index) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioData), (String)"audioData");
        FragmentActivity fragmentActivity = this.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity);
        DialogUtils.INSTANCE.showConfirmDialog((Context)fragmentActivity, "\u5220\u9664\u6587\u4ef6", "\u786e\u8ba4\u8981\u5220\u9664" + FileUtils.INSTANCE.getFileName(audioData.filePath) + "\u4e48\uff1f", true, new OnDialogListener(audioData, this, index){
            final /* synthetic */ AudioData $audioData;
            final /* synthetic */ DebugWAVListFragment this$0;
            final /* synthetic */ int $index;
            {
                this.$audioData = $audioData;
                this.this$0 = $receiver;
                this.$index = $index;
            }

            public void onPositiveClick() {
                String string = this.$audioData.filePath;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"audioData.filePath");
                FileUtils.INSTANCE.deleteFile(string);
                DebugWAVListFragment.access$getMAdapter(this.this$0).remove(this.$index);
                DebugWAVListFragment.access$getMAdapter(this.this$0).notifyItemRemoved(this.$index);
            }

            public void onNegativeClick() {
            }

            public void onCancel() {
            }
        });
    }

    public void audioIconLongClickAction(@NotNull AudioData audioData) {
        Intrinsics.checkNotNullParameter((Object)((Object)audioData), (String)"audioData");
        FragmentActivity fragmentActivity = this.getActivity();
        Intrinsics.checkNotNull((Object)fragmentActivity);
        Context context = (Context)fragmentActivity;
        String string = audioData.filePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"audioData.filePath");
        FileUtils.INSTANCE.sendFile(context, string);
    }

    public final void playAudioData(@NotNull AudioData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        if (this.getMAudioPLayerManager().isRunning()) {
            this.getMAudioPLayerManager().stopAll(true);
        }
        AudioPLayerManager audioPLayerManager = this.getMAudioPLayerManager();
        String string = data.filePath;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"data.filePath");
        audioPLayerManager.play(string);
    }

    private static final void initView$lambda$8$lambda$5$lambda$4$lambda$3$lambda$2(DebugWAVListFragment this$0, int $i) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.getMAdapter().notifyItemChanged($i);
    }

    private static final void initView$lambda$8$lambda$5$lambda$4$lambda$3(DebugWAVListFragment this$0, AudioData $audioData, int $i) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$audioData), (String)"$audioData");
        this$0.itemClickAction($audioData, this$0.isPlay);
        this$0.post(() -> DebugWAVListFragment.initView$lambda$8$lambda$5$lambda$4$lambda$3$lambda$2(this$0, $i));
    }

    private static final void initView$lambda$8$lambda$5(DebugWAVListFragment this$0, BaseQuickAdapter baseQuickAdapter, View view, int i) {
        block0: {
            int n;
            AudioData audioData;
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AudioData audioData2 = (AudioData)((Object)baseQuickAdapter.getItem(i));
                if (audioData2 == null) break block0;
                audioData = audioData2;
                boolean bl = false;
                n = view.getId();
                if (!(n == R.id.audio_title ? true : n == R.id.audio_desc)) break block1;
                ThreadManager.getInstance().start(() -> DebugWAVListFragment.initView$lambda$8$lambda$5$lambda$4$lambda$3(this$0, audioData, i));
                break block0;
            }
            if (n != R.id.audio_icon) break block0;
            this$0.audioIconClickAction(audioData);
        }
    }

    private static final boolean initView$lambda$8$lambda$7(DebugWAVListFragment this$0, BaseQuickAdapter baseQuickAdapter, View view, int i) {
        block0: {
            int n;
            AudioData audioData;
            block1: {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                AudioData audioData2 = (AudioData)((Object)baseQuickAdapter.getItem(i));
                if (audioData2 == null) break block0;
                audioData = audioData2;
                boolean bl = false;
                n = view.getId();
                if (n != R.id.audio_icon) break block1;
                this$0.itemLongClickAction(audioData, i);
                break block0;
            }
            if (!(n == R.id.audio_title ? true : n == R.id.audio_desc)) break block0;
            this$0.audioIconLongClickAction(audioData);
        }
        return false;
    }

    private static final void getChangeFolderItem$lambda$9(DebugWAVListFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        FileSelectTools.openFileSelect((Fragment)((Fragment)this$0), (String)this$0.folder);
    }

    private static final void getChangeAutoPlayItem$lambda$10(DebugWAVListFragment this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.isPlay = !this$0.isPlay;
        this$0.mListLiveData.refresh();
    }

    public static final /* synthetic */ CardBaseAdapter access$getMAdapter(DebugWAVListFragment $this) {
        return $this.getMAdapter();
    }
}

