/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.debug;

import android.util.DisplayMetrics;
import android.view.View;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.bihe0832.android.common.debug.R;
import com.bihe0832.android.common.debug.module.DebugCommonFragment;
import com.bihe0832.android.framework.ui.BaseFragment;
import com.bihe0832.android.lib.utils.ConvertUtils;
import com.flyco.tablayout.SlidingTabLayout;
import com.flyco.tablayout.listener.OnTabSelectListener;

public class DebugMainFragment
extends BaseFragment {
    public static final String TAB_FOR_DEV_COMMON = "\u901a\u7528\u8c03\u8bd5";
    private ViewPager mViewPager;
    private SlidingTabLayout mTabBar;
    private int lastTab = 0;
    protected String[] mTabString = null;

    public DebugMainFragment() {
        this(new String[]{TAB_FOR_DEV_COMMON});
    }

    public DebugMainFragment(String[] tabString) {
        this.mTabString = tabString;
        this.lastTab = this.getDefaultTabIndex();
    }

    protected Fragment getFragmentByIndex(String title) {
        return new DebugCommonFragment();
    }

    protected int getDefaultTabIndex() {
        return 0;
    }

    protected int getLayoutID() {
        return R.layout.com_bihe0832_fragment_debug_main;
    }

    protected void initView(View view) {
        super.initView(view);
        this.mViewPager = (ViewPager)view.findViewById(R.id.framework_viewPager);
        this.mViewPager.setAdapter((PagerAdapter)new MyTaskPagerFragmentAdapter(this.getChildFragmentManager()));
        this.mViewPager.setOffscreenPageLimit(this.mTabString.length);
        this.mTabBar = (SlidingTabLayout)view.findViewById(R.id.framework_tab);
        this.mTabBar.setViewPager(this.mViewPager);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        float tabWidth = (float)dm.widthPixels / dm.density / (float)this.mTabString.length;
        this.mTabBar.setTabWidth(tabWidth);
        this.mTabBar.setTabPadding(0.0f);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.mTabBar.setOnTabSelectListener(new OnTabSelectListener(){

            public void onTabSelect(int position) {
                DebugMainFragment.this.mTabBar.hideMsg(position);
                DebugMainFragment.this.lastTab = position;
            }

            public void onTabReselect(int position) {
            }
        });
        this.mTabBar.setCurrentTab(this.getDefaultTabIndex());
    }

    private class MyTaskPagerFragmentAdapter
    extends FragmentPagerAdapter {
        public MyTaskPagerFragmentAdapter(FragmentManager fm) {
            super(fm);
        }

        public Fragment getItem(int position) {
            return DebugMainFragment.this.getFragmentByIndex(ConvertUtils.getSafeValueFromArray((String[])DebugMainFragment.this.mTabString, (int)position, (String)""));
        }

        public int getCount() {
            return DebugMainFragment.this.mTabString.length;
        }

        public CharSequence getPageTitle(int position) {
            return DebugMainFragment.this.mTabString[position];
        }
    }
}

