/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.ui.bottom.bar;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.bihe0832.android.common.bottom.bar.R;
import com.bihe0832.android.common.svga.SVGAHelperKt;
import com.bihe0832.android.lib.ui.bottom.bar.BaseBottomBarTab;
import com.bihe0832.android.lib.ui.textview.TextViewWithBackground;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;

public class SvgaBottomBarTab
extends BaseBottomBarTab {
    protected SVGAImageView mIconView;
    protected TextView mTitleView;
    protected TextViewWithBackground mTipsView;
    protected String mActionSvga = "";
    protected int mNormalImageRes = -1;
    protected int mSelectedImageRes = -1;

    public SvgaBottomBarTab(Context context, @DrawableRes int normalImageRes, @DrawableRes int selectedImageRes, String actionSvga, String title) {
        this(context, null, 0, normalImageRes, selectedImageRes, actionSvga, title);
    }

    public SvgaBottomBarTab(Context context, AttributeSet attrs, int defStyleAttr, int normalImageRes, int selectedImageRes, String actionSvga, String title) {
        super(context, attrs, defStyleAttr, normalImageRes, (CharSequence)title);
        this.mActionSvga = actionSvga;
        this.mNormalImageRes = normalImageRes;
        this.mSelectedImageRes = selectedImageRes;
    }

    protected ImageView getIconView() {
        return this.mIconView;
    }

    protected TextView getTitleView() {
        return this.mTitleView;
    }

    protected TextViewWithBackground getTipsView() {
        return this.mTipsView;
    }

    protected int getLayoutID() {
        return R.layout.common_tab_svga;
    }

    protected void initView(@NonNull Context context) {
        this.mIconView = (SVGAImageView)this.findViewById(R.id.tab_icon);
        this.mTitleView = (TextView)this.findViewById(R.id.tab_title);
        this.mTipsView = (TextViewWithBackground)this.findViewById(R.id.tab_tips);
    }

    protected void initViewEvent(int icon, @Nullable CharSequence title) {
        super.initViewEvent(icon, title);
        this.mIconView.setCallback(new SVGACallback(){

            public void onStep(int i, double v) {
            }

            public void onRepeat() {
            }

            public void onPause() {
            }

            public void onFinished() {
                SvgaBottomBarTab.this.onSelectChanged();
            }
        });
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.onSelectChanged();
        if (selected) {
            SVGAHelperKt.playAssets((SVGAImageView)this.mIconView, (String)this.mActionSvga);
        }
    }

    protected void onSelectChanged() {
        if (this.isSelected()) {
            this.mIconView.setImageResource(this.mSelectedImageRes);
            this.mTitleView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.com_bihe0832_tab_selected));
        } else {
            this.mIconView.setImageResource(this.mNormalImageRes);
            this.mTitleView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.com_bihe0832_tab_unselect));
        }
    }
}

