/*
 * Decompiled with CFR 0.152.
 */
package com.bihe0832.android.common.about.card;

import android.content.Context;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bihe0832.android.common.about.R;
import com.bihe0832.android.common.about.card.SettingsData;
import com.bihe0832.android.lib.adapter.CardBaseHolder;
import com.bihe0832.android.lib.adapter.CardBaseModule;
import com.bihe0832.android.lib.media.image.GlideExtKt;
import com.bihe0832.android.lib.text.TextFactoryUtils;
import com.bihe0832.android.lib.ui.textview.TextViewWithBackground;
import com.bihe0832.android.lib.ui.textview.ext.TextViewWithBackgroundExtKt;
import com.bihe0832.android.lib.utils.os.DisplayUtil;

public class SettingsHolder
extends CardBaseHolder {
    public TextView mHeader;
    public ImageView mHeaderIcon;
    public TextViewWithBackground mHeaderIsNew;
    public TextView mHeaderTips;
    public ImageView mHeadergo;
    public View settings_drivider;

    public SettingsHolder(View itemView, Context context) {
        super(itemView, context);
    }

    public void initView() {
        this.mHeader = (TextView)this.getView(R.id.settings_title);
        this.mHeaderIcon = (ImageView)this.getView(R.id.settings_icon);
        this.mHeaderIsNew = (TextViewWithBackground)this.getView(R.id.settings_is_new);
        this.mHeaderTips = (TextView)this.getView(R.id.settings_tips);
        this.mHeadergo = (ImageView)this.getView(R.id.settings_go);
        this.settings_drivider = this.getView(R.id.settings_drivider);
    }

    public void initData(CardBaseModule item) {
        SettingsData data = (SettingsData)item;
        if (data.mHeaderListener != null) {
            this.itemView.setOnClickListener(data.mHeaderListener);
        }
        if (data.mHeaderTipsListener != null) {
            this.mHeaderTips.setOnClickListener(data.mHeaderTipsListener);
        } else {
            this.mHeaderTips.setOnClickListener(data.mHeaderListener);
        }
        if (TextUtils.isEmpty((CharSequence)data.mItemIconURL)) {
            if (data.mItemIconRes < 0) {
                this.mHeaderIcon.setVisibility(8);
            } else {
                GlideExtKt.loadImage((ImageView)this.mHeaderIcon, (int)data.mItemIconRes);
                this.mHeaderIcon.setVisibility(0);
            }
        } else {
            GlideExtKt.loadImage((ImageView)this.mHeaderIcon, (String)data.mItemIconURL, (int)R.mipmap.icon, (int)R.mipmap.icon);
            this.mHeaderIcon.setVisibility(0);
        }
        this.mHeader.setText((CharSequence)data.mItemText);
        if (data.mHeaderTextBold) {
            this.mHeader.setTypeface(null, 1);
        }
        if (TextUtils.isEmpty((CharSequence)data.mTipsText)) {
            this.mHeaderTips.setVisibility(8);
        } else {
            Spanned charSequence = TextFactoryUtils.getSpannedTextByHtml((String)data.mTipsText);
            this.mHeaderTips.setText((CharSequence)charSequence);
            this.mHeaderTips.setVisibility(0);
        }
        if (data.mItemIsNew) {
            TextViewWithBackgroundExtKt.changeStatusWithUnreadMsg((TextViewWithBackground)this.mHeaderIsNew, (int)0, (int)DisplayUtil.dip2px((Context)this.getContext(), (float)8.0f));
        } else {
            this.mHeaderIsNew.setVisibility(8);
        }
        if (data.mShowGo) {
            this.mHeadergo.setVisibility(0);
        } else {
            this.mHeadergo.setVisibility(8);
        }
        if (data.mShowDriver) {
            this.settings_drivider.setVisibility(0);
        } else {
            this.settings_drivider.setVisibility(8);
        }
    }
}

