/*
 * Decompiled with CFR 0.152.
 */
package com.bigscreen.iconictabbar.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.MenuRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupMenu;
import com.bigscreen.iconictabbar.R;
import com.bigscreen.iconictabbar.helper.ConfigHelper;
import com.bigscreen.iconictabbar.view.IconicTab;
import java.util.ArrayList;
import java.util.List;

public class IconicTabBar
extends FrameLayout
implements IconicTab.OnTabClickListener {
    public static final int MAX_TAB = 5;
    private AttributeSet attributeSet;
    private FrameLayout frameTabs;
    private LinearLayout llTabs;
    private List<IconicTab> tabs;
    private int selectedTabPosition;
    private int unSelectedTabPosition;
    private int backgroundColor;
    private int tabDefaultColor;
    private int tabSelectedColor;
    private IconicTab selectedTab;
    private IconicTab unSelectedTab;
    private OnTabSelectedListener onTabSelectedListener;

    public IconicTabBar(Context context) {
        super(context);
        this.inflateView();
    }

    public IconicTabBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.attributeSet = attrs;
        this.inflateView();
    }

    public IconicTabBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.attributeSet = attrs;
        this.inflateView();
    }

    @TargetApi(value=21)
    public IconicTabBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.attributeSet = attrs;
        this.inflateView();
    }

    private void inflateView() {
        IconicTabBar.inflate((Context)this.getContext(), (int)R.layout.layout_tab_bar, (ViewGroup)this);
        this.frameTabs = (FrameLayout)this.findViewById(R.id.frame_tabs);
        this.llTabs = (LinearLayout)this.findViewById(R.id.ll_tabs);
        this.initStyle();
    }

    private void initStyle() {
        TypedArray styledAttributes = this.getContext().obtainStyledAttributes(this.attributeSet, R.styleable.IconicTabBar);
        int menuResId = styledAttributes.getResourceId(R.styleable.IconicTabBar_tabFromMenu, -1);
        this.backgroundColor = styledAttributes.getColor(R.styleable.IconicTabBar_barBackground, ContextCompat.getColor((Context)this.getContext(), (int)R.color.white));
        this.tabDefaultColor = styledAttributes.getColor(R.styleable.IconicTabBar_tabDefaultColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.defaultColor));
        this.tabSelectedColor = styledAttributes.getColor(R.styleable.IconicTabBar_tabSelectedColor, ContextCompat.getColor((Context)this.getContext(), (int)R.color.defaultSelectedColor));
        this.frameTabs.setBackgroundColor(this.backgroundColor);
        if (menuResId != -1) {
            this.addTabFromMenu(menuResId);
        }
        styledAttributes.recycle();
    }

    public void addTab(@DrawableRes int iconResId, CharSequence text) {
        this.addTab(0, iconResId, null, text);
    }

    public void addTab(int viewId, @DrawableRes int iconResId, CharSequence text) {
        this.addTab(viewId, iconResId, null, text);
    }

    public void addTab(Drawable iconDrawable, CharSequence text) {
        this.addTab(0, 0, iconDrawable, text);
    }

    public void addTab(int viewId, Drawable iconDrawable, CharSequence text) {
        this.addTab(viewId, 0, iconDrawable, text);
    }

    private void addTab(int viewId, @DrawableRes int iconResId, Drawable iconDrawable, CharSequence text) {
        int latestTabsSize;
        if (this.tabs == null) {
            this.tabs = new ArrayList<IconicTab>();
        }
        if ((latestTabsSize = this.tabs.size()) > 5) {
            throw new UnsupportedOperationException("Cannot add more than 5 tabs.");
        }
        IconicTab tab = new IconicTab(this.getContext());
        tab.setId(viewId);
        tab.setTabDefaultColor(this.tabDefaultColor);
        tab.setTabSelectedColor(this.tabSelectedColor);
        if (iconResId == 0 && iconDrawable != null) {
            tab.bindData(latestTabsSize, iconDrawable, text);
        } else if (iconResId != 0 && iconDrawable == null) {
            tab.bindData(latestTabsSize, iconResId, text);
        } else {
            throw new NullPointerException("Tab icon was not specified.");
        }
        tab.setOnTabClickListener(this);
        this.tabs.add(tab);
        this.llTabs.addView((View)tab);
        this.initTabSize();
        if (latestTabsSize == 0) {
            this.selectedTabPosition = 0;
            this.selectedTab = tab;
            tab.setSelected();
        }
    }

    private void addTabFromMenu(@MenuRes int menuRes) {
        PopupMenu popupMenu = new PopupMenu(this.getContext(), null);
        Menu menu = popupMenu.getMenu();
        MenuInflater menuInflater = new MenuInflater(this.getContext());
        menuInflater.inflate(menuRes, menu);
        for (int i = 0; i < menu.size(); ++i) {
            MenuItem item = menu.getItem(i);
            this.addTab(item.getItemId(), item.getIcon(), (CharSequence)item.getTitle().toString());
        }
    }

    public IconicTab getTab(int position) {
        return this.tabs.get(position);
    }

    public void setTabBadge(int tabPosition, int badgeCount) {
        this.getTab(tabPosition).setBadgeCount(badgeCount);
    }

    public void setOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.onTabSelectedListener = onTabSelectedListener;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.frameTabs.setBackgroundColor(backgroundColor);
    }

    public void setTabDefaultColor(@ColorInt int tabDefaultColor) {
        this.tabDefaultColor = tabDefaultColor;
        for (IconicTab tab : this.tabs) {
            tab.setTabDefaultColor(tabDefaultColor);
        }
    }

    public void setTabSelectedColor(@ColorInt int tabSelectedColor) {
        this.tabSelectedColor = tabSelectedColor;
        for (IconicTab tab : this.tabs) {
            tab.setTabSelectedColor(tabSelectedColor);
        }
    }

    @Override
    public void onTabClick(IconicTab tabBottomBar, int position) {
        if (((Object)((Object)tabBottomBar)).equals((Object)this.selectedTab)) {
            return;
        }
        this.setUnselectedTab(this.selectedTab, this.selectedTabPosition);
        this.setSelectedTab(tabBottomBar, position);
    }

    private void setSelectedTab(IconicTab tab, int tabPosition) {
        this.selectedTab = tab;
        this.selectedTabPosition = tabPosition;
        if (this.onTabSelectedListener != null) {
            this.onTabSelectedListener.onSelected(this.selectedTab, this.selectedTabPosition);
        }
        this.selectedTab.setSelectedWithAnimation();
    }

    private void setUnselectedTab(IconicTab tab, int tabPosition) {
        this.unSelectedTab = tab;
        this.unSelectedTabPosition = tabPosition;
        if (this.onTabSelectedListener != null) {
            this.onTabSelectedListener.onUnselected(this.unSelectedTab, this.unSelectedTabPosition);
        }
        this.unSelectedTab.setUnselectedWithAnimation();
    }

    private void initTabSize() {
        int tabCount = this.tabs.size();
        int screenWidth = ConfigHelper.getScreenWidth(this.getContext());
        int tabMaxWidth = ConfigHelper.getPxFromDimenRes(R.dimen.iconic_tab_max_width, this.getContext());
        if (tabMaxWidth * tabCount > screenWidth) {
            this.llTabs.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            for (IconicTab tab : this.tabs) {
                tab.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
                tab.setGravity(17);
            }
        } else {
            this.llTabs.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -1, 1));
            for (IconicTab tab : this.tabs) {
                tab.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(tabMaxWidth, -1));
                tab.setGravity(17);
            }
        }
    }

    public static interface OnTabSelectedListener {
        public void onSelected(IconicTab var1, int var2);

        public void onUnselected(IconicTab var1, int var2);
    }
}

