/*
 * Decompiled with CFR 0.152.
 */
package com.bigscreen.iconictabbar.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.bigscreen.iconictabbar.R;
import com.transitionseverywhere.AutoTransition;
import com.transitionseverywhere.Transition;
import com.transitionseverywhere.TransitionManager;

public class IconicTab
extends LinearLayout {
    private static final int TRANSITION_DURATION = 200;
    private LinearLayout tabItem;
    private ImageView tabIcon;
    private TextView tabText;
    private TextView tabBadge;
    private int tabPosition;
    private int badgeCount;
    private int tabDefaultColor;
    private int tabSelectedColor;
    private OnTabClickListener onTabClickListener;

    public IconicTab(Context context) {
        super(context);
        this.inflateView();
    }

    public IconicTab(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.inflateView();
    }

    public IconicTab(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.inflateView();
    }

    @TargetApi(value=21)
    public IconicTab(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.inflateView();
    }

    private void inflateView() {
        IconicTab.inflate((Context)this.getContext(), (int)R.layout.layout_tab_item, (ViewGroup)this);
        this.tabItem = (LinearLayout)this.findViewById(R.id.tab_item);
        this.tabIcon = (ImageView)this.findViewById(R.id.tab_item_icon);
        this.tabText = (TextView)this.findViewById(R.id.tab_item_text);
        this.tabBadge = (TextView)this.findViewById(R.id.tab_item_badge);
        this.tabDefaultColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.defaultColor);
        this.tabSelectedColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.defaultSelectedColor);
        this.tabIcon.setColorFilter(this.tabDefaultColor);
        this.tabText.setTextColor(this.tabDefaultColor);
        this.tabText.setVisibility(8);
        this.tabBadge.setVisibility(8);
    }

    public void bindData(int position, @DrawableRes int iconResId, @StringRes int textResId) {
        this.tabPosition = position;
        this.tabIcon.setImageResource(iconResId);
        this.tabText.setText(textResId);
        this.setBadgeCount(0);
        this.onTabItemClick();
    }

    public void bindData(int position, @DrawableRes int iconResId, CharSequence text) {
        this.tabPosition = position;
        this.tabIcon.setImageResource(iconResId);
        this.tabText.setText(text);
        this.setBadgeCount(0);
        this.onTabItemClick();
    }

    public void bindData(int position, Drawable iconDrawable, CharSequence text) {
        this.tabPosition = position;
        this.tabIcon.setImageDrawable(iconDrawable);
        this.tabText.setText(text);
        this.setBadgeCount(0);
        this.onTabItemClick();
    }

    public void setIcon(@DrawableRes int iconResId) {
        this.tabIcon.setImageResource(iconResId);
    }

    public void setIcon(Drawable iconDrawable) {
        this.tabIcon.setImageDrawable(iconDrawable);
    }

    public void setText(@StringRes int stringResId) {
        this.tabText.setText(stringResId);
    }

    public void setText(CharSequence text) {
        this.tabText.setText(text);
    }

    public void setTabDefaultColor(@ColorInt int tabDefaultColor) {
        this.tabDefaultColor = tabDefaultColor;
        this.tabIcon.setColorFilter(tabDefaultColor);
        this.tabText.setTextColor(tabDefaultColor);
    }

    public void setTabSelectedColor(@ColorInt int tabSelectedColor) {
        this.tabSelectedColor = tabSelectedColor;
    }

    public void setSelected() {
        this.tabIcon.setColorFilter(this.tabSelectedColor);
        this.tabText.setTextColor(this.tabSelectedColor);
        this.tabText.setVisibility(0);
    }

    public void setUnselected() {
        this.tabIcon.setColorFilter(this.tabDefaultColor);
        this.tabText.setTextColor(this.tabDefaultColor);
        this.tabText.setVisibility(8);
    }

    public void setSelectedWithAnimation() {
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)this.getTransition());
        this.tabIcon.setColorFilter(this.tabSelectedColor);
        this.tabText.setTextColor(this.tabSelectedColor);
        this.tabText.setVisibility(0);
    }

    public void setUnselectedWithAnimation() {
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)this.getTransition());
        this.tabIcon.setColorFilter(this.tabDefaultColor);
        this.tabText.setTextColor(this.tabDefaultColor);
        this.tabText.setVisibility(8);
    }

    public void setBadgeCount(int badgeCount) {
        this.badgeCount = badgeCount;
        if (badgeCount > 0) {
            this.tabBadge.setVisibility(0);
            this.tabBadge.setText((CharSequence)String.format("%s", badgeCount));
        } else {
            this.tabBadge.setVisibility(8);
        }
    }

    public void setOnTabClickListener(OnTabClickListener onTabClickListener) {
        this.onTabClickListener = onTabClickListener;
    }

    private void onTabItemClick() {
        this.tabItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (IconicTab.this.onTabClickListener != null) {
                    IconicTab.this.onTabClickListener.onTabClick(IconicTab.this, IconicTab.this.tabPosition);
                }
            }
        });
    }

    private Transition getTransition() {
        return new AutoTransition().setDuration(200L);
    }

    public CharSequence getText() {
        return this.tabText.getText();
    }

    public Drawable getIcon() {
        return this.tabIcon.getDrawable();
    }

    public int getBadgeCount() {
        return this.badgeCount;
    }

    public static interface OnTabClickListener {
        public void onTabClick(IconicTab var1, int var2);
    }
}

