/*
 * Decompiled with CFR 0.152.
 */
package com.bigscreen.iconictabbar.helper;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.DimenRes;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;

public class ConfigHelper {
    private static int[] getScreenSize(Context context) {
        int height;
        int width;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            windowManager.getDefaultDisplay().getSize(size);
            width = size.x;
            height = size.y;
        } else {
            Display display = windowManager.getDefaultDisplay();
            width = display.getWidth();
            height = display.getHeight();
        }
        Log.i((String)"IconicTabBar", (String)("Get screen size!, width= " + width + ", height= " + height));
        return new int[]{width, height};
    }

    public static int getScreenWidth(Context context) {
        return ConfigHelper.getScreenSize(context)[0];
    }

    public static int getScreenHeight(Context context) {
        return ConfigHelper.getScreenSize(context)[1];
    }

    public static int getPxFromDimenRes(@DimenRes int dimenRes, Context context) {
        return context.getResources().getDimensionPixelSize(dimenRes);
    }

    public static int getPxFromDp(float dp, Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float px = dp * ((float)metrics.densityDpi / 160.0f);
        return (int)px;
    }
}

