/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.expandablerecyclerview.model;

import android.support.annotation.NonNull;
import com.bignerdranch.expandablerecyclerview.model.Parent;
import java.util.ArrayList;
import java.util.List;

public class ExpandableWrapper<P extends Parent<C>, C> {
    private P mParent;
    private C mChild;
    private boolean mWrappedParent;
    private boolean mExpanded;
    private List<ExpandableWrapper<P, C>> mWrappedChildList;

    public ExpandableWrapper(@NonNull P parent) {
        this.mParent = parent;
        this.mWrappedParent = true;
        this.mExpanded = false;
        this.mWrappedChildList = this.generateChildItemList(parent);
    }

    public ExpandableWrapper(@NonNull C child) {
        this.mChild = child;
        this.mWrappedParent = false;
        this.mExpanded = false;
    }

    public P getParent() {
        return this.mParent;
    }

    public void setParent(@NonNull P parent) {
        this.mParent = parent;
        this.mWrappedChildList = this.generateChildItemList(parent);
    }

    public C getChild() {
        return this.mChild;
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
    }

    public boolean isParent() {
        return this.mWrappedParent;
    }

    public boolean isParentInitiallyExpanded() {
        if (!this.mWrappedParent) {
            throw new IllegalStateException("Parent not wrapped");
        }
        return this.mParent.isInitiallyExpanded();
    }

    public List<ExpandableWrapper<P, C>> getWrappedChildList() {
        if (!this.mWrappedParent) {
            throw new IllegalStateException("Parent not wrapped");
        }
        return this.mWrappedChildList;
    }

    private List<ExpandableWrapper<P, C>> generateChildItemList(P parentListItem) {
        ArrayList<ExpandableWrapper<P, C>> childItemList = new ArrayList<ExpandableWrapper<P, C>>();
        for (Object child : parentListItem.getChildList()) {
            childItemList.add(new ExpandableWrapper(child));
        }
        return childItemList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandableWrapper that = (ExpandableWrapper)o;
        if (this.mParent != null ? !this.mParent.equals(that.mParent) : that.mParent != null) {
            return false;
        }
        return this.mChild != null ? this.mChild.equals(that.mChild) : that.mChild == null;
    }

    public int hashCode() {
        int result = this.mParent != null ? this.mParent.hashCode() : 0;
        result = 31 * result + (this.mChild != null ? this.mChild.hashCode() : 0);
        return result;
    }
}

