/*
 * Decompiled with CFR 0.152.
 */
package com.bignerdranch.expandablerecyclerview.Adapter;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import com.bignerdranch.expandablerecyclerview.Adapter.ExpandableRecyclerAdapterHelper;
import com.bignerdranch.expandablerecyclerview.Model.ParentListItem;
import com.bignerdranch.expandablerecyclerview.Model.ParentWrapper;
import com.bignerdranch.expandablerecyclerview.ViewHolder.ChildViewHolder;
import com.bignerdranch.expandablerecyclerview.ViewHolder.ParentViewHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class ExpandableRecyclerAdapter<PVH extends ParentViewHolder, CVH extends ChildViewHolder>
extends RecyclerView.Adapter<RecyclerView.ViewHolder>
implements ParentViewHolder.ParentListItemExpandCollapseListener {
    private static final String EXPANDED_STATE_MAP = "ExpandableRecyclerAdapter.ExpandedStateMap";
    private static final int TYPE_PARENT = 0;
    private static final int TYPE_CHILD = 1;
    protected List<Object> mItemList;
    private List<? extends ParentListItem> mParentItemList;
    private ExpandCollapseListener mExpandCollapseListener;
    private List<RecyclerView> mAttachedRecyclerViewPool;

    public ExpandableRecyclerAdapter(@NonNull List<? extends ParentListItem> parentItemList) {
        this.mParentItemList = parentItemList;
        this.mItemList = ExpandableRecyclerAdapterHelper.generateParentChildItemList(parentItemList);
        this.mAttachedRecyclerViewPool = new ArrayList<RecyclerView>();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int viewType) {
        if (viewType == 0) {
            PVH pvh = this.onCreateParentViewHolder(viewGroup);
            ((ParentViewHolder)((Object)pvh)).setParentListItemExpandCollapseListener(this);
            return pvh;
        }
        if (viewType == 1) {
            return this.onCreateChildViewHolder(viewGroup);
        }
        throw new IllegalStateException("Incorrect ViewType found");
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            ParentViewHolder parentViewHolder = (ParentViewHolder)holder;
            if (parentViewHolder.shouldItemViewClickToggleExpansion()) {
                parentViewHolder.setMainItemClickToExpand();
            }
            ParentWrapper parentWrapper = (ParentWrapper)listItem;
            parentViewHolder.setExpanded(parentWrapper.isExpanded());
            this.onBindParentViewHolder(parentViewHolder, position, parentWrapper.getParentListItem());
        } else {
            if (listItem == null) {
                throw new IllegalStateException("Incorrect ViewHolder found");
            }
            this.onBindChildViewHolder((ChildViewHolder)holder, position, listItem);
        }
    }

    public abstract PVH onCreateParentViewHolder(ViewGroup var1);

    public abstract CVH onCreateChildViewHolder(ViewGroup var1);

    public abstract void onBindParentViewHolder(PVH var1, int var2, ParentListItem var3);

    public abstract void onBindChildViewHolder(CVH var1, int var2, Object var3);

    public int getItemCount() {
        return this.mItemList.size();
    }

    public int getItemViewType(int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            return 0;
        }
        if (listItem == null) {
            throw new IllegalStateException("Null object added");
        }
        return 1;
    }

    public List<? extends ParentListItem> getParentItemList() {
        return this.mParentItemList;
    }

    @Override
    public void onParentListItemExpanded(int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            this.expandParentListItem((ParentWrapper)listItem, position, true);
        }
    }

    @Override
    public void onParentListItemCollapsed(int position) {
        Object listItem = this.getListItem(position);
        if (listItem instanceof ParentWrapper) {
            this.collapseParentListItem((ParentWrapper)listItem, position, true);
        }
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.mAttachedRecyclerViewPool.add(recyclerView);
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.mAttachedRecyclerViewPool.remove(recyclerView);
    }

    public void setExpandCollapseListener(ExpandCollapseListener expandCollapseListener) {
        this.mExpandCollapseListener = expandCollapseListener;
    }

    public void expandParent(int parentIndex) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentIndex);
        Object listItem = this.getListItem(parentWrapperIndex);
        if (!(listItem instanceof ParentWrapper)) {
            return;
        }
        ParentWrapper parentWrapper = (ParentWrapper)listItem;
        this.expandViews(parentWrapper, parentWrapperIndex);
    }

    public void expandParent(ParentListItem parentListItem) {
        ParentWrapper parentWrapper = this.getParentWrapper(parentListItem);
        int parentWrapperIndex = this.mItemList.indexOf(parentWrapper);
        if (parentWrapperIndex == -1) {
            return;
        }
        this.expandViews(parentWrapper, parentWrapperIndex);
    }

    public void expandParentRange(int startParentIndex, int parentCount) {
        int endParentIndex = startParentIndex + parentCount;
        for (int i = startParentIndex; i < endParentIndex; ++i) {
            this.expandParent(i);
        }
    }

    public void expandAllParents() {
        for (ParentListItem parentListItem : this.mParentItemList) {
            this.expandParent(parentListItem);
        }
    }

    public void collapseParent(int parentIndex) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentIndex);
        Object listItem = this.getListItem(parentWrapperIndex);
        if (!(listItem instanceof ParentWrapper)) {
            return;
        }
        ParentWrapper parentWrapper = (ParentWrapper)listItem;
        this.collapseViews(parentWrapper, parentWrapperIndex);
    }

    public void collapseParent(ParentListItem parentListItem) {
        ParentWrapper parentWrapper = this.getParentWrapper(parentListItem);
        int parentWrapperIndex = this.mItemList.indexOf(parentWrapper);
        if (parentWrapperIndex == -1) {
            return;
        }
        this.collapseViews(parentWrapper, parentWrapperIndex);
    }

    public void collapseParentRange(int startParentIndex, int parentCount) {
        int endParentIndex = startParentIndex + parentCount;
        for (int i = startParentIndex; i < endParentIndex; ++i) {
            this.collapseParent(i);
        }
    }

    public void collapseAllParents() {
        for (ParentListItem parentListItem : this.mParentItemList) {
            this.collapseParent(parentListItem);
        }
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        savedInstanceState.putSerializable(EXPANDED_STATE_MAP, this.generateExpandedStateMap());
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null || !savedInstanceState.containsKey(EXPANDED_STATE_MAP)) {
            return;
        }
        HashMap expandedStateMap = (HashMap)savedInstanceState.getSerializable(EXPANDED_STATE_MAP);
        if (expandedStateMap == null) {
            return;
        }
        ArrayList<Object> parentWrapperList = new ArrayList<Object>();
        int parentListItemCount = this.mParentItemList.size();
        for (int i = 0; i < parentListItemCount; ++i) {
            boolean expanded;
            ParentListItem parentListItem = this.mParentItemList.get(i);
            ParentWrapper parentWrapper = new ParentWrapper(parentListItem);
            parentWrapperList.add(parentWrapper);
            if (!expandedStateMap.containsKey(i) || !(expanded = ((Boolean)expandedStateMap.get(i)).booleanValue())) continue;
            parentWrapper.setExpanded(true);
            int childListItemCount = parentWrapper.getChildItemList().size();
            for (int j = 0; j < childListItemCount; ++j) {
                parentWrapperList.add(parentWrapper.getChildItemList().get(j));
            }
        }
        this.mItemList = parentWrapperList;
        this.notifyDataSetChanged();
    }

    protected Object getListItem(int position) {
        boolean indexInRange;
        boolean bl = indexInRange = position >= 0 && position < this.mItemList.size();
        if (indexInRange) {
            return this.mItemList.get(position);
        }
        return null;
    }

    private void expandViews(ParentWrapper parentWrapper, int parentIndex) {
        for (RecyclerView recyclerView : this.mAttachedRecyclerViewPool) {
            ParentViewHolder viewHolder = (ParentViewHolder)recyclerView.findViewHolderForAdapterPosition(parentIndex);
            if (viewHolder != null && !viewHolder.isExpanded()) {
                viewHolder.setExpanded(true);
                viewHolder.onExpansionToggled(false);
            }
            this.expandParentListItem(parentWrapper, parentIndex, false);
        }
    }

    private void collapseViews(ParentWrapper parentWrapper, int parentIndex) {
        for (RecyclerView recyclerView : this.mAttachedRecyclerViewPool) {
            ParentViewHolder viewHolder = (ParentViewHolder)recyclerView.findViewHolderForAdapterPosition(parentIndex);
            if (viewHolder != null && viewHolder.isExpanded()) {
                viewHolder.setExpanded(false);
                viewHolder.onExpansionToggled(true);
            }
            this.collapseParentListItem(parentWrapper, parentIndex, false);
        }
    }

    private void expandParentListItem(ParentWrapper parentWrapper, int parentIndex, boolean expansionTriggeredByListItemClick) {
        if (!parentWrapper.isExpanded()) {
            parentWrapper.setExpanded(true);
            List<?> childItemList = parentWrapper.getChildItemList();
            if (childItemList != null) {
                int childListItemCount = childItemList.size();
                for (int i = 0; i < childListItemCount; ++i) {
                    this.mItemList.add(parentIndex + i + 1, childItemList.get(i));
                }
                this.notifyItemRangeInserted(parentIndex + 1, childListItemCount);
            }
            if (expansionTriggeredByListItemClick && this.mExpandCollapseListener != null) {
                int expandedCountBeforePosition = this.getExpandedItemCount(parentIndex);
                this.mExpandCollapseListener.onListItemExpanded(parentIndex - expandedCountBeforePosition);
            }
        }
    }

    private void collapseParentListItem(ParentWrapper parentWrapper, int parentIndex, boolean collapseTriggeredByListItemClick) {
        if (parentWrapper.isExpanded()) {
            parentWrapper.setExpanded(false);
            List<?> childItemList = parentWrapper.getChildItemList();
            if (childItemList != null) {
                int childListItemCount = childItemList.size();
                for (int i = childListItemCount - 1; i >= 0; --i) {
                    this.mItemList.remove(parentIndex + i + 1);
                }
                this.notifyItemRangeRemoved(parentIndex + 1, childListItemCount);
            }
            if (collapseTriggeredByListItemClick && this.mExpandCollapseListener != null) {
                int expandedCountBeforePosition = this.getExpandedItemCount(parentIndex);
                this.mExpandCollapseListener.onListItemCollapsed(parentIndex - expandedCountBeforePosition);
            }
        }
    }

    private int getExpandedItemCount(int position) {
        if (position == 0) {
            return 0;
        }
        int expandedCount = 0;
        for (int i = 0; i < position; ++i) {
            Object listItem = this.getListItem(i);
            if (listItem instanceof ParentWrapper) continue;
            ++expandedCount;
        }
        return expandedCount;
    }

    public void notifyParentItemInserted(int parentPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int wrapperIndex = parentPosition < this.mParentItemList.size() - 1 ? this.getParentWrapperIndex(parentPosition) : this.mItemList.size();
        int sizeChanged = this.addParentWrapper(wrapperIndex, parentListItem);
        this.notifyItemRangeInserted(wrapperIndex, sizeChanged);
    }

    public void notifyParentItemRangeInserted(int parentPositionStart, int itemCount) {
        int initialWrapperIndex = parentPositionStart < this.mParentItemList.size() - itemCount ? this.getParentWrapperIndex(parentPositionStart) : this.mItemList.size();
        int sizeChanged = 0;
        int wrapperIndex = initialWrapperIndex;
        int parentPositionEnd = parentPositionStart + itemCount;
        for (int i = parentPositionStart; i < parentPositionEnd; ++i) {
            ParentListItem parentListItem = this.mParentItemList.get(i);
            int changed = this.addParentWrapper(wrapperIndex, parentListItem);
            wrapperIndex += changed;
            sizeChanged += changed;
        }
        this.notifyItemRangeInserted(initialWrapperIndex, sizeChanged);
    }

    private int addParentWrapper(int wrapperIndex, ParentListItem parentListItem) {
        int sizeChanged = 1;
        ParentWrapper parentWrapper = new ParentWrapper(parentListItem);
        this.mItemList.add(wrapperIndex, parentWrapper);
        if (parentWrapper.isInitiallyExpanded()) {
            parentWrapper.setExpanded(true);
            List<?> childItemList = parentWrapper.getChildItemList();
            this.mItemList.addAll(wrapperIndex + sizeChanged, childItemList);
            sizeChanged += childItemList.size();
        }
        return sizeChanged;
    }

    public void notifyParentItemRemoved(int parentPosition) {
        int wrapperIndex = this.getParentWrapperIndex(parentPosition);
        int sizeChanged = this.removeParentWrapper(wrapperIndex);
        this.notifyItemRangeRemoved(wrapperIndex, sizeChanged);
    }

    public void notifyParentItemRangeRemoved(int parentPositionStart, int itemCount) {
        int sizeChanged = 0;
        int wrapperIndex = this.getParentWrapperIndex(parentPositionStart);
        for (int i = 0; i < itemCount; ++i) {
            sizeChanged += this.removeParentWrapper(wrapperIndex);
        }
        this.notifyItemRangeRemoved(wrapperIndex, sizeChanged);
    }

    private int removeParentWrapper(int parentWrapperIndex) {
        int sizeChanged = 1;
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.remove(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            int childListSize = parentWrapper.getChildItemList().size();
            for (int i = 0; i < childListSize; ++i) {
                this.mItemList.remove(parentWrapperIndex);
                ++sizeChanged;
            }
        }
        return sizeChanged;
    }

    public void notifyParentItemChanged(int parentPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int wrapperIndex = this.getParentWrapperIndex(parentPosition);
        int sizeChanged = this.changeParentWrapper(wrapperIndex, parentListItem);
        this.notifyItemRangeChanged(wrapperIndex, sizeChanged);
    }

    public void notifyParentItemRangeChanged(int parentPositionStart, int itemCount) {
        int initialWrapperIndex;
        int wrapperIndex = initialWrapperIndex = this.getParentWrapperIndex(parentPositionStart);
        int sizeChanged = 0;
        for (int j = 0; j < itemCount; ++j) {
            ParentListItem parentListItem = this.mParentItemList.get(parentPositionStart);
            int changed = this.changeParentWrapper(wrapperIndex, parentListItem);
            sizeChanged += changed;
            wrapperIndex += changed;
            ++parentPositionStart;
        }
        this.notifyItemRangeChanged(initialWrapperIndex, sizeChanged);
    }

    private int changeParentWrapper(int wrapperIndex, ParentListItem parentListItem) {
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(wrapperIndex);
        parentWrapper.setParentListItem(parentListItem);
        int sizeChanged = 1;
        if (parentWrapper.isExpanded()) {
            List<?> childItems = parentWrapper.getChildItemList();
            int childListSize = childItems.size();
            for (int i = 0; i < childListSize; ++i) {
                Object child = childItems.get(i);
                this.mItemList.set(wrapperIndex + i + 1, child);
                ++sizeChanged;
            }
        }
        return sizeChanged;
    }

    public void notifyParentItemMoved(int fromParentPosition, int toParentPosition) {
        boolean isExpandedNoChildren;
        int fromWrapperIndex = this.getParentWrapperIndex(fromParentPosition);
        ParentWrapper fromParentWrapper = (ParentWrapper)this.mItemList.get(fromWrapperIndex);
        boolean isCollapsed = !fromParentWrapper.isExpanded();
        boolean bl = isExpandedNoChildren = !isCollapsed && fromParentWrapper.getChildItemList().size() == 0;
        if (isCollapsed || isExpandedNoChildren) {
            int toWrapperIndex = this.getParentWrapperIndex(toParentPosition);
            ParentWrapper toParentWrapper = (ParentWrapper)this.mItemList.get(toWrapperIndex);
            this.mItemList.remove(fromWrapperIndex);
            int childOffset = 0;
            if (toParentWrapper.isExpanded()) {
                childOffset = toParentWrapper.getChildItemList().size();
            }
            this.mItemList.add(toWrapperIndex + childOffset, fromParentWrapper);
            this.notifyItemMoved(fromWrapperIndex, toWrapperIndex + childOffset);
        } else {
            int sizeChanged = 0;
            int childListSize = fromParentWrapper.getChildItemList().size();
            for (int i = 0; i < childListSize + 1; ++i) {
                this.mItemList.remove(fromWrapperIndex);
                ++sizeChanged;
            }
            this.notifyItemRangeRemoved(fromWrapperIndex, sizeChanged);
            int toWrapperIndex = this.getParentWrapperIndex(toParentPosition);
            int childOffset = 0;
            if (toWrapperIndex != -1) {
                ParentWrapper toParentWrapper = (ParentWrapper)this.mItemList.get(toWrapperIndex);
                if (toParentWrapper.isExpanded()) {
                    childOffset = toParentWrapper.getChildItemList().size();
                }
            } else {
                toWrapperIndex = this.mItemList.size();
            }
            this.mItemList.add(toWrapperIndex + childOffset, fromParentWrapper);
            List<?> childItemList = fromParentWrapper.getChildItemList();
            sizeChanged = childItemList.size() + 1;
            this.mItemList.addAll(toWrapperIndex + childOffset + 1, childItemList);
            this.notifyItemRangeInserted(toWrapperIndex + childOffset, sizeChanged);
        }
    }

    public void notifyChildItemInserted(int parentPosition, int childPosition) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
            Object child = parentListItem.getChildItemList().get(childPosition);
            this.mItemList.add(parentWrapperIndex + childPosition + 1, child);
            this.notifyItemInserted(parentWrapperIndex + childPosition + 1);
        }
    }

    public void notifyChildItemRangeInserted(int parentPosition, int childPositionStart, int itemCount) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
            List<?> childList = parentListItem.getChildItemList();
            for (int i = 0; i < itemCount; ++i) {
                Object child = childList.get(childPositionStart + i);
                this.mItemList.add(parentWrapperIndex + childPositionStart + i + 1, child);
            }
            this.notifyItemRangeInserted(parentWrapperIndex + childPositionStart + 1, itemCount);
        }
    }

    public void notifyChildItemRemoved(int parentPosition, int childPosition) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            this.mItemList.remove(parentWrapperIndex + childPosition + 1);
            this.notifyItemRemoved(parentWrapperIndex + childPosition + 1);
        }
    }

    public void notifyChildItemRangeRemoved(int parentPosition, int childPositionStart, int itemCount) {
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        if (parentWrapper.isExpanded()) {
            for (int i = 0; i < itemCount; ++i) {
                this.mItemList.remove(parentWrapperIndex + childPositionStart + 1);
            }
            this.notifyItemRangeRemoved(parentWrapperIndex + childPositionStart + 1, itemCount);
        }
    }

    public void notifyChildItemChanged(int parentPosition, int childPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        parentWrapper.setParentListItem(parentListItem);
        if (parentWrapper.isExpanded()) {
            int listChildPosition = parentWrapperIndex + childPosition + 1;
            Object child = parentWrapper.getChildItemList().get(childPosition);
            this.mItemList.set(listChildPosition, child);
            this.notifyItemChanged(listChildPosition);
        }
    }

    public void notifyChildItemRangeChanged(int parentPosition, int childPositionStart, int itemCount) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        parentWrapper.setParentListItem(parentListItem);
        if (parentWrapper.isExpanded()) {
            int listChildPosition = parentWrapperIndex + childPositionStart + 1;
            for (int i = 0; i < itemCount; ++i) {
                Object child = parentWrapper.getChildItemList().get(childPositionStart + i);
                this.mItemList.set(listChildPosition + i, child);
            }
            this.notifyItemRangeChanged(listChildPosition, itemCount);
        }
    }

    public void notifyChildItemMoved(int parentPosition, int fromChildPosition, int toChildPosition) {
        ParentListItem parentListItem = this.mParentItemList.get(parentPosition);
        int parentWrapperIndex = this.getParentWrapperIndex(parentPosition);
        ParentWrapper parentWrapper = (ParentWrapper)this.mItemList.get(parentWrapperIndex);
        parentWrapper.setParentListItem(parentListItem);
        if (parentWrapper.isExpanded()) {
            Object fromChild = this.mItemList.remove(parentWrapperIndex + 1 + fromChildPosition);
            this.mItemList.add(parentWrapperIndex + 1 + toChildPosition, fromChild);
            this.notifyItemMoved(parentWrapperIndex + 1 + fromChildPosition, parentWrapperIndex + 1 + toChildPosition);
        }
    }

    private HashMap<Integer, Boolean> generateExpandedStateMap() {
        HashMap<Integer, Boolean> parentListItemHashMap = new HashMap<Integer, Boolean>();
        int childCount = 0;
        int listItemCount = this.mItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            if (this.mItemList.get(i) == null) continue;
            Object listItem = this.getListItem(i);
            if (listItem instanceof ParentWrapper) {
                ParentWrapper parentWrapper = (ParentWrapper)listItem;
                parentListItemHashMap.put(i - childCount, parentWrapper.isExpanded());
                continue;
            }
            ++childCount;
        }
        return parentListItemHashMap;
    }

    private int getParentWrapperIndex(int parentIndex) {
        int parentCount = 0;
        int listItemCount = this.mItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            if (!(this.mItemList.get(i) instanceof ParentWrapper) || ++parentCount <= parentIndex) continue;
            return i;
        }
        return -1;
    }

    private ParentWrapper getParentWrapper(ParentListItem parentListItem) {
        int listItemCount = this.mItemList.size();
        for (int i = 0; i < listItemCount; ++i) {
            Object listItem = this.mItemList.get(i);
            if (!(listItem instanceof ParentWrapper) || !((ParentWrapper)listItem).getParentListItem().equals(parentListItem)) continue;
            return (ParentWrapper)listItem;
        }
        return null;
    }

    public static interface ExpandCollapseListener {
        public void onListItemExpanded(int var1);

        public void onListItemCollapsed(int var1);
    }
}

