/*
 * Decompiled with CFR 0.152.
 */
package com.biao.pulltorefresh.utils;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;

public class ViewScrollChecker {
    private static final String TAG = ViewScrollChecker.class.getSimpleName();
    public static final byte DIRECTION_DOWN = -1;
    public static final byte DIRECTION_UP = 1;
    private static final boolean DEBUG_SCROLL_CHECK = false;

    public static boolean isDirectionDown(byte direction) {
        return direction == -1;
    }

    public static boolean isDirectionUp(byte direction) {
        return direction == 1;
    }

    public static boolean canViewScrollVerticallyDown(View view) {
        return ViewScrollChecker.canViewScrollVertically(view, -1);
    }

    public static boolean canViewScrollVerticallyUp(View view) {
        return ViewScrollChecker.canViewScrollVertically(view, 1);
    }

    public static boolean canViewScrollVertically(View view, int direction) {
        boolean result;
        block8: {
            result = false;
            if (Build.VERSION.SDK_INT < 14) {
                if (view instanceof AbsListView) {
                    result = ViewScrollChecker.performAbsListView((AbsListView)view, direction);
                } else {
                    try {
                        Class<?> viewClass = view.getClass();
                        int offset = (Integer)viewClass.getDeclaredMethod("computeVerticalScrollOffset", new Class[0]).invoke((Object)view, new Object[0]);
                        int range = (Integer)viewClass.getDeclaredMethod("computeVerticalScrollRange", new Class[0]).invoke((Object)view, new Object[0]) - (Integer)viewClass.getDeclaredMethod("computeVerticalScrollExtent", new Class[0]).invoke((Object)view, new Object[0]);
                        if (range == 0) {
                            return false;
                        }
                        if (direction < 0) {
                            result = offset > 0;
                            break block8;
                        }
                        result = offset < range - 1;
                    }
                    catch (Exception e) {
                        result = view.getScrollY() > 0;
                    }
                }
            } else {
                result = view.canScrollVertically(direction);
            }
        }
        return result;
    }

    private static boolean performAbsListView(AbsListView view, int direction) {
        int childCount = view.getChildCount();
        if (childCount > 0) {
            switch (direction) {
                case -1: {
                    ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
                    int firstItemTop = view.getChildAt(0).getTop();
                    int listViewTop = view.getTop() + view.getPaddingTop() - lp.topMargin;
                    return view.getFirstVisiblePosition() > 0 || firstItemTop < listViewTop;
                }
                case 1: {
                    int lastItemBottom = view.getChildAt(childCount - 1).getBottom();
                    int listViewBottom = view.getBottom() - view.getPaddingBottom();
                    return view.getLastVisiblePosition() < childCount - 1 || lastItemBottom > listViewBottom;
                }
            }
        }
        return false;
    }
}

