/*
 * Decompiled with CFR 0.152.
 */
package com.biao.pulltorefresh.header;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.biao.pulltorefresh.PtrHandler;
import com.biao.pulltorefresh.R;
import com.biao.pulltorefresh.header.MaterialProgressDrawable;

public class DefaultRefreshView
extends FrameLayout
implements PtrHandler {
    private static final String TAG = DefaultRefreshView.class.getSimpleName();
    private static final boolean DEBUG = false;
    private TextView mTextView;
    private MaterialProgressDrawable mDrawable;
    private boolean isPullDown = true;

    public DefaultRefreshView(Context context) {
        super(context);
        this.setUpView(context);
    }

    public DefaultRefreshView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setUpView(context);
    }

    public DefaultRefreshView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setUpView(context);
    }

    @TargetApi(value=21)
    public DefaultRefreshView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setUpView(context);
    }

    private void setUpView(Context context) {
        View view = LayoutInflater.from((Context)context).inflate(R.layout.header_default, (ViewGroup)this);
        this.mTextView = (TextView)view.findViewById(R.id.text);
        ImageView imageView = (ImageView)view.findViewById(R.id.icon);
        this.mDrawable = new MaterialProgressDrawable(context, (View)imageView);
        this.mDrawable.setBackgroundColor(-1);
        imageView.setImageDrawable((Drawable)this.mDrawable);
    }

    public void setIsPullDown(boolean isPullDown) {
        this.isPullDown = isPullDown;
    }

    public void setColorSchemeColors(int[] colors) {
        this.mDrawable.setColorSchemeColors(colors);
    }

    @Override
    public void onRefreshBegin() {
        this.mTextView.setText(R.string.refresh_start);
        this.mDrawable.setAlpha(255);
        this.mDrawable.start();
    }

    @Override
    public void onRefreshEnd() {
        this.mTextView.setText(R.string.refresh_end);
        this.mDrawable.stop();
    }

    @Override
    public void onPercent(float percent) {
        this.mDrawable.setAlpha((int)(255.0f * percent));
        this.mDrawable.showArrow(true);
        float strokeStart = percent * 0.8f;
        this.mDrawable.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
        this.mDrawable.setArrowScale(Math.min(1.0f, percent));
        float rotation = (-0.25f + 0.4f * percent + percent * 2.0f) * 0.5f;
        this.mDrawable.setProgressRotation(rotation);
        this.changeText(percent);
    }

    private void changeText(float percent) {
        if (percent == 1.0f) {
            this.mTextView.setText(R.string.release_to_refresh);
        } else {
            this.mTextView.setText(this.isPullDown ? R.string.pull_down_to_refresh : R.string.pull_up_to_refresh);
        }
    }
}

