/*
 * Decompiled with CFR 0.152.
 */
package com.biao.pulltorefresh;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.biao.pulltorefresh.OnRefreshListener;
import com.biao.pulltorefresh.PtrHandler;
import com.biao.pulltorefresh.PtrViewHolder;
import com.biao.pulltorefresh.utils.L;
import com.biao.pulltorefresh.utils.ViewScrollChecker;

public class PtrLayout
extends ViewGroup {
    private static final String TAG = PtrLayout.class.getSimpleName();
    private static final boolean DEBUG_INTERCEPT = false;
    private static final boolean DEBUG_TOUCH = false;
    private static final int DEFAULT_RELEASE_DISTANCE = 70;
    private static final float DRAG_RATE = 0.5f;
    private static final int HEADER_MOVE = 4;
    private static final int CONTENT_MOVE = 2;
    private static final int FOOTER_MOVE = 1;
    public static final int MODE_ALL_MOVE = 7;
    public static final int MODE_ONLY_CONTENT_NOT_MOVE = 5;
    public static final int MODE_ONLY_FOOTER_NOT_MOVE = 6;
    public static final int MODE_ONLY_HEADER_NOT_MOVE = 3;
    public static final int MODE_ONLY_CONTENT_MOVE = 2;
    private int mTouchSlop;
    private int mDefaultReleaseDist;
    private int mMode;
    private float mInitialDownY;
    private float mLastDownY;
    private float mDistanceY;
    private byte mInterceptDirection;
    private boolean mIsBeingDragged;
    private PtrScroller mPtrScroller;
    private PtrViewHolder mHeaderView;
    private PtrViewHolder mFooterView;
    private PtrViewHolder mContentView;
    private boolean mIsRefreshing;
    private byte mRefreshDirection;

    public PtrLayout(Context context) {
        super(context);
    }

    public PtrLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PtrLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public PtrLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        Context context = this.getContext();
        this.mHeaderView = new PtrViewHolder();
        this.mContentView = new PtrViewHolder();
        this.mFooterView = new PtrViewHolder();
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mDefaultReleaseDist = Math.round(70.0f * context.getResources().getDisplayMetrics().density);
        int childCount = this.getChildCount();
        if (childCount != 1) {
            throw new IllegalStateException("PtrLayout can only have one child now !!");
        }
        this.mContentView.view = this.getChildAt(0);
        this.mPtrScroller = new PtrScroller(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView.isNotEmpty()) {
            this.measureChildWithMargins(this.mHeaderView.view, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
        if (this.mContentView.isNotEmpty()) {
            this.measureChildWithMargins(this.mContentView.view, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
        if (this.mFooterView.isNotEmpty()) {
            this.measureChildWithMargins(this.mFooterView.view, widthMeasureSpec, 0, heightMeasureSpec, 0);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (this.mHeaderView.isNotEmpty()) {
            int headerHeight = this.mHeaderView.view.getMeasuredHeight();
            this.layoutChild(this.mHeaderView.view, 0, this.mHeaderView.canScroll() ? -headerHeight + this.mHeaderView.offsetY : 0, 0, 0);
            if (!this.mContentView.canScroll()) {
                this.bringChildToFront(this.mHeaderView.view);
            }
            if (this.mHeaderView.releaseDist == 0) {
                this.mHeaderView.releaseDist = headerHeight;
            }
        }
        if (this.mContentView.isNotEmpty()) {
            this.layoutChild(this.mContentView.view, 0, this.mContentView.canScroll() ? this.mContentView.offsetY : 0, 0, 0);
        }
        if (this.mFooterView.isNotEmpty()) {
            int footerHeight = this.mFooterView.view.getMeasuredHeight();
            int footerTop = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
            this.layoutChild(this.mFooterView.view, 0, this.mFooterView.canScroll() ? footerTop + this.mFooterView.offsetY : footerTop + this.mFooterView.offsetY - footerHeight, 0, 0);
            if (!this.mContentView.canScroll()) {
                this.bringChildToFront(this.mFooterView.view);
            }
            if (this.mFooterView.releaseDist == 0) {
                this.mFooterView.releaseDist = footerHeight;
            }
        }
    }

    private void layoutChild(View child, int leftUsed, int topUsed, int rightUsed, int bottomUsed) {
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int left = paddingLeft + lp.leftMargin + leftUsed;
        int top = paddingTop + lp.topMargin + topUsed;
        int right = left + child.getMeasuredWidth() + rightUsed;
        int bottom = top + child.getMeasuredHeight() + bottomUsed;
        child.layout(left, top, right, bottom);
    }

    public void setMode(int mode) {
        switch (mode) {
            default: {
                L.e(TAG, "mode value is Bad!");
            }
            case 7: {
                this.mMode = 7;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                this.mMode = mode;
            }
        }
        this.mHeaderView.setFlag((this.mMode & 4) >> 2);
        this.mContentView.setFlag((this.mMode & 2) >> 1);
        this.mFooterView.setFlag(this.mMode & 1);
    }

    public void setHeaderView(View view) {
        this.setView(this.mHeaderView, view);
    }

    public void setFooterView(View view) {
        this.setView(this.mFooterView, view);
    }

    private void setView(PtrViewHolder ptrViewHolder, View view) {
        View originalView;
        if (ptrViewHolder == null) {
            L.e("ptrViewHolder can not be null!");
            return;
        }
        if (view == null) {
            L.e("view is null!!!");
            return;
        }
        Object lp = view.getLayoutParams();
        if (lp == null) {
            lp = new LayoutParams(-1, -2);
            view.setLayoutParams(lp);
        }
        if ((originalView = ptrViewHolder.getView()) != null) {
            this.removeView(originalView);
            if (originalView instanceof PtrHandler) {
                ((PtrHandler)originalView).onRefreshEnd();
            }
        }
        if (view instanceof PtrHandler) {
            ptrViewHolder.setPtrHandler((PtrHandler)view);
        }
        ptrViewHolder.setView(view);
        if (this.mMode == 5) {
            this.addView(view);
        } else {
            this.addView(view, 0);
        }
    }

    public void setHeaderPtrHandler(PtrHandler ptrHandler) {
        this.mHeaderView.setPtrHandler(ptrHandler);
    }

    public void setFootererPtrHandler(PtrHandler ptrHandler) {
        this.mFooterView.setPtrHandler(ptrHandler);
    }

    public void setHeaderReleaseDist(int dist) {
        if (dist < 0) {
            return;
        }
        this.mHeaderView.releaseDist = dist;
    }

    public void setFooterReleaseDist(int dist) {
        if (dist < 0) {
            return;
        }
        this.mFooterView.releaseDist = dist;
    }

    private int getReleaseDist(PtrViewHolder ptrViewHolder) {
        return ptrViewHolder != null && ptrViewHolder.releaseDist > 0 ? ptrViewHolder.releaseDist : this.mDefaultReleaseDist;
    }

    public boolean isRefreshing() {
        return this.mIsRefreshing;
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        if (!this.isEnabled() || !this.mContentView.canScroll() && this.mIsRefreshing) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsBeingDragged = false;
                this.mInitialDownY = event.getRawY();
                break;
            }
            case 2: {
                if (this.mContentView.canScrollAndIsNotOriginalLocation()) {
                    this.mIsBeingDragged = true;
                    this.mLastDownY = this.mInitialDownY;
                    break;
                }
                this.mDistanceY = event.getRawY() - this.mInitialDownY;
                if (!(Math.abs(this.mDistanceY) > (float)this.mTouchSlop)) break;
                this.mLastDownY = this.mDistanceY > 0.0f ? this.mInitialDownY + (float)this.mTouchSlop : this.mInitialDownY - (float)this.mTouchSlop;
                this.mInterceptDirection = (byte)(this.mDistanceY > 0.0f ? -1 : 1);
                this.mIsBeingDragged = !ViewScrollChecker.canViewScrollVertically(this.mContentView.view, this.mInterceptDirection);
                break;
            }
            case 1: {
                this.mIsBeingDragged = false;
            }
        }
        return this.mIsBeingDragged;
    }

    public void setOnTouchListener(View.OnTouchListener l) {
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        PtrViewHolder ptrViewHolder = null;
        switch (event.getAction()) {
            case 0: {
                this.mLastDownY = event.getRawY();
                this.mPtrScroller.abortScroll();
                break;
            }
            case 5: {
                break;
            }
            case 2: {
                this.mDistanceY = event.getRawY() - this.mLastDownY;
                this.mDistanceY *= 0.5f;
                ptrViewHolder = this.getInterceptPtrView();
                if (!(ptrViewHolder.canScroll() && ptrViewHolder.isOutOriginalLocation(this.mInterceptDirection, this.mDistanceY) || ptrViewHolder != this.mContentView && this.mContentView.canScroll() && this.mContentView.isOutOriginalLocation(this.mInterceptDirection, this.mDistanceY))) {
                    this.performMove(ptrViewHolder, (int)this.mDistanceY);
                }
                this.mLastDownY = event.getRawY();
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                if (!this.hasRefreshView(this.mInterceptDirection)) {
                    this.mPtrScroller.smoothScroll(this.mContentView.offsetY);
                    return true;
                }
                ptrViewHolder = this.getInterceptPtrView();
                int releaseDist = this.getReleaseDist(ptrViewHolder);
                if (!this.mIsRefreshing) {
                    int scrollY = this.getInterceptOffsetY();
                    if (Math.abs(scrollY) < releaseDist) {
                        this.mPtrScroller.smoothScroll(scrollY);
                        break;
                    }
                    this.performRefresh();
                    break;
                }
                int scrollY = this.getRefreshOffsetY();
                if (this.mRefreshDirection == this.mInterceptDirection && Math.abs(scrollY) > releaseDist) {
                    scrollY = scrollY > 0 ? scrollY - releaseDist : scrollY + releaseDist;
                }
                this.mPtrScroller.smoothScroll(scrollY);
            }
        }
        return true;
    }

    private boolean hasRefreshView(byte interceptDirection) {
        switch (interceptDirection) {
            case -1: {
                return this.mHeaderView.isNotEmpty();
            }
            case 1: {
                return this.mFooterView.isNotEmpty();
            }
        }
        return false;
    }

    private PtrViewHolder getInterceptPtrView() {
        return this.getPtrView(this.mInterceptDirection, true);
    }

    private PtrViewHolder getRefreshPtrView() {
        return this.getPtrView(this.mRefreshDirection, true);
    }

    private PtrViewHolder getInterceptPtrView(boolean ignoreScroll) {
        return this.getPtrView(this.mInterceptDirection, ignoreScroll);
    }

    private PtrViewHolder getRefreshPtrView(boolean ignoreScroll) {
        return this.getPtrView(this.mRefreshDirection, ignoreScroll);
    }

    private PtrViewHolder getPtrView(int direction, boolean ignoreScroll) {
        switch (direction) {
            case -1: {
                return ignoreScroll || this.mHeaderView.canScroll() ? this.mHeaderView : this.mContentView;
            }
            case 1: {
                return ignoreScroll || this.mFooterView.canScroll() ? this.mFooterView : this.mContentView;
            }
        }
        return this.mContentView;
    }

    private int getInterceptOffsetY() {
        return this.getOffsetY(this.mInterceptDirection);
    }

    private int getRefreshOffsetY() {
        return this.getOffsetY(this.mRefreshDirection);
    }

    private int getOffsetY(int direction) {
        return this.getPtrView((int)direction, (boolean)false).offsetY;
    }

    private void performMove(PtrViewHolder ptrViewHolder, int distanceY) {
        if (ptrViewHolder == null) {
            return;
        }
        ptrViewHolder.offsetTopAndBottom(distanceY);
        if (ptrViewHolder != this.mContentView) {
            this.mContentView.offsetTopAndBottom(distanceY);
        } else {
            ptrViewHolder = this.getInterceptPtrView();
        }
        this.invalidate();
        if (!this.mIsRefreshing && ptrViewHolder.ptrHandler != null) {
            int releaseDist = this.getReleaseDist(ptrViewHolder);
            float percent = Math.abs((float)this.getInterceptOffsetY() * 1.0f / (float)releaseDist);
            ptrViewHolder.ptrHandler.onPercent(Math.min(1.0f, percent));
        }
    }

    private void performRefresh() {
        this.mRefreshDirection = this.mInterceptDirection;
        PtrViewHolder ptrViewHolder = this.getRefreshPtrView();
        if (ptrViewHolder == null) {
            L.e(TAG, "performRefresh direction = " + this.mRefreshDirection + " is bug!  let's fix it!");
            return;
        }
        this.mIsRefreshing = true;
        int offsetY = this.getRefreshOffsetY();
        if (ptrViewHolder.ptrHandler != null) {
            ptrViewHolder.ptrHandler.onRefreshBegin();
        }
        if (ptrViewHolder.mOnRefreshListener != null) {
            ptrViewHolder.mOnRefreshListener.onRefresh();
        }
        int releaseDist = this.getReleaseDist(ptrViewHolder);
        int endY = offsetY > 0 ? offsetY - releaseDist : releaseDist - Math.abs(offsetY);
        this.mPtrScroller.smoothScroll(endY);
    }

    public void onRefreshComplete() {
        L.e(TAG, "onRefreshComplete !!!");
        PtrViewHolder ptrViewHolder = this.getRefreshPtrView();
        if (ptrViewHolder == null) {
            L.e(TAG, "onRefreshComplete direction = " + this.mRefreshDirection + " is bug! let's fix it!");
            return;
        }
        if (ptrViewHolder.ptrHandler != null) {
            ptrViewHolder.ptrHandler.onRefreshEnd();
        }
        int endY = this.getRefreshOffsetY();
        if (!this.mIsBeingDragged) {
            this.mPtrScroller.smoothScroll(endY);
        }
        this.mIsRefreshing = false;
        this.mRefreshDirection = 0;
    }

    public void setDuration(int duration) {
        this.mPtrScroller.mDuration = duration;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mPtrScroller.abortScroll();
    }

    public void setOnPullDownRefreshListener(OnRefreshListener onRefreshListener) {
        this.mHeaderView.setOnRefreshListener(onRefreshListener);
    }

    public void setOnPullUpRefreshListener(OnRefreshListener onRefreshListener) {
        this.mFooterView.setOnRefreshListener(onRefreshListener);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p != null && p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class PtrScroller
    implements Runnable {
        private static final int DEFAULT_DURATION = 400;
        private int mLastScrollY;
        private Scroller mScroller;
        private boolean mIsAnimating;
        private int mDuration;

        PtrScroller(Context context) {
            this.mScroller = new Scroller(context, (Interpolator)new DecelerateInterpolator());
            this.mDuration = 400;
        }

        boolean isAnimating() {
            return this.mIsAnimating;
        }

        void smoothScroll(int startY, int duration) {
            this.mIsAnimating = true;
            this.mLastScrollY = 0;
            this.mScroller.startScroll(0, 0, 0, startY, duration);
            PtrLayout.this.post(this);
        }

        void smoothScroll(int startY) {
            this.smoothScroll(startY, this.mDuration);
        }

        void finish() {
            this.mIsAnimating = false;
        }

        void abortScroll() {
            this.mScroller.abortAnimation();
            PtrLayout.this.removeCallbacks(this);
            this.mIsAnimating = false;
        }

        @Override
        public void run() {
            if (this.mScroller.computeScrollOffset()) {
                int currY = this.mScroller.getCurrY();
                PtrLayout.this.performMove(PtrLayout.this.getInterceptPtrView(false), this.mLastScrollY - currY);
                this.mLastScrollY = currY;
                PtrLayout.this.post(this);
            } else {
                this.finish();
            }
        }
    }
}

