/*
 * Decompiled with CFR 0.152.
 */
package com.biao.pulltorefresh.utils;

import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;
import android.widget.AbsListView;

public class ViewScrollChecker {
    private static final String TAG = ViewScrollChecker.class.getSimpleName();
    public static final byte DIRECTION_DOWN = -1;
    public static final byte DIRECTION_UP = 1;
    private static final boolean DEBUG_SCROLL_CHECK = false;

    public static boolean isDirectionDown(byte direction) {
        return direction == -1;
    }

    public static boolean isDirectionUp(byte direction) {
        return direction == 1;
    }

    public static boolean canViewScrollVerticallyDown(View view) {
        return ViewScrollChecker.canViewScrollVertically(view, -1);
    }

    public static boolean canViewScrollVerticallyUp(View view) {
        return ViewScrollChecker.canViewScrollVertically(view, 1);
    }

    public static boolean canViewScrollVertically(View view, int direction) {
        if (Build.VERSION.SDK_INT < 14) {
            if (view instanceof AbsListView) {
                return ViewScrollChecker.performAbsListView((AbsListView)view, direction);
            }
            if (view instanceof RecyclerView) {
                return ViewScrollChecker.performRecyclerView((RecyclerView)view, direction);
            }
            return ViewCompat.canScrollVertically((View)view, (int)-1) || view.getScrollY() > 0;
        }
        boolean canScrollVertically = view.canScrollVertically(direction);
        return canScrollVertically;
    }

    private static boolean performAbsListView(AbsListView view, int direction) {
        AbsListView absListView = view;
        int childCount = absListView.getChildCount();
        if (childCount > 0) {
            switch (direction) {
                case -1: {
                    int firstItemTop = absListView.getChildAt(0).getTop();
                    int listViewTop = absListView.getTop() - absListView.getPaddingTop();
                    return absListView.getFirstVisiblePosition() > 0 || firstItemTop < listViewTop;
                }
                case 1: {
                    int lastItemBottom = absListView.getChildAt(childCount - 1).getBottom();
                    int listViewBottom = absListView.getBottom() - absListView.getPaddingBottom();
                    return absListView.getLastVisiblePosition() < childCount - 1 || lastItemBottom > listViewBottom;
                }
            }
        }
        return false;
    }

    private static boolean performRecyclerView(RecyclerView view, int direction) {
        RecyclerView.LayoutManager layoutManager = view.getLayoutManager();
        int childCount = view.getAdapter().getItemCount();
        boolean canScrollVertically = layoutManager.canScrollVertically();
        if (canScrollVertically && childCount > 0) {
            switch (direction) {
                case -1: {
                    int firstPosition = -1;
                    if (layoutManager instanceof GridLayoutManager) {
                        firstPosition = ((GridLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    } else if (layoutManager instanceof LinearLayoutManager) {
                        firstPosition = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
                    } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                        int[] firstPositions = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                        ((StaggeredGridLayoutManager)layoutManager).findFirstVisibleItemPositions(firstPositions);
                        firstPosition = ViewScrollChecker.findMin(firstPositions);
                    }
                    if (firstPosition == 0) {
                        int recyclerViewTop;
                        int firstItemTop = view.findViewHolderForAdapterPosition((int)firstPosition).itemView.getTop();
                        return firstItemTop < (recyclerViewTop = view.getTop() - view.getPaddingTop());
                    }
                    return true;
                }
                case 1: {
                    int lastPosition = -1;
                    if (layoutManager instanceof GridLayoutManager) {
                        lastPosition = ((GridLayoutManager)layoutManager).findLastVisibleItemPosition();
                    } else if (layoutManager instanceof LinearLayoutManager) {
                        lastPosition = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
                    } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                        int[] lastPositions = new int[((StaggeredGridLayoutManager)layoutManager).getSpanCount()];
                        ((StaggeredGridLayoutManager)layoutManager).findLastVisibleItemPositions(lastPositions);
                        lastPosition = ViewScrollChecker.findMax(lastPositions);
                    }
                    if (lastPosition == childCount - 1) {
                        int recyclerViewBottom;
                        int lastItemBottom = view.findViewHolderForAdapterPosition((int)lastPosition).itemView.getBottom();
                        return lastItemBottom > (recyclerViewBottom = view.getBottom() - view.getPaddingBottom());
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private static int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value <= min) continue;
            min = value;
        }
        return min;
    }
}

