/*
 * Decompiled with CFR 0.152.
 */
package com.biao.pulltorefresh;

import android.view.View;
import com.biao.pulltorefresh.OnRefreshListener;
import com.biao.pulltorefresh.PtrHandler;
import com.biao.pulltorefresh.utils.L;

class PtrViewHolder {
    public static final int FLAG_PIN = 0;
    public static final int FLAG_MOVE = 1;
    View view;
    int flag = 1;
    int offsetY;
    PtrHandler ptrHandler;
    OnRefreshListener mOnRefreshListener;

    PtrViewHolder() {
    }

    boolean isNotEmpty() {
        return this.view != null;
    }

    View getView() {
        return this.view;
    }

    void setView(View view) {
        this.view = view;
    }

    int getHeight() {
        return this.isNotEmpty() ? this.view.getHeight() : 0;
    }

    void setFlag(int flag) {
        if (PtrViewHolder.checkFlag(flag)) {
            this.flag = flag;
        } else {
            L.e("flag value is bad!");
        }
    }

    void offsetTopAndBottom(int dist) {
        if (this.canScroll()) {
            this.view.offsetTopAndBottom(dist);
            this.offsetY += dist;
        }
    }

    boolean canScroll() {
        return this.isNotEmpty() && this.flag == 1;
    }

    boolean isNotOriginalLocation() {
        return this.offsetY != 0;
    }

    boolean isOutOriginalLocation(byte direction, float dist) {
        if (this.isNotEmpty()) {
            switch (direction) {
                case -1: {
                    return (float)this.offsetY + dist < 0.0f;
                }
                case 1: {
                    return (float)this.offsetY + dist > 0.0f;
                }
            }
            return false;
        }
        return false;
    }

    boolean canScrollAndIsNotOriginalLocation() {
        return this.canScroll() && this.isNotOriginalLocation();
    }

    private static boolean checkFlag(int flag) {
        return flag == 0 || flag == 1;
    }

    void setPtrHandler(PtrHandler ptrHandler) {
        this.ptrHandler = ptrHandler;
    }

    void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }
}

