/*
 * Decompiled with CFR 0.152.
 */
package cn.richinfo.dualsim;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import cn.richinfo.dualsim.DualsimBase;
import cn.richinfo.dualsim.MTKDualSim;
import cn.richinfo.dualsim.NormalDualSim;
import cn.richinfo.dualsim.QualcommDualSim;
import cn.richinfo.dualsim.SamsungDualSim;

public class TelephonyManagement {
    private static final String TAG = "chip";
    private static TelephonyManagement mInstance;
    private static DualsimBase mDualsimChip;

    private TelephonyManagement() {
    }

    public static TelephonyManagement getInstance() {
        if (mInstance == null) {
            mInstance = new TelephonyManagement();
        }
        return mInstance;
    }

    public TelephonyInfo getTelephonyInfo(Context context) {
        DualsimBase dualsim = this.getDualSimChip(context);
        if (dualsim.getTelephonyInfo() == null) {
            dualsim.update(context);
        }
        return dualsim.getTelephonyInfo();
    }

    public TelephonyManagement updateTelephonyInfo(Context context) {
        this.getDualSimChip(context).update(context);
        return this;
    }

    public DualsimBase getDualSimChip(Context context) {
        if (mDualsimChip != null) {
            return mDualsimChip;
        }
        if (SamsungDualSim.getInstance(context).isSamsungDualSystem()) {
            if (SamsungDualSim.getInstance(context).getSimState(0) == 0 && SamsungDualSim.getInstance(context).getSimState(1) == 0) {
                Log.w((String)TAG, (String)">>>>>>>>>use normal chip<<<<<<<<<<<");
                mDualsimChip = NormalDualSim.getInstance(context);
                return mDualsimChip;
            }
            Log.w((String)TAG, (String)">>>>>>>>>use samsung chip<<<<<<<<<<<");
            mDualsimChip = SamsungDualSim.getInstance(context);
            return mDualsimChip;
        }
        if (MTKDualSim.getInstance(context).isMTKSystem()) {
            Log.w((String)TAG, (String)">>>>>>>>>use MTK chip<<<<<<<<<<<");
            mDualsimChip = MTKDualSim.getInstance(context);
            return mDualsimChip;
        }
        if (QualcommDualSim.getInstance(context).isQualcommSystem(context)) {
            Log.w((String)TAG, (String)">>>>>>>>>use qualcomm chip<<<<<<<<<<<");
            mDualsimChip = QualcommDualSim.getInstance(context);
            return mDualsimChip;
        }
        Log.w((String)TAG, (String)">>>>>>>>>use normal chip<<<<<<<<<<<");
        mDualsimChip = NormalDualSim.getInstance(context);
        return mDualsimChip;
    }

    public static class TelephonyInfo {
        String imeiSIM1 = "";
        String imeiSIM2 = "";
        String imsiSIM1 = "";
        String imsiSIM2 = "";
        int stateSIM1 = 1;
        int stateSIM2 = 1;
        int slotIdSIM1 = -1;
        int slotIdSIM2 = -1;
        int subIdSIM1 = -1;
        int subIdSIM2 = -1;
        String operatorSIM1 = "";
        String operatorSIM2 = "";
        String chip = "";
        int defaultDataSlotId = -1;

        public String getChip() {
            return this.chip;
        }

        void setChip(String chip) {
            this.chip = chip;
        }

        public String getImeiSIM1() {
            return this.imeiSIM1;
        }

        void setImeiSIM1(String imeiSIM1) {
            if (imeiSIM1 != null) {
                this.imeiSIM1 = imeiSIM1;
            }
        }

        public String getImeiSIM2() {
            return this.imeiSIM2;
        }

        void setImeiSIM2(String imeiSIM2) {
            if (imeiSIM2 != null) {
                this.imeiSIM2 = imeiSIM2;
            }
        }

        public String getImsiSIM1() {
            return this.imsiSIM1;
        }

        void setImsiSIM1(String imsiSIM1) {
            if (imsiSIM1 != null) {
                this.imsiSIM1 = imsiSIM1;
            }
        }

        public String getImsiSIM2() {
            return this.imsiSIM2;
        }

        void setImsiSIM2(String imsiSIM2) {
            if (imsiSIM2 != null) {
                this.imsiSIM2 = imsiSIM2;
            }
        }

        public String getOperatorSIM1() {
            return this.operatorSIM1;
        }

        void setOperatorSIM1(String operatorSIM1) {
            if (operatorSIM1 != null) {
                this.operatorSIM1 = operatorSIM1;
            }
        }

        public String getOperatorSIM2() {
            return this.operatorSIM2;
        }

        void setOperatorSIM2(String operatorSIM2) {
            this.operatorSIM2 = operatorSIM2;
        }

        public int getStateSIM1() {
            return this.stateSIM1;
        }

        void setStateSIM1(int state) {
            this.stateSIM1 = state;
        }

        public int getStateSIM2() {
            return this.stateSIM2;
        }

        void setStateSIM2(int state) {
            this.stateSIM2 = state;
        }

        public int getDefaultDataSlotId() {
            return this.defaultDataSlotId;
        }

        void setDefaultDataSlotId(int defaultDataSlotId) {
            this.defaultDataSlotId = defaultDataSlotId;
        }

        public int getSlotIdSIM1() {
            return this.slotIdSIM1;
        }

        void setSlotIdSIM1(int slotIdSIM1) {
            this.slotIdSIM1 = slotIdSIM1;
        }

        public int getSlotIdSIM2() {
            return this.slotIdSIM2;
        }

        void setSlotIdSIM2(int slotIdSIM2) {
            this.slotIdSIM2 = slotIdSIM2;
        }

        public int getSubIdSIM1() {
            return this.subIdSIM1;
        }

        void setSubIdSIM1(int subIdSIM1) {
            this.subIdSIM1 = subIdSIM1;
        }

        public int getSubIdSIM2() {
            return this.subIdSIM2;
        }

        void setSubIdSIM2(int subIdSIM2) {
            this.subIdSIM2 = subIdSIM2;
        }

        public boolean isDualSIM() {
            return this.stateSIM1 == 5 && this.stateSIM2 == 5;
        }

        public int getSIMCount() {
            if (this.stateSIM1 == 5 && this.stateSIM2 == 5) {
                return 2;
            }
            if (this.stateSIM1 == 5 || this.stateSIM2 == 5) {
                return 1;
            }
            return 0;
        }

        public String getSubscriberIdBySlotId(int slotId) {
            if (this.slotIdSIM1 == slotId) {
                return this.imsiSIM1;
            }
            if (this.slotIdSIM2 == slotId) {
                return this.imsiSIM2;
            }
            return "";
        }

        public String getDeviceIdBySlotId(int slotId) {
            if (this.slotIdSIM1 == slotId) {
                return this.imeiSIM1;
            }
            if (this.slotIdSIM2 == slotId) {
                return this.imeiSIM2;
            }
            return "";
        }

        public String getOperatorBySlotId(int slotId) {
            if (this.slotIdSIM1 == slotId) {
                return this.operatorSIM1;
            }
            if (this.slotIdSIM2 == slotId) {
                return this.operatorSIM2;
            }
            return "";
        }

        public int getSubId(int slotId) {
            if (this.slotIdSIM1 == slotId) {
                return this.subIdSIM1;
            }
            if (this.slotIdSIM2 == slotId) {
                return this.subIdSIM2;
            }
            return -1;
        }

        public int getSlotIdByImsi(String imsi) {
            if (TextUtils.isEmpty((CharSequence)imsi)) {
                return -1;
            }
            if (imsi.equals(this.imsiSIM1)) {
                return this.slotIdSIM1;
            }
            if (imsi.equals(this.imsiSIM2)) {
                return this.slotIdSIM2;
            }
            return -1;
        }

        public int getConfigDefaultSlotId() {
            return this.getSIMCount() == 1 ? this.getSlotIdSIM1() : (this.isDualSIM() ? this.getDefaultDataSlotId() : -1);
        }

        public String getConfigDefaultSubscriberId(Context context) {
            if (this.isDualSIM()) {
                return this.getSubscriberIdBySlotId(this.getConfigDefaultSlotId());
            }
            return this.getSubscriberIdBySlotId(this.getConfigDefaultSlotId());
        }

        public String getConfigDefaultDeviceId(Context context) {
            if (this.isDualSIM()) {
                return this.getDeviceIdBySlotId(this.getConfigDefaultSlotId());
            }
            return this.getDeviceIdBySlotId(this.getConfigDefaultSlotId());
        }

        public String getConfigDefaultOperator(Context context) {
            if (this.isDualSIM()) {
                return this.getOperatorBySlotId(this.getConfigDefaultSlotId());
            }
            return this.getOperatorBySlotId(this.getConfigDefaultSlotId());
        }

        public String getSimStateStr(int simState) {
            StringBuilder sb = new StringBuilder();
            switch (simState) {
                case 1: {
                    sb.append("\u6ca1\u63d2\u5361");
                    break;
                }
                case 2: {
                    sb.append("\u9501\u5b9a\u72b6\u6001\uff0c\u9700\u8981\u7528\u6237\u7684PIN\u7801\u89e3\u9501");
                    break;
                }
                case 3: {
                    sb.append("\u9501\u5b9a\u72b6\u6001\uff0c\u9700\u8981\u7528\u6237\u7684PUK\u7801\u89e3\u9501");
                    break;
                }
                case 4: {
                    sb.append("\u9501\u5b9a\u72b6\u6001\uff0c\u9700\u8981\u7f51\u7edc\u7684PIN\u7801\u89e3\u9501");
                    break;
                }
                case 5: {
                    sb.append("\u5c31\u7eea\u72b6\u6001");
                    break;
                }
                default: {
                    sb.append("\u672a\u77e5\u72b6\u6001");
                }
            }
            return sb.toString();
        }

        public String toString() {
            return "TelephonyInfo{imeiSIM1='" + this.imeiSIM1 + '\'' + ", imeiSIM2='" + this.imeiSIM2 + '\'' + ", imsiSIM1='" + this.imsiSIM1 + '\'' + ", imsiSIM2='" + this.imsiSIM2 + '\'' + ", stateSIM1=" + this.stateSIM1 + ", stateSIM2=" + this.stateSIM2 + ", slotIdSIM1=" + this.slotIdSIM1 + ", slotIdSIM2=" + this.slotIdSIM2 + ", subIdSIM1=" + this.subIdSIM1 + ", subIdSIM2=" + this.subIdSIM2 + ", operatorSIM1='" + this.operatorSIM1 + '\'' + ", operatorSIM2='" + this.operatorSIM2 + '\'' + ", chip='" + this.chip + '\'' + ", defaultDataSlotId=" + this.defaultDataSlotId + '}';
        }
    }
}

