/*
 * Decompiled with CFR 0.152.
 */
package cn.richinfo.dualsim;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.telephony.SmsManager;
import android.text.TextUtils;
import android.util.Log;
import cn.richinfo.dualsim.DualsimBase;
import cn.richinfo.dualsim.TelephonyManagement;

public class SamsungDualSim
extends DualsimBase {
    private static SamsungDualSim mInstance;
    public Class androidMSTMClass;
    public Class androidMSMClass;
    public Class samsungMSMClass;
    private Object mySamsungMSMObject;
    private Object mySMObject;
    private static final String CLASS_ANDROID_MULTISIMMANAGER = "com.android.internal.telephony.MultiSimManager";
    private static final String CLASS_SAMSUNG_MULTISIMMANAGER = "com.samsung.android.telephony.MultiSimManager";
    private static final String CLASS_ANDROID_MULTISIMTELEPHONYMANAGER = "android.telephony.MultiSimTelephonyManager";

    static SamsungDualSim getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new SamsungDualSim(context);
        }
        return mInstance;
    }

    private SamsungDualSim(Context context) {
        super(context);
    }

    @Override
    public DualsimBase update(Context context) {
        this.mTelephonyInfo = new TelephonyManagement.TelephonyInfo();
        this.mTelephonyInfo.setChip("Samsung");
        this.mTelephonyInfo.setStateSIM1(this.getSimState(0));
        this.mTelephonyInfo.setStateSIM2(this.getSimState(1));
        this.mTelephonyInfo.setDefaultDataSlotId(this.getDefaultDataSlotId(context));
        int stateSim1 = this.mTelephonyInfo.getStateSIM1();
        int stateSim2 = this.mTelephonyInfo.getStateSIM2();
        if (stateSim1 != 0 && stateSim1 != 1 && stateSim1 != 7 && stateSim1 != 8) {
            this.mTelephonyInfo.setSlotIdSIM1(0);
            this.mTelephonyInfo.setImsiSIM1(this.getImsi(0));
            this.mTelephonyInfo.setImeiSIM1(this.getImei(0));
            this.mTelephonyInfo.setOperatorSIM1(this.getOperator(0));
            this.mTelephonyInfo.setSubIdSIM1(this.getSubId(null, 0));
            if (stateSim2 != 0 && stateSim2 != 1 && stateSim2 != 7 && stateSim2 != 8) {
                this.mTelephonyInfo.setSlotIdSIM2(1);
                this.mTelephonyInfo.setImsiSIM2(this.getImsi(1));
                this.mTelephonyInfo.setImeiSIM2(this.getImei(1));
                this.mTelephonyInfo.setOperatorSIM2(this.getOperator(1));
                this.mTelephonyInfo.setSubIdSIM2(this.getSubId(null, 1));
            } else {
                this.mTelephonyInfo.setDefaultDataSlotId(0);
            }
        } else if (stateSim2 != 0 && stateSim2 != 1 && stateSim2 != 7 && stateSim2 != 8) {
            this.mTelephonyInfo.setStateSIM1(this.mTelephonyInfo.getStateSIM2());
            this.mTelephonyInfo.setSlotIdSIM1(1);
            this.mTelephonyInfo.setDefaultDataSlotId(1);
            this.mTelephonyInfo.setImsiSIM1(this.getImsi(1));
            this.mTelephonyInfo.setImeiSIM1(this.getImei(1));
            this.mTelephonyInfo.setOperatorSIM1(this.getOperator(1));
            this.mTelephonyInfo.setSubIdSIM1(this.getSubId(null, 1));
            this.mTelephonyInfo.setStateSIM2(1);
        }
        return this;
    }

    @Override
    public boolean sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, int simID) {
        if (this.mySMObject == null) {
            this.mySMObject = this.getSmsManagerDefault(simID);
        }
        if (this.mySMObject == null) {
            Log.e((String)"DualsimBase", (String)"the mySMObject is null, cannot sendDataMessage!");
            return false;
        }
        try {
            this.eval(this.mySMObject, "sendDataMessage", new Object[]{destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent}, new Class[]{String.class, String.class, Short.TYPE, byte[].class, PendingIntent.class, PendingIntent.class});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getImsi(int simID) {
        if (this.currentapiVersion < 21) {
            try {
                String result = (String)this.eval(this.getSimManagerDefault(simID), "getSubscriberId", null, null);
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getImsi(simID);
                }
                return result;
            }
            catch (Exception e) {
                return super.getImsi(simID);
            }
        }
        return super.getImsi(simID);
    }

    @Override
    public int getSimState(int simID) {
        if (this.currentapiVersion < 21) {
            try {
                return (Integer)this.eval(this.getSimManagerDefault(simID), "getSimState", null, null);
            }
            catch (Exception e) {
                return super.getSimState(simID);
            }
        }
        return super.getSimState(simID);
    }

    @Override
    public String getImei(int simID) {
        if (this.currentapiVersion < 21) {
            try {
                String result = (String)this.eval(this.getSimManagerDefault(simID), "getDeviceId", null, null);
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getImei(simID);
                }
                return result;
            }
            catch (Exception e) {
                return super.getImei(simID);
            }
        }
        return super.getImei(simID);
    }

    @Override
    public String getOperator(int simID) {
        if (this.currentapiVersion < 21) {
            try {
                String result = (String)this.eval(this.getSimManagerDefault(simID), "getSimOperator", null, null);
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getOperator(simID);
                }
                return result;
            }
            catch (Exception e) {
                return super.getOperator(simID);
            }
        }
        return super.getOperator(simID);
    }

    public boolean isSamsungDualSystem() {
        if ("samsung".equalsIgnoreCase(Build.MANUFACTURER)) {
            if (this.currentapiVersion < 21) {
                return this.checkByStrings();
            }
            return this.checkByfunction();
        }
        return false;
    }

    private boolean checkByStrings() {
        try {
            if (this.androidMSMClass == null) {
                this.androidMSMClass = Class.forName(CLASS_ANDROID_MULTISIMMANAGER);
            }
            return (Integer)this.eval(this.androidMSMClass, this.androidMSMClass.newInstance(), "getSimSlotCount", null, null) >= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean checkByfunction() {
        try {
            if (this.samsungMSMClass == null) {
                this.samsungMSMClass = Class.forName(CLASS_SAMSUNG_MULTISIMMANAGER);
            }
            return (Integer)this.eval(this.samsungMSMClass, this.samsungMSMClass.newInstance(), "getSimSlotCount", null, null) >= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Object getSimManagerDefault(int simID) {
        try {
            if (this.currentapiVersion < 21) {
                if (this.androidMSTMClass == null) {
                    this.androidMSTMClass = Class.forName(CLASS_ANDROID_MULTISIMTELEPHONYMANAGER);
                }
                return this.eval(this.androidMSTMClass, null, "getDefault", new Object[]{this.getLogicalSimSlot(simID)}, new Class[]{Integer.TYPE});
            }
            if (this.mySamsungMSMObject == null) {
                this.mySamsungMSMObject = Class.forName(CLASS_SAMSUNG_MULTISIMMANAGER).newInstance();
                return this.mySamsungMSMObject;
            }
            return this.mySamsungMSMObject;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Object getSmsManagerDefault(int simID) {
        try {
            if (this.currentapiVersion < 21) {
                return this.eval(Class.forName("android.telephony.MultiSimSmsManager"), null, "getDefault", new Object[]{this.getLogicalSimSlot(simID)}, new Class[]{Integer.TYPE});
            }
            if (this.currentapiVersion == 21) {
                return this.eval(Class.forName("android.telephony.SmsManager"), SmsManager.getDefault(), "getSmsManagerForSubscriber", new Object[]{(long)this.getSubId(null, simID)}, new Class[]{Long.TYPE});
            }
            return this.eval(Class.forName("android.telephony.SmsManager"), SmsManager.getDefault(), "getSmsManagerForSubscriptionId", new Object[]{this.getSubId(null, simID)}, new Class[]{Integer.TYPE});
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getLogicalSimSlot(int simID) {
        try {
            if (this.androidMSMClass == null) {
                this.androidMSMClass = Class.forName(CLASS_ANDROID_MULTISIMMANAGER);
            }
            return (Integer)this.eval(this.androidMSMClass, this.androidMSMClass.newInstance(), "getLogicalSimSlot", new Object[]{simID}, new Class[]{Integer.TYPE});
        }
        catch (Exception exception) {
            return -1;
        }
    }
}

