/*
 * Decompiled with CFR 0.152.
 */
package cn.richinfo.dualsim;

import android.app.PendingIntent;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import cn.richinfo.dualsim.DualsimBase;
import cn.richinfo.dualsim.TelephonyManagement;
import java.lang.reflect.Method;
import java.util.Locale;

public class QualcommDualSim
extends DualsimBase {
    private static QualcommDualSim mInstance;
    private Object myQualcommTMInstance = this.getDefault();
    private static final String QUALCOMM_CMDC_PLATFORM = "persist.loc.nlp_name";
    private static final String QUALCOMM_CMDC_PLATFORM_KEY = "com.qualcomm.location";
    private static final String QUALCOMM_XIAOMI_PLATFORM = "ro.boot.hardware";
    private static final String QUALCOMM_XIAOMI_PLATFORM_KEY = "qcom";
    private static final String QUALCOMM_NUBIA_PLATFORM_KEY = "ro.product.board";
    private static final String QUALCOMM_NUBIA_PLATFORM_VALUE = "msm";
    private static final String QUALCOMM_BOARD_PLATFORM = "ro.board.platform";
    private static final String QUALCOMM_BOARD_PLATFORM_KEY = "hi3630";
    private static final String QUALCOMM_VIVO_PLATFORM = "persist.radio.multisim.config";
    private static final String QUALCOMM_VIVO_X5_PLATFORM = "ro.vivo.product.solution";
    private static final String QUALCOMM_VIVO_X5_PLATFORM_KEY = "QCOM";

    static QualcommDualSim getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new QualcommDualSim(context);
        }
        return mInstance;
    }

    private QualcommDualSim(Context context) {
        super(context);
    }

    @Override
    public DualsimBase update(Context context) {
        this.mTelephonyInfo = new TelephonyManagement.TelephonyInfo();
        this.mTelephonyInfo.setChip("Qualcomm");
        this.mTelephonyInfo.setStateSIM1(this.getSimState(0));
        this.mTelephonyInfo.setStateSIM2(this.getSimState(1));
        this.mTelephonyInfo.setDefaultDataSlotId(this.getDefaultDataSlotId(context));
        int stateSim1 = this.mTelephonyInfo.getStateSIM1();
        int stateSim2 = this.mTelephonyInfo.getStateSIM2();
        if (stateSim1 != 0 && stateSim1 != 1 && stateSim1 != 7 && stateSim1 != 8) {
            this.mTelephonyInfo.setSlotIdSIM1(0);
            this.mTelephonyInfo.setImsiSIM1(this.getImsi(0));
            this.mTelephonyInfo.setImeiSIM1(this.getImei(0));
            this.mTelephonyInfo.setOperatorSIM1(this.getOperator(0));
            this.mTelephonyInfo.setSubIdSIM1(this.getSubId(null, 0));
            if (stateSim2 != 0 && stateSim2 != 1 && stateSim2 != 7 && stateSim2 != 8) {
                this.mTelephonyInfo.setSlotIdSIM2(1);
                this.mTelephonyInfo.setImsiSIM2(this.getImsi(1));
                this.mTelephonyInfo.setImeiSIM2(this.getImei(1));
                this.mTelephonyInfo.setOperatorSIM2(this.getOperator(1));
                this.mTelephonyInfo.setSubIdSIM2(this.getSubId(null, 1));
            } else {
                this.mTelephonyInfo.setDefaultDataSlotId(0);
            }
        } else if (stateSim2 != 0 && stateSim2 != 1 && stateSim2 != 7 && stateSim2 != 8) {
            this.mTelephonyInfo.setStateSIM1(this.mTelephonyInfo.getStateSIM2());
            this.mTelephonyInfo.setSlotIdSIM1(1);
            this.mTelephonyInfo.setDefaultDataSlotId(1);
            this.mTelephonyInfo.setImsiSIM1(this.getImsi(1));
            this.mTelephonyInfo.setImeiSIM1(this.getImei(1));
            this.mTelephonyInfo.setOperatorSIM1(this.getOperator(1));
            this.mTelephonyInfo.setSubIdSIM1(this.getSubId(null, 1));
            this.mTelephonyInfo.setStateSIM2(1);
        }
        return this;
    }

    @Override
    public boolean sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, int simID) {
        if (this.currentapiVersion >= 21) {
            return super.sendDataMessage(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID);
        }
        try {
            Method smObject = Class.forName("android.telephony.MSimSmsManager").getDeclaredMethod("getDefault", new Class[0]);
            this.eval(smObject, "sendDataMessage", new Object[]{destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID}, new Class[]{String.class, String.class, Short.TYPE, byte[].class, PendingIntent.class, PendingIntent.class, Integer.TYPE});
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public String getImei(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getImei(simID);
        }
        if (this.myQualcommTMInstance != null) {
            try {
                String result = (String)this.eval(this.myQualcommTMInstance, "getDeviceId", new Object[]{simID}, new Class[]{Integer.TYPE});
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getImei(simID);
                }
                return result;
            }
            catch (DualsimBase.DualSimMatchException e) {
                return super.getImei(simID);
            }
        }
        return super.getImei(simID);
    }

    @Override
    public String getImsi(int simID) {
        try {
            if (this.currentapiVersion >= 21) {
                return super.getImsi(simID);
            }
            if (this.myQualcommTMInstance != null) {
                String result = (String)this.eval(this.myQualcommTMInstance, "getSubscriberId", new Object[]{simID}, new Class[]{Integer.TYPE});
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getImsi(simID);
                }
                return result;
            }
            return super.getImsi(simID);
        }
        catch (Exception e) {
            Log.d((String)"mydebug", (String)("getImsi-error:" + e.getMessage()));
            return null;
        }
    }

    @Override
    public int getSimState(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getSimState(simID);
        }
        if (this.myQualcommTMInstance != null) {
            try {
                return (Integer)this.eval(this.myQualcommTMInstance, "getSimState", new Object[]{simID}, new Class[]{Integer.TYPE});
            }
            catch (Exception e) {
                return super.getSimState(simID);
            }
        }
        return super.getSimState(simID);
    }

    @Override
    public String getOperator(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getOperator(simID);
        }
        if (this.myQualcommTMInstance != null) {
            try {
                String result = (String)this.eval(this.myQualcommTMInstance, "getSimOperator", new Object[]{simID}, new Class[]{Integer.TYPE});
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getOperator(simID);
                }
                return result;
            }
            catch (DualsimBase.DualSimMatchException e) {
                return super.getOperator(simID);
            }
        }
        return super.getOperator(simID);
    }

    public boolean isQualcommSystem(Context myContext) {
        if (this.isHuaWeiDualSimQualcommSystem(myContext)) {
            Log.d((String)"mydebug", (String)"HUAWEI-System");
            return true;
        }
        if (this.isMiDualSimQualcommSystem()) {
            Log.d((String)"mydebug", (String)"XIAOMI-System");
            return true;
        }
        if (this.isVivoQualcommSystem()) {
            Log.d((String)"mydebug", (String)"Vivo-System");
            return true;
        }
        if (this.isVivoX5DualSimQualcommSystem()) {
            Log.d((String)"mydebug", (String)"VivoX5-System");
            return true;
        }
        if (this.isCMDualSimQualcommSystem(myContext)) {
            Log.d((String)"mydebug", (String)"\n\u4e3b\u677f\u578b\u53f7\uff1aCM-System");
            return true;
        }
        if (this.isNubiaDualSimQualcommSystem(myContext)) {
            Log.d((String)"mydebug", (String)"\n\u4e3b\u677f\u578b\u53f7\uff1aNUBIA-System");
            return true;
        }
        return false;
    }

    private boolean isCMDualSimQualcommSystem(Context myContext) {
        if (!"CMDC".equals(Build.MANUFACTURER)) {
            Log.d((String)"mydebug", (String)"!cmdc");
            return false;
        }
        if (this.currentapiVersion >= 21) {
            try {
                boolean reflectionIsMultiSimEnable = (Boolean)this.eval(this.mTelephonyManager, "isMultiSimEnabled", null, null);
                return reflectionIsMultiSimEnable;
            }
            catch (DualsimBase.DualSimMatchException reflectionIsMultiSimEnable) {}
        } else {
            try {
                String execResult = this.getProperty(QUALCOMM_CMDC_PLATFORM);
                if (!TextUtils.isEmpty((CharSequence)execResult) && execResult.equals(QUALCOMM_CMDC_PLATFORM_KEY)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isNubiaDualSimQualcommSystem(Context myContext) {
        if (!"nubia".equals(Build.MANUFACTURER.toLowerCase(Locale.ENGLISH))) {
            Log.d((String)"mydebug", (String)"!nubia");
            return false;
        }
        if (this.currentapiVersion >= 21) {
            try {
                boolean reflectionIsMultiSimEnable = (Boolean)this.eval(this.mTelephonyManager, "isMultiSimEnabled", null, null);
                return reflectionIsMultiSimEnable;
            }
            catch (Exception reflectionIsMultiSimEnable) {}
        } else {
            try {
                String execResult = this.getProperty(QUALCOMM_NUBIA_PLATFORM_KEY);
                Log.d((String)"mydebug", (String)("nubia execResult:" + execResult));
                if (!TextUtils.isEmpty((CharSequence)execResult)) {
                    int index = 0;
                    index = execResult.toLowerCase().indexOf(QUALCOMM_NUBIA_PLATFORM_VALUE);
                    if (index >= 0) {
                        Log.d((String)"mydebug", (String)("nubia index:" + index));
                        return true;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isMiDualSimQualcommSystem() {
        if (!"xiaomi".equals(Build.MANUFACTURER.toLowerCase(Locale.ENGLISH))) {
            Log.d((String)"mydebug", (String)"!xiaomi");
            return false;
        }
        try {
            String execResult = this.getProperty(QUALCOMM_XIAOMI_PLATFORM);
            if (!TextUtils.isEmpty((CharSequence)execResult) && execResult.equals(QUALCOMM_XIAOMI_PLATFORM_KEY)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isHuaWeiDualSimQualcommSystem(Context myContext) {
        if (!"huawei".equals(Build.MANUFACTURER.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        if (this.currentapiVersion >= 21) {
            try {
                boolean reflectionIsMultiSimEnable = (Boolean)this.eval(this.mTelephonyManager, "isMultiSimEnabled", null, null);
                return reflectionIsMultiSimEnable;
            }
            catch (Exception reflectionIsMultiSimEnable) {}
        } else {
            try {
                String execResult = this.getProperty(QUALCOMM_BOARD_PLATFORM);
                Log.d((String)"mydebug", (String)("huawei-execResult:" + execResult));
                if (!TextUtils.isEmpty((CharSequence)execResult) && execResult.equals(QUALCOMM_BOARD_PLATFORM_KEY)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean isVivoQualcommSystem() {
        if (!"BBK".equals(Build.MANUFACTURER)) {
            return false;
        }
        try {
            String execResult = this.getProperty(QUALCOMM_VIVO_PLATFORM);
            if (!TextUtils.isEmpty((CharSequence)execResult) && ("dsds".equals(execResult) || "dsds".equals(execResult) || "tsts".equals(execResult))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean isVivoX5DualSimQualcommSystem() {
        if (!"vivo".equals(Build.MANUFACTURER.toLowerCase(Locale.ENGLISH))) {
            return false;
        }
        try {
            String execResult = this.getProperty(QUALCOMM_VIVO_X5_PLATFORM);
            if (!TextUtils.isEmpty((CharSequence)execResult) && QUALCOMM_VIVO_X5_PLATFORM_KEY.equals(execResult)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected Object getDefault() {
        try {
            return this.eval(Class.forName("android.telephony.MSimTelephonyManager"), null, "getDefault", null, null);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

