/*
 * Decompiled with CFR 0.152.
 */
package cn.richinfo.dualsim;

import android.app.PendingIntent;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import cn.richinfo.dualsim.DualsimBase;
import cn.richinfo.dualsim.TelephonyManagement;

public class MTKDualSim
extends DualsimBase {
    private static MTKDualSim mInstance;
    private Object myMTKTMInstance = this.getMTKTMDefault();
    private Object mySmsManagerExInstance;
    private Class myGeminiSmsManagerClass;
    private static final String MTK_PLATFORM_KEY = "ro.mediatek.platform";
    private static final String MTK_GIONEE_PLATFORM_KEY = "ro.gn.platform.support";

    static MTKDualSim getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new MTKDualSim(context);
        }
        return mInstance;
    }

    private MTKDualSim(Context context) {
        super(context);
        this.initSM();
    }

    @Override
    public DualsimBase update(Context context) {
        this.mTelephonyInfo = new TelephonyManagement.TelephonyInfo();
        this.mTelephonyInfo.setChip("MTK");
        this.mTelephonyInfo.setStateSIM1(this.getSimState(0));
        this.mTelephonyInfo.setStateSIM2(this.getSimState(1));
        this.mTelephonyInfo.setDefaultDataSlotId(this.getDefaultDataSlotId(context));
        int stateSim1 = this.mTelephonyInfo.getStateSIM1();
        int stateSim2 = this.mTelephonyInfo.getStateSIM2();
        if (stateSim1 != 0 && stateSim1 != 1 && stateSim1 != 7 && stateSim1 != 8) {
            this.mTelephonyInfo.setSlotIdSIM1(0);
            this.mTelephonyInfo.setImsiSIM1(this.getImsi(0));
            this.mTelephonyInfo.setImeiSIM1(this.getImei(0));
            this.mTelephonyInfo.setOperatorSIM1(this.getOperator(0));
            this.mTelephonyInfo.setSubIdSIM1(this.getSubId(null, 0));
            if (stateSim2 != 0 && stateSim2 != 1 && stateSim2 != 7 && stateSim2 != 8) {
                this.mTelephonyInfo.setSlotIdSIM2(1);
                this.mTelephonyInfo.setImsiSIM2(this.getImsi(1));
                this.mTelephonyInfo.setImeiSIM2(this.getImei(1));
                this.mTelephonyInfo.setOperatorSIM2(this.getOperator(1));
                this.mTelephonyInfo.setSubIdSIM2(this.getSubId(null, 1));
            } else {
                this.mTelephonyInfo.setDefaultDataSlotId(0);
            }
        } else if (stateSim2 != 0 && stateSim2 != 1 && stateSim2 != 7 && stateSim2 != 8) {
            this.mTelephonyInfo.setStateSIM1(this.mTelephonyInfo.getStateSIM2());
            this.mTelephonyInfo.setSlotIdSIM1(1);
            this.mTelephonyInfo.setDefaultDataSlotId(1);
            this.mTelephonyInfo.setImsiSIM1(this.getImsi(1));
            this.mTelephonyInfo.setImeiSIM1(this.getImei(1));
            this.mTelephonyInfo.setOperatorSIM1(this.getOperator(1));
            this.mTelephonyInfo.setSubIdSIM1(this.getSubId(null, 1));
            this.mTelephonyInfo.setStateSIM2(1);
        }
        return this;
    }

    @Override
    public boolean sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, int simID) {
        try {
            if (this.mySmsManagerExInstance != null) {
                this.eval(this.mySmsManagerExInstance, "sendDataMessage", new Object[]{destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID}, new Class[]{String.class, String.class, Short.TYPE, byte[].class, PendingIntent.class, PendingIntent.class, Integer.TYPE});
                return true;
            }
            if (this.myGeminiSmsManagerClass != null) {
                this.eval(this.myGeminiSmsManagerClass, null, "sendDataMessageGemini", new Object[]{destinationAddress, scAddress, destinationPort, data, simID, sentIntent, deliveryIntent}, new Class[]{String.class, String.class, Short.TYPE, byte[].class, Integer.TYPE, PendingIntent.class, PendingIntent.class});
                return true;
            }
            return super.sendDataMessage(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID);
        }
        catch (Exception e) {
            return super.sendDataMessage(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID);
        }
    }

    @Override
    public int getSimState(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getSimState(simID);
        }
        if (this.myMTKTMInstance != null) {
            try {
                return (Integer)this.eval(this.myMTKTMInstance, "getSimState", new Object[]{simID}, new Class[]{Integer.TYPE});
            }
            catch (Exception e) {
                return super.getSimState(simID);
            }
        }
        return super.getSimState(simID);
    }

    @Override
    public String getImsi(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getImsi(simID);
        }
        if (this.myMTKTMInstance != null) {
            try {
                String result = (String)this.eval(this.myMTKTMInstance, "getSubscriberId", new Object[]{simID}, new Class[]{Integer.TYPE});
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getImsi(simID);
                }
                return result;
            }
            catch (Exception e) {
                return super.getImsi(simID);
            }
        }
        return super.getImsi(simID);
    }

    @Override
    public String getImei(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getImei(simID);
        }
        if (this.myMTKTMInstance != null) {
            try {
                String result = (String)this.eval(this.myMTKTMInstance, "getDeviceId", new Object[]{simID}, new Class[]{Integer.TYPE});
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getImei(simID);
                }
                return result;
            }
            catch (DualsimBase.DualSimMatchException e) {
                return super.getImei(simID);
            }
        }
        return super.getImei(simID);
    }

    @Override
    public String getOperator(int simID) {
        if (this.currentapiVersion >= 21) {
            return super.getOperator(simID);
        }
        if (this.myMTKTMInstance != null) {
            try {
                String result = (String)this.eval(this.myMTKTMInstance, "getSimOperator", new Object[]{simID}, new Class[]{Integer.TYPE});
                if (TextUtils.isEmpty((CharSequence)result)) {
                    return super.getOperator(simID);
                }
                return result;
            }
            catch (DualsimBase.DualSimMatchException e) {
                return super.getOperator(simID);
            }
        }
        return super.getOperator(simID);
    }

    private void initSM() {
        try {
            if (this.myGeminiSmsManagerClass == null) {
                this.myGeminiSmsManagerClass = Class.forName("android.telephony.gemini.GeminiSmsManager");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.mySmsManagerExInstance == null) {
                this.mySmsManagerExInstance = this.eval(Class.forName("com.mediatek.telephony.SmsManagerEx"), null, "getDefault", null, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isMTKSystem() {
        boolean isMTKSystem = false;
        try {
            Log.d((String)"mydebug", (String)"check MTKSystem");
            String normalMTKPlatform = this.getProperty(MTK_PLATFORM_KEY);
            if (!TextUtils.isEmpty((CharSequence)normalMTKPlatform) && (normalMTKPlatform.startsWith("MT") || normalMTKPlatform.startsWith("mt"))) {
                isMTKSystem = true;
            }
            if (!isMTKSystem) {
                Log.d((String)"mydebug", (String)"check MTKSystem");
                String gioneeMTKPlatform = this.getProperty(MTK_GIONEE_PLATFORM_KEY);
                if (!TextUtils.isEmpty((CharSequence)gioneeMTKPlatform) && (gioneeMTKPlatform.startsWith("MT") || gioneeMTKPlatform.startsWith("mt"))) {
                    isMTKSystem = true;
                }
            }
            Log.d((String)"mydebug", (String)"check MTKSystem");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isMTKSystem;
    }

    private boolean isMTKDoubleSim() {
        boolean isDoubleSim = false;
        try {
            isDoubleSim = (Boolean)this.eval(this.mTelephonyManager, "mtkGeminiSupport", null, null);
            if (!isDoubleSim) {
                isDoubleSim = (Boolean)this.eval(this.mTelephonyManager, "isMultiSimEnabled", null, null);
            }
        }
        catch (Exception e) {
            Log.d((String)"mydebug", (String)("isMTKDoubleSim-error:" + e.getMessage()));
        }
        return isDoubleSim;
    }

    protected Object getMTKTMDefault() {
        Object mtkTMInstance = null;
        try {
            mtkTMInstance = this.eval(Class.forName("com.mediatek.telephony.TelephonyManagerEx"), null, "getDefault", null, null);
        }
        catch (Exception e) {
            Log.d((String)"mydebug", (String)("isMTKDoubleSim-error:" + e.getMessage()));
        }
        return mtkTMInstance;
    }
}

