/*
 * Decompiled with CFR 0.152.
 */
package cn.richinfo.dualsim;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.telephony.SmsManager;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import cn.richinfo.dualsim.TelephonyManagement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

public abstract class DualsimBase {
    protected static final String TAG = "DualsimBase";
    public static final int TYPE_SIM_MAIN = 0;
    public static final int TYPE_SIM_ASSISTANT = 1;
    public static final int TYPE_SIM_EMPTY = -1;
    protected int currentapiVersion = Build.VERSION.SDK_INT;
    protected TelephonyManager mTelephonyManager;
    protected TelephonyManagement.TelephonyInfo mTelephonyInfo;

    protected DualsimBase(Context context) {
        this.mTelephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
    }

    public TelephonyManagement.TelephonyInfo getTelephonyInfo() {
        return this.mTelephonyInfo;
    }

    public abstract DualsimBase update(Context var1);

    public void forceNet(Context context, String host, final ForceNetCallback callback) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 21) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder();
            builder.addCapability(12);
            builder.addTransportType(0);
            NetworkRequest networkRequest = builder.build();
            ConnectivityManager.NetworkCallback myNetCallback = new ConnectivityManager.NetworkCallback(){

                @RequiresApi(api=21)
                public void onAvailable(Network network) {
                    if (callback != null) {
                        callback.call(network);
                    }
                }
            };
            connectivityManager.requestNetwork(networkRequest, myNetCallback);
        } else {
            connectivityManager.startUsingNetworkFeature(0, "enableHIPRI");
            try {
                NetworkInfo.State checkState;
                for (int counter = 0; counter < 30 && 0 != (checkState = connectivityManager.getNetworkInfo(5).getState()).compareTo((Enum)NetworkInfo.State.CONNECTED); ++counter) {
                    Thread.sleep(500L);
                }
            }
            catch (InterruptedException counter) {
                // empty catch block
            }
            int hostAddress = this.lookupHost(this.extractAddressFromUrl(host));
            boolean resultBool1 = connectivityManager.requestRouteToHost(5, hostAddress);
            if (resultBool1) {
                if (callback != null) {
                    callback.call(null);
                }
            } else {
                Log.e((String)TAG, (String)"change network failed or mobile network is null");
            }
        }
    }

    protected int lookupHost(String hostname) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            return -1;
        }
        byte[] addrBytes = inetAddress.getAddress();
        int addr = (addrBytes[3] & 0xFF) << 24 | (addrBytes[2] & 0xFF) << 16 | (addrBytes[1] & 0xFF) << 8 | addrBytes[0] & 0xFF;
        return addr;
    }

    private String extractAddressFromUrl(String url) {
        String urlToProcess = null;
        int protocolEndIndex = url.indexOf("://");
        urlToProcess = protocolEndIndex > 0 ? url.substring(protocolEndIndex + 3) : url;
        int pos = urlToProcess.indexOf(58);
        if (pos >= 0) {
            urlToProcess = urlToProcess.substring(0, pos);
        }
        if ((pos = urlToProcess.indexOf(47)) >= 0) {
            urlToProcess = urlToProcess.substring(0, pos);
        }
        if ((pos = urlToProcess.indexOf(63)) >= 0) {
            urlToProcess = urlToProcess.substring(0, pos);
        }
        return urlToProcess;
    }

    public boolean sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, int simID) {
        if (this.currentapiVersion >= 21) {
            try {
                Object smsManager = this.currentapiVersion == 21 ? this.eval(SmsManager.getDefault(), "getSmsManagerForSubscriber", new Object[]{(long)this.getSubId(null, simID)}, new Class[]{Long.TYPE}) : this.eval(SmsManager.getDefault(), "getSmsManagerForSubscriptionId", new Object[]{this.getSubId(null, simID)}, new Class[]{Integer.TYPE});
                if (smsManager == null) {
                    smsManager = SmsManager.getDefault();
                }
                this.eval(smsManager, "sendDataMessage", new Object[]{destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent}, new Class[]{String.class, String.class, Short.TYPE, byte[].class, PendingIntent.class, PendingIntent.class});
                return true;
            }
            catch (DualSimMatchException e) {
                return this.sendDataMessageDefault(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID);
            }
        }
        return this.sendDataMessageDefault(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent, simID);
    }

    protected boolean sendDataMessageDefault(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent, int simID) {
        SmsManager manager = SmsManager.getDefault();
        try {
            Class<?> smsClass = manager.getClass();
            Field field = smsClass.getDeclaredField("mSubId");
            field.setAccessible(true);
            field.set(manager, this.getSubId(null, simID));
        }
        catch (Exception exception) {
            // empty catch block
        }
        manager.sendDataMessage(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent);
        return true;
    }

    @SuppressLint(value={"MissingPermission"})
    public String getImsi(int simID) {
        try {
            if (this.currentapiVersion == 21) {
                return this.getReflexData(this.mTelephonyManager, "getSubscriberId", (long)this.getSubId(null, simID));
            }
            return this.getReflexData(this.mTelephonyManager, "getSubscriberId", this.getSubId(null, simID));
        }
        catch (DualSimMatchException e) {
            try {
                return this.getReflexData(this.mTelephonyManager, "getSubscriberIdGemini", simID);
            }
            catch (DualSimMatchException e1) {
                if (simID == 0) {
                    return this.mTelephonyManager.getSubscriberId();
                }
                return "";
            }
        }
    }

    public int getSimState(int simID) {
        try {
            return this.getReflexState(this.mTelephonyManager, "getSimState", simID);
        }
        catch (DualSimMatchException e) {
            try {
                return this.getReflexState(this.mTelephonyManager, "getSimStateGemini", simID);
            }
            catch (DualSimMatchException e1) {
                if (simID == 0) {
                    return this.mTelephonyManager.getSimState();
                }
                return 0;
            }
        }
    }

    @SuppressLint(value={"NewApi", "MissingPermission"})
    public String getImei(int simID) {
        try {
            if (this.currentapiVersion >= 21) {
                return this.getReflexData(this.mTelephonyManager, "getImei", simID);
            }
            return this.getReflexData(this.mTelephonyManager, "getDeviceId", simID);
        }
        catch (DualSimMatchException e) {
            try {
                return this.getReflexData(this.mTelephonyManager, "getDeviceIdGemini", simID);
            }
            catch (DualSimMatchException ex) {
                if (simID == 0) {
                    return this.mTelephonyManager.getDeviceId();
                }
                return "";
            }
        }
    }

    public String getOperator(int simID) {
        try {
            int subId = this.getSubId(null, simID);
            if (this.currentapiVersion == 21) {
                return this.getReflexData(this.mTelephonyManager, "getSimOperator", (long)(subId == -1 ? simID : subId));
            }
            return this.getReflexData(this.mTelephonyManager, "getSimOperator", subId == -1 ? simID : subId);
        }
        catch (DualSimMatchException e) {
            try {
                return this.getReflexData(this.mTelephonyManager, "getSimOperatorGemini", simID);
            }
            catch (DualSimMatchException ex) {
                if (simID == 0) {
                    return this.mTelephonyManager.getSimOperator();
                }
                return "";
            }
        }
    }

    @SuppressLint(value={"NewApi"})
    public int getSubId(Context context, int simID) {
        if (this.currentapiVersion >= 22 && context != null) {
            List<SubscriptionInfo> subscriptionInfos = this.getSubscriptionInfos(context);
            SubscriptionInfo subInfo = this.findSubInfo(subscriptionInfos, simID);
            return subInfo.getSubscriptionId();
        }
        Object obj = this.getSubScriptionId(simID);
        if (obj != null) {
            if (Build.VERSION.SDK_INT == 21) {
                return (int)((long[])obj)[0];
            }
            return ((int[])obj)[0];
        }
        return simID;
    }

    @SuppressLint(value={"NewApi"})
    public int getDefaultDataSlotId(Context context) {
        if (this.currentapiVersion >= 22 && context != null) {
            SubscriptionManager subscriptionManager = SubscriptionManager.from((Context)context.getApplicationContext());
            if (subscriptionManager != null) {
                try {
                    SubscriptionInfo subInfo = this.getReflexSubscriptionInfo(subscriptionManager, "getDefaultDataSubscriptionInfo", null);
                    if (subInfo != null) {
                        return subInfo.getSimSlotIndex();
                    }
                }
                catch (DualSimMatchException e) {
                    return -1;
                }
            }
        } else {
            try {
                int slotId;
                Method getSubId;
                Class<?> cls = Class.forName("android.telephony.SubscriptionManager");
                try {
                    getSubId = cls.getDeclaredMethod("getDefaultDataSubId", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    getSubId = cls.getDeclaredMethod("getDefaultDataSubscriptionId", new Class[0]);
                }
                int subId = (Integer)getSubId.invoke(null, new Object[0]);
                if (this.currentapiVersion == 21) {
                    Method getSlotId = cls.getDeclaredMethod("getSlotId", Long.TYPE);
                    slotId = (Integer)getSlotId.invoke(null, subId);
                } else {
                    Method getSlotId = cls.getDeclaredMethod("getSlotId", Integer.TYPE);
                    slotId = (Integer)getSlotId.invoke(null, subId);
                }
                return slotId;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    protected SubscriptionInfo getReflexSubscriptionInfo(Object real, String predictedMethodName, Object[] params) throws DualSimMatchException {
        return (SubscriptionInfo)this.eval(real, predictedMethodName, params, null);
    }

    protected Object eval(Object evalObj, String predictedMethodName, Object[] params, Class[] paramsCls) throws DualSimMatchException {
        try {
            Class<?> telephonyClass = Class.forName(evalObj.getClass().getName());
            if (params != null && paramsCls != null) {
                Method getSimID = telephonyClass.getMethod(predictedMethodName, paramsCls);
                return getSimID.invoke(evalObj, params);
            }
            Method getSimID = telephonyClass.getMethod(predictedMethodName, new Class[0]);
            return getSimID.invoke(evalObj, new Object[0]);
        }
        catch (Exception e) {
            throw new DualSimMatchException(predictedMethodName);
        }
    }

    protected Object eval(Class evalCls, Object evalObj, String predictedMethodName, Object[] params, Class[] paramsCls) throws DualSimMatchException {
        if (evalCls == null) {
            return null;
        }
        try {
            if (params != null && paramsCls != null) {
                Method getSimID = evalCls.getMethod(predictedMethodName, paramsCls);
                return getSimID.invoke(evalObj, params);
            }
            Method getSimID = evalCls.getMethod(predictedMethodName, new Class[0]);
            return getSimID.invoke(evalObj, new Object[0]);
        }
        catch (Exception e) {
            throw new DualSimMatchException(predictedMethodName);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected SubscriptionInfo findSubInfo(List<SubscriptionInfo> subscriptionInfos, int slotId) {
        SubscriptionInfo subInfo = subscriptionInfos.get(0);
        for (SubscriptionInfo sf : subscriptionInfos) {
            if (sf.getSimSlotIndex() != slotId) continue;
            subInfo = sf;
            break;
        }
        return subInfo;
    }

    @SuppressLint(value={"NewApi"})
    protected List<SubscriptionInfo> getSubscriptionInfos(Context context) {
        SubscriptionManager subscriptionManager = SubscriptionManager.from((Context)context.getApplicationContext());
        List subscriptionInfos = null;
        if (subscriptionManager != null) {
            subscriptionInfos = subscriptionManager.getActiveSubscriptionInfoList();
        }
        return subscriptionInfos;
    }

    protected String getReflexData(TelephonyManager telephony, String predictedMethodName, int id) throws DualSimMatchException {
        String data = "";
        Object ob_phone = this.eval(telephony, predictedMethodName, new Object[]{id}, new Class[]{Integer.TYPE});
        if (ob_phone != null) {
            data = ob_phone.toString();
        }
        return data;
    }

    protected String getReflexData(TelephonyManager telephony, String predictedMethodName, long id) throws DualSimMatchException {
        String data = "";
        Object ob_phone = this.eval(telephony, predictedMethodName, new Object[]{id}, new Class[]{Long.TYPE});
        if (ob_phone != null) {
            data = ob_phone.toString();
        }
        return data;
    }

    protected int getReflexState(TelephonyManager telephony, String predictedMethodName, int slotID) throws DualSimMatchException {
        Object ob_phone = this.eval(telephony, predictedMethodName, new Object[]{slotID}, new Class[]{Integer.TYPE});
        if (ob_phone != null) {
            return Integer.parseInt(ob_phone.toString());
        }
        return 0;
    }

    protected Object getSubScriptionId(int simID) {
        try {
            return Class.forName("android.telephony.SubscriptionManager").getDeclaredMethod("getSubId", Integer.TYPE).invoke(null, simID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getProperty(String propertyKey) throws IOException, InterruptedException {
        String execResult = this.execCommandGetLine("getprop " + propertyKey);
        return execResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execCommandGetLine(String command) throws IOException, InterruptedException {
        String resultStr = null;
        Runtime runtime = Runtime.getRuntime();
        Process proc = runtime.exec(command);
        int exit = proc.waitFor();
        if (exit == 0) {
            InputStream inputStream = proc.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            try {
                resultStr = br.readLine();
            }
            finally {
                inputStream.close();
            }
        }
        return resultStr;
    }

    public String toString() {
        return this.mTelephonyInfo.toString();
    }

    public static interface ForceNetCallback {
        public void call(Network var1);
    }

    static class DualSimMatchException
    extends Exception {
        private static final long serialVersionUID = -996812356902545308L;

        DualSimMatchException(String info) {
            super(info);
        }
    }
}

