/*
 * Decompiled with CFR 0.152.
 */
package com.beust.klaxon;

import com.beust.klaxon.Debug;
import com.beust.klaxon.JsonBase;
import com.beust.klaxon.JsonReader;
import com.beust.klaxon.KlaxonParser;
import com.beust.klaxon.Lexer;
import com.beust.klaxon.Parser;
import com.beust.klaxon.PathMatcher;
import com.beust.klaxon.StateMachine;
import com.beust.klaxon.Status;
import com.beust.klaxon.World;
import com.beust.klaxon.token.COLON;
import com.beust.klaxon.token.COMMA;
import com.beust.klaxon.token.EOF;
import com.beust.klaxon.token.LEFT_BRACE;
import com.beust.klaxon.token.LEFT_BRACKET;
import com.beust.klaxon.token.RIGHT_BRACE;
import com.beust.klaxon.token.RIGHT_BRACKET;
import com.beust.klaxon.token.Token;
import com.beust.klaxon.token.VALUE_TYPE;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u0015\u001a\u00020\r2\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/beust/klaxon/KlaxonParser;", "Lcom/beust/klaxon/Parser;", "pathMatchers", "", "Lcom/beust/klaxon/PathMatcher;", "passedLexer", "Lcom/beust/klaxon/Lexer;", "streaming", "", "(Ljava/util/List;Lcom/beust/klaxon/Lexer;Z)V", "stateMachine", "Lcom/beust/klaxon/StateMachine;", "fullParseLoop", "", "sm", "reader", "Ljava/io/Reader;", "log", "", "s", "", "parse", "inputStream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "rawValue", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "partialParseLoop", "klaxon"})
public final class KlaxonParser
implements Parser {
    private final StateMachine stateMachine;
    private final List<PathMatcher> pathMatchers;
    private final Lexer passedLexer;
    private final boolean streaming;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object parse(@NotNull StringBuilder rawValue) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)rawValue, (String)"rawValue");
        Closeable closeable = new StringReader(rawValue.toString());
        boolean bl = false;
        Throwable throwable = null;
        try {
            StringReader it = (StringReader)closeable;
            boolean bl2 = false;
            object = this.parse(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    @Override
    @NotNull
    public Object parse(@NotNull InputStream inputStream, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        InputStream inputStream2 = inputStream;
        KlaxonParser klaxonParser = this;
        boolean bl = false;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, charset);
        return klaxonParser.parse(inputStreamReader);
    }

    @Override
    @NotNull
    public Object parse(@NotNull Reader reader) {
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        return this.streaming ? this.partialParseLoop(this.stateMachine, ((JsonReader)reader).getReader()) : this.fullParseLoop(this.stateMachine, reader);
    }

    private final Object partialParseLoop(StateMachine sm, Reader reader) {
        Token token;
        Lexer lexer = this.passedLexer;
        if (lexer == null) {
            lexer = new Lexer(reader, false, 2, null);
        }
        Lexer lexer2 = lexer;
        World world = new World(Status.INIT, this.pathMatchers);
        boolean wasNested = false;
        if (lexer2.peek() instanceof COMMA) {
            lexer2.nextToken();
        }
        do {
            token = lexer2.nextToken();
            this.log("Token: " + token);
            wasNested = world.isNestedStatus();
            world = sm.next(world, token);
        } while (wasNested || !(token instanceof RIGHT_BRACE) && !(token instanceof RIGHT_BRACKET) && !(token instanceof EOF));
        Object object = world.popValue();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.beust.klaxon.JsonBase");
        }
        return (JsonBase)object;
    }

    private final Object fullParseLoop(StateMachine sm, Reader reader) {
        Token token;
        Lexer lexer = this.passedLexer;
        if (lexer == null) {
            lexer = new Lexer(reader, false, 2, null);
        }
        Lexer lexer2 = lexer;
        World world = new World(Status.INIT, this.pathMatchers);
        do {
            token = lexer2.nextToken();
            this.log("Token: " + token);
            world.setIndex(lexer2.getIndex());
            world.setLine(lexer2.getLine());
            world = sm.next(world, token);
        } while (!(token instanceof EOF));
        Object object = world.getResult();
        if (object == null) {
            Intrinsics.throwNpe();
        }
        return object;
    }

    private final void log(String s) {
        if (Debug.Companion.getVerbose()) {
            String string2 = "[Parser] " + s;
            boolean bl = false;
            System.out.println((Object)string2);
        }
    }

    public KlaxonParser(@NotNull List<? extends PathMatcher> pathMatchers, @Nullable Lexer passedLexer, boolean streaming) {
        Intrinsics.checkParameterIsNotNull(pathMatchers, (String)"pathMatchers");
        this.pathMatchers = pathMatchers;
        this.passedLexer = passedLexer;
        this.streaming = streaming;
        StateMachine stateMachine = this.stateMachine = new StateMachine(this.streaming);
        boolean bl = false;
        boolean bl2 = false;
        StateMachine $this$with = stateMachine;
        boolean bl3 = false;
        $this$with.put(Status.INIT, VALUE_TYPE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.1.INSTANCE));
        $this$with.put(Status.INIT, LEFT_BRACE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.2.INSTANCE));
        $this$with.put(Status.INIT, LEFT_BRACKET.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.3.INSTANCE));
        $this$with.put(Status.IN_FINISHED_VALUE, EOF.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.4.INSTANCE));
        $this$with.put(Status.IN_OBJECT, COMMA.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.5.INSTANCE));
        $this$with.put(Status.IN_OBJECT, VALUE_TYPE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.6.INSTANCE));
        $this$with.put(Status.IN_OBJECT, RIGHT_BRACE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.7.INSTANCE));
        $this$with.put(Status.PASSED_PAIR_KEY, COLON.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.8.INSTANCE));
        $this$with.put(Status.PASSED_PAIR_KEY, VALUE_TYPE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.9.INSTANCE));
        $this$with.put(Status.PASSED_PAIR_KEY, LEFT_BRACKET.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.10.INSTANCE));
        $this$with.put(Status.PASSED_PAIR_KEY, LEFT_BRACE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.11.INSTANCE));
        $this$with.put(Status.IN_ARRAY, COMMA.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.12.INSTANCE));
        $this$with.put(Status.IN_ARRAY, VALUE_TYPE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.13.INSTANCE));
        $this$with.put(Status.IN_ARRAY, RIGHT_BRACKET.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.14.INSTANCE));
        $this$with.put(Status.IN_ARRAY, LEFT_BRACE.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.15.INSTANCE));
        $this$with.put(Status.IN_ARRAY, LEFT_BRACKET.INSTANCE.getTokenType(), (Function2<? super World, ? super Token, World>)((Function2)1.16.INSTANCE));
    }

    @Override
    @NotNull
    public Object parse(@NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
        return Parser.DefaultImpls.parse(this, fileName);
    }
}

