/*
 * Decompiled with CFR 0.152.
 */
package com.beust.klaxon;

import com.beust.klaxon.Token;
import com.beust.klaxon.Type;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fH\u0002J\b\u0010(\u001a\u00020&H\u0002J\u000e\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\fJ\u000e\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020\fJ\b\u0010+\u001a\u00020\fH\u0002J\u0006\u0010,\u001a\u00020\u0015J\b\u0010-\u001a\u00020\fH\u0002R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000eR\u0019\u0010\u001a\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0012\u0010\"\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010#R\u000e\u0010\u0007\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/beust/klaxon/Lexer;", "", "stream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "BOOLEAN_LETTERS", "", "", "getBOOLEAN_LETTERS", "()Ljava/util/Set;", "DOUBLE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDOUBLE", "()Ljava/util/regex/Pattern;", "EOF", "Lcom/beust/klaxon/Token;", "getEOF", "()Lcom/beust/klaxon/Token;", "NULL_LETTERS", "getNULL_LETTERS", "NUMERIC", "getNUMERIC", "index", "", "getIndex", "()I", "setIndex", "(I)V", "next", "Ljava/lang/Character;", "Ljava/io/BufferedReader;", "isBooleanLetter", "", "c", "isDone", "isSpace", "isValueLetter", "nextChar", "nextToken", "peekChar", "klaxon"})
public final class Lexer {
    @NotNull
    private final Token EOF;
    private int index;
    private final Pattern NUMERIC;
    private final Pattern DOUBLE;
    private final BufferedReader reader;
    private Character next;
    @NotNull
    private final Set<Character> BOOLEAN_LETTERS;
    @NotNull
    private final Set<Character> NULL_LETTERS;

    @NotNull
    public final Token getEOF() {
        return this.EOF;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final Pattern getNUMERIC() {
        return this.NUMERIC;
    }

    public final Pattern getDOUBLE() {
        return this.DOUBLE;
    }

    public final boolean isSpace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t';
    }

    private final char nextChar() {
        if (this.isDone()) {
            throw (Throwable)new IllegalStateException("Cannot get next char: EOF reached");
        }
        Character c = this.next;
        if (c == null) {
            Intrinsics.throwNpe();
        }
        char c2 = c.charValue();
        this.next = null;
        return c2;
    }

    private final char peekChar() {
        if (this.isDone()) {
            throw (Throwable)new IllegalStateException("Cannot peek next char: EOF reached");
        }
        Character c = this.next;
        if (c == null) {
            Intrinsics.throwNpe();
        }
        return c.charValue();
    }

    private final boolean isDone() {
        if (this.next != null) {
            return false;
        }
        int n = this.index;
        this.index = n + 1;
        int read = this.reader.read();
        if (read == -1) {
            return true;
        }
        this.next = Character.valueOf((char)read);
        return false;
    }

    @NotNull
    public final Set<Character> getBOOLEAN_LETTERS() {
        return this.BOOLEAN_LETTERS;
    }

    private final boolean isBooleanLetter(char c) {
        return this.BOOLEAN_LETTERS.contains(Character.valueOf(Character.toLowerCase(c)));
    }

    @NotNull
    public final Set<Character> getNULL_LETTERS() {
        return this.NULL_LETTERS;
    }

    public final boolean isValueLetter(char c) {
        char c2;
        return c == '-' || c == '+' || c == '.' || Character.isDigit(c2 = c) || this.isBooleanLetter(c) || this.NULL_LETTERS.contains(Character.valueOf(c));
    }

    @NotNull
    public final Token nextToken() {
        Type tokenType;
        if (this.isDone()) {
            return this.EOF;
        }
        char c = this.nextChar();
        StringBuilder currentValue = new StringBuilder();
        Object jsonValue = null;
        while (!this.isDone() && this.isSpace(c)) {
            c = this.nextChar();
        }
        if ('\"' == c) {
            tokenType = Type.VALUE;
            block19: while (true) {
                if (this.isDone()) {
                    throw (Throwable)new RuntimeException("Unterminated string");
                }
                c = this.nextChar();
                block2 : switch (c) {
                    case '\\': {
                        if (this.isDone()) {
                            throw (Throwable)new RuntimeException("Unterminated string");
                        }
                        c = this.nextChar();
                        switch (c) {
                            case '\\': {
                                currentValue.append("\\");
                                break block2;
                            }
                            case '/': {
                                currentValue.append("/");
                                break block2;
                            }
                            case 'b': {
                                currentValue.append("\b");
                                break block2;
                            }
                            case 'f': {
                                currentValue.append("\f");
                                break block2;
                            }
                            case 'n': {
                                currentValue.append("\n");
                                break block2;
                            }
                            case 'r': {
                                currentValue.append("\r");
                                break block2;
                            }
                            case 't': {
                                currentValue.append("\t");
                                break block2;
                            }
                            case 'u': {
                                StringBuilder unicodeChar = new StringBuilder(4).append(this.nextChar()).append(this.nextChar()).append(this.nextChar()).append(this.nextChar());
                                int intValue = Integer.parseInt(unicodeChar.toString(), 16);
                                currentValue.append((char)intValue);
                                break block2;
                            }
                        }
                        currentValue.append(c);
                        break;
                    }
                    case '\"': {
                        break block19;
                    }
                    default: {
                        currentValue.append(c);
                    }
                }
            }
            jsonValue = currentValue.toString();
        } else if ('{' == c) {
            tokenType = Type.LEFT_BRACE;
        } else if ('}' == c) {
            tokenType = Type.RIGHT_BRACE;
        } else if ('[' == c) {
            tokenType = Type.LEFT_BRACKET;
        } else if (']' == c) {
            tokenType = Type.RIGHT_BRACKET;
        } else if (':' == c) {
            tokenType = Type.COLON;
        } else if (',' == c) {
            tokenType = Type.COMMA;
        } else if (!this.isDone()) {
            String v;
            while (this.isValueLetter(c)) {
                currentValue.append(c);
                if (!this.isValueLetter(this.peekChar())) break;
                c = this.nextChar();
            }
            if (this.NUMERIC.matcher(v = currentValue.toString()).matches()) {
                try {
                    jsonValue = Integer.parseInt(v);
                }
                catch (NumberFormatException e) {
                    try {
                        jsonValue = Long.parseLong(v);
                    }
                    catch (NumberFormatException e2) {
                        jsonValue = new BigInteger(v);
                    }
                }
            } else if (this.DOUBLE.matcher(v).matches()) {
                jsonValue = Double.parseDouble(v);
            } else {
                String string2 = v;
                String string3 = "true";
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase()");
                String string6 = string5;
                if (string3.equals(string6)) {
                    jsonValue = true;
                } else {
                    string2 = v;
                    string3 = "false";
                    String string7 = string2;
                    if (string7 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.toLowerCase();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
                    string6 = string8;
                    if (string3.equals(string6)) {
                        jsonValue = false;
                    } else if (Intrinsics.areEqual((Object)v, (Object)"null")) {
                        jsonValue = null;
                    } else {
                        throw (Throwable)new RuntimeException("Unexpected character at position " + this.index + (": '" + c + " (" + c + ")'"));
                    }
                }
            }
            tokenType = Type.VALUE;
        } else {
            tokenType = Type.EOF;
        }
        return new Token(tokenType, jsonValue);
    }

    public Lexer(@NotNull Reader reader) {
        BufferedReader bufferedReader;
        Intrinsics.checkParameterIsNotNull((Object)reader, (String)"reader");
        this.EOF = new Token(Type.EOF, null);
        this.NUMERIC = Pattern.compile("[-]?[0-9]+");
        this.DOUBLE = Pattern.compile(this.NUMERIC.toString() + "((\\.[0-9]+)?([eE][-+]?[0-9]+)?)");
        Reader reader2 = reader;
        int n = 0;
        boolean bl = true;
        Object var5_5 = null;
        Lexer lexer = this;
        if (bl & true) {
            n = 8192;
        }
        lexer.reader = bufferedReader = reader2 instanceof BufferedReader ? (BufferedReader)reader2 : new BufferedReader(reader2, n);
        this.BOOLEAN_LETTERS = StringsKt.toSet((CharSequence)"falsetrue");
        this.NULL_LETTERS = StringsKt.toSet((CharSequence)"null");
    }

    public Lexer(@NotNull InputStream stream, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        InputStream inputStream = stream;
        Lexer lexer = this;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        lexer(inputStreamReader);
    }

    public /* synthetic */ Lexer(InputStream inputStream, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(inputStream, charset);
    }
}

