/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterDescription;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Maps;
import java.io.BufferedReader;
import java.io.Console;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCommander {
    public static final String DEBUG_PROPERTY = "jcommander.debug";
    private Map<String, ParameterDescription> m_descriptions;
    private List<Object> m_objects;
    private Field m_mainParameterField = null;
    private Object m_mainParameterObject;
    private Map<Field, ParameterDescription> m_requiredFields = Maps.newHashMap();
    private Map<Field, ParameterDescription> m_fields = Maps.newHashMap();
    private ResourceBundle m_bundle;

    public JCommander(Object object) {
        this.init(object, null);
    }

    public JCommander(Object object, ResourceBundle bundle, String ... args) {
        this.init(object, bundle);
        this.parse(args);
    }

    public JCommander(Object object, String ... args) {
        this.init(object, null);
        this.parse(args);
    }

    private void init(Object object, ResourceBundle bundle) {
        this.m_bundle = bundle;
        this.m_objects = Lists.newArrayList();
        if (object instanceof Iterable) {
            for (Object o : (Iterable)object) {
                this.m_objects.add(o);
            }
        } else if (object.getClass().isArray()) {
            for (Object o : (Object[])object) {
                this.m_objects.add(o);
            }
        } else {
            this.m_objects.add(object);
        }
    }

    public void parse(String ... args) {
        this.createDescriptions();
        this.parseValues(JCommander.expandArgs(args));
        this.validateOptions();
    }

    private void validateOptions() {
        if (!this.m_requiredFields.isEmpty()) {
            StringBuilder missingFields = new StringBuilder();
            for (ParameterDescription pd : this.m_requiredFields.values()) {
                missingFields.append(pd.getNames()[0]).append(" ");
            }
            throw new ParameterException("The following options are required: " + missingFields);
        }
    }

    private static String[] expandArgs(String[] originalArgv) {
        List vResult = Lists.newArrayList();
        for (String arg : originalArgv) {
            if (arg.startsWith("@")) {
                String fileName = arg.substring(1);
                vResult.addAll(JCommander.readFile(fileName));
                continue;
            }
            vResult.add(arg);
        }
        return vResult.toArray(new String[vResult.size()]);
    }

    public static List<String> readFile(String fileName) {
        List<String> result = Lists.newArrayList();
        try {
            String line;
            BufferedReader bufRead = new BufferedReader(new FileReader(fileName));
            while ((line = bufRead.readLine()) != null) {
                result.add(line);
            }
            bufRead.close();
        }
        catch (IOException e) {
            throw new ParameterException("Could not read file " + fileName + ": " + e);
        }
        return result;
    }

    private static String trim(String string) {
        String result = string.trim();
        if (result.startsWith("\"")) {
            if (result.endsWith("\"")) {
                return result.substring(1, result.length() - 1);
            }
            return result.substring(1);
        }
        return result;
    }

    private void createDescriptions() {
        this.m_descriptions = Maps.newHashMap();
        for (Object object : this.m_objects) {
            Class<?> cls = object.getClass();
            for (Field f : cls.getDeclaredFields()) {
                this.p("Field:" + f.getName());
                f.setAccessible(true);
                Parameter annotation = f.getAnnotation(Parameter.class);
                if (annotation == null) continue;
                Parameter p = annotation;
                if (p.names().length == 0) {
                    this.p("Found main parameter:" + f);
                    if (this.m_mainParameterField != null) {
                        throw new ParameterException("Only one @Parameter with no names attribute is allowed, found:" + this.m_mainParameterField + " and " + f);
                    }
                    this.m_mainParameterField = f;
                    this.m_mainParameterObject = object;
                    continue;
                }
                for (String name : p.names()) {
                    if (this.m_descriptions.containsKey(name)) {
                        throw new ParameterException("Found the option " + name + " multiple times");
                    }
                    this.p("Adding description for " + name);
                    ParameterDescription pd = new ParameterDescription(object, p, f, this.m_bundle);
                    this.m_fields.put(f, pd);
                    this.m_descriptions.put(name, pd);
                    if (!p.required()) continue;
                    this.m_requiredFields.put(f, pd);
                }
            }
        }
    }

    private void p(String string) {
    }

    private void parseValues(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String a = JCommander.trim(args[i]);
            this.log("Parsing arg:" + a);
            if (a.startsWith("-")) {
                ParameterDescription pd = this.m_descriptions.get(a);
                if (pd != null) {
                    int n;
                    if (pd.getParameter().password()) {
                        Console console = System.console();
                        if (console == null) {
                            throw new ParameterException("No console is available to get parameter " + pd.getNames()[0]);
                        }
                        System.out.print("Value for " + pd.getNames()[0] + " (" + pd.getDescription() + "):");
                        char[] password = console.readPassword();
                        pd.addValue(new String(password));
                        continue;
                    }
                    Class<?> fieldType = pd.getField().getType();
                    if ((fieldType == Boolean.TYPE || fieldType == Boolean.class) && pd.getParameter().arity() == -1) {
                        pd.addValue("true");
                        this.m_requiredFields.remove(pd.getField());
                        continue;
                    }
                    int arity = pd.getParameter().arity();
                    int n2 = n = arity != -1 ? arity : 1;
                    if (i + n < args.length) {
                        for (int j = 1; j <= n; ++j) {
                            pd.addValue(JCommander.trim(args[i + j]));
                            this.m_requiredFields.remove(pd.getField());
                        }
                        i += n;
                        continue;
                    }
                    throw new ParameterException(arity + " parameters expected after " + args[i]);
                }
                throw new ParameterException("Unknown option: " + a);
            }
            if (JCommander.isStringEmpty(args[i])) continue;
            this.getMainParameter(args[i]).add(args[i]);
        }
    }

    private static boolean isStringEmpty(String s) {
        return s == null || "".equals(s);
    }

    private List<String> getMainParameter(String arg) {
        if (this.m_mainParameterField == null) {
            throw new ParameterException("Was passed main parameter '" + arg + "' but no main parameter was defined");
        }
        try {
            List<String> result = (List<String>)this.m_mainParameterField.get(this.m_mainParameterObject);
            if (result == null) {
                result = Lists.newArrayList();
                this.m_mainParameterField.set(this.m_mainParameterObject, result);
            }
            return result;
        }
        catch (IllegalAccessException ex) {
            throw new ParameterException("Couldn't access main parameter: " + ex.getMessage());
        }
    }

    public void usage() {
        System.out.println("Usage:");
        for (ParameterDescription pd : this.m_fields.values()) {
            StringBuilder sb = new StringBuilder();
            for (String n : pd.getParameter().names()) {
                sb.append(n).append(" ");
            }
            System.out.println("\t" + sb.toString() + "\t" + pd.getDescription());
        }
    }

    public List<ParameterDescription> getParameters() {
        return new ArrayList<ParameterDescription>(this.m_fields.values());
    }

    private void log(String string) {
        if (System.getProperty(DEBUG_PROPERTY) != null) {
            System.out.println("[JCommander] " + string);
        }
    }
}

