/*
 * Decompiled with CFR 0.152.
 */
package com.beust.jcommander;

import com.beust.jcommander.Lists;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class ParameterDescription {
    private Object m_object;
    private Parameter m_parameterAnnotation;
    private Field m_field;
    private boolean m_added = false;
    private ResourceBundle m_bundle;
    private String m_description;

    public ParameterDescription(Object object, Parameter annotation, Field field, ResourceBundle bundle) {
        this.init(object, annotation, field, bundle);
    }

    private void init(Object object, Parameter annotation, Field field, ResourceBundle bundle) {
        this.m_object = object;
        this.m_parameterAnnotation = annotation;
        this.m_field = field;
        this.m_bundle = bundle;
        this.m_description = this.m_bundle != null ? this.m_bundle.getString(annotation.descriptionKey()) : annotation.description();
    }

    public String[] getNames() {
        return this.m_parameterAnnotation.names();
    }

    public String getDescription() {
        return this.m_description;
    }

    public Parameter getParameter() {
        return this.m_parameterAnnotation;
    }

    public Field getField() {
        return this.m_field;
    }

    private boolean isMultiOption() {
        Class<?> fieldType = this.m_field.getType();
        return fieldType.equals(List.class) || fieldType.equals(Set.class);
    }

    public void addValue(Object value) {
        if (this.m_added && !this.isMultiOption()) {
            throw new ParameterException("Can only specify option " + this.getNames()[0] + " once.");
        }
        this.m_added = true;
        try {
            Class<?> fieldType = this.m_field.getType();
            if (fieldType.equals(String.class)) {
                this.m_field.set(this.m_object, value);
            } else if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                this.m_field.set(this.m_object, Integer.parseInt(value.toString()));
            } else if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                this.m_field.set(this.m_object, Long.parseLong(value.toString()));
            } else if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                this.m_field.set(this.m_object, Float.valueOf(Float.parseFloat(value.toString())));
            } else if (fieldType.equals(Boolean.class) || fieldType.equals(Boolean.TYPE)) {
                this.m_field.set(this.m_object, value);
            } else if (this.isMultiOption()) {
                List l = (List)this.m_field.get(this.m_object);
                if (l == null) {
                    l = Lists.newArrayList();
                    this.m_field.set(this.m_object, l);
                }
                l.add(value);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

