/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.ratpack.internal;

import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.AssetPipelineResponseBuilder;
import asset.pipeline.ratpack.AssetAttributes;
import asset.pipeline.ratpack.internal.AssetProperties;
import asset.pipeline.ratpack.internal.ProductionAssetCache;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import ratpack.exec.Blocking;
import ratpack.func.Action;
import ratpack.func.Factory;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Response;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.registry.Registry;

public class ProductionAssetHandler
implements Handler {
    private static final String ASSET_BASE_PATH = "assets/";

    public void handle(Context ctx) throws Exception {
        Properties manifest = AssetPipelineConfigHolder.manifest;
        AssetProperties props = (AssetProperties)ctx.get(AssetProperties.class);
        ProductionAssetCache fileCache = (ProductionAssetCache)ctx.get(ProductionAssetCache.class);
        Response response = ctx.getResponse();
        String manifestPath = manifest.getProperty(props.getPath(), props.getPath());
        Path asset = ctx.file(ASSET_BASE_PATH + manifestPath);
        AssetPipelineResponseBuilder responseBuilder = new AssetPipelineResponseBuilder(props.getPath(), ctx.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.IF_NONE_MATCH));
        AssetAttributes attributeCache = (AssetAttributes)fileCache.get(manifestPath);
        if (attributeCache != null) {
            if (attributeCache.exists()) {
                response.contentTypeIfNotSet((CharSequence)props.getFormat());
                if (responseBuilder.headers != null) {
                    for (Map.Entry cursor : responseBuilder.headers.entrySet()) {
                        response.getHeaders().set((CharSequence)cursor.getKey(), cursor.getValue());
                    }
                }
                if (responseBuilder.statusCode != null) {
                    response.status(responseBuilder.statusCode.intValue());
                }
                if (responseBuilder.statusCode == null || responseBuilder.statusCode != 304) {
                    if (this.acceptsGzip(ctx) && attributeCache.gzipExists().booleanValue()) {
                        Path gzipFile = ctx.file(ASSET_BASE_PATH + manifestPath + ".gz");
                        response.getHeaders().set((CharSequence)"Content-Encoding", (Object)"gzip");
                        response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)Long.toString(attributeCache.getGzipFileSize()));
                        response.sendFile(gzipFile);
                    } else {
                        response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)Long.toString(attributeCache.getFileSize()));
                        response.noCompress().sendFile(asset);
                    }
                } else {
                    response.send();
                }
            } else if (attributeCache.isDirectory()) {
                this.doIndexFileNext(ctx, props);
            } else {
                ctx.next();
            }
        } else {
            ProductionAssetHandler.readAttributes(asset, (Action<? super BasicFileAttributes>)((Action)attributes -> {
                if (attributes == null || !attributes.isRegularFile()) {
                    if (props.getIndexedPath() != null && attributes != null) {
                        fileCache.put(manifestPath, new AssetAttributes(false, false, true, null, null));
                        this.doIndexFileNext(ctx, props);
                    } else {
                        fileCache.put(manifestPath, new AssetAttributes(false, false, false, null, null));
                        ctx.next();
                    }
                } else {
                    response.contentTypeIfNotSet((CharSequence)props.getFormat());
                    if (assetPipelineResponseBuilder.headers != null) {
                        for (Map.Entry cursor : assetPipelineResponseBuilder.headers.entrySet()) {
                            response.getHeaders().set((CharSequence)cursor.getKey(), cursor.getValue());
                        }
                    }
                    if (assetPipelineResponseBuilder.statusCode != null) {
                        response.status(assetPipelineResponseBuilder.statusCode.intValue());
                    }
                    if (assetPipelineResponseBuilder.statusCode == null || assetPipelineResponseBuilder.statusCode != 304) {
                        Path gzipFile = ctx.file(ASSET_BASE_PATH + manifestPath + ".gz");
                        if (this.acceptsGzip(ctx)) {
                            ProductionAssetHandler.readAttributes(gzipFile, (Action<? super BasicFileAttributes>)((Action)gzipAttributes -> {
                                if (gzipAttributes == null || !gzipAttributes.isRegularFile()) {
                                    response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)Long.toString(attributes.size()));
                                    fileCache.put(manifestPath, new AssetAttributes(true, false, false, attributes.size(), null));
                                    response.noCompress().sendFile(asset);
                                } else {
                                    response.getHeaders().set((CharSequence)"Content-Encoding", (Object)"gzip");
                                    response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)Long.toString(gzipAttributes.size()));
                                    fileCache.put(manifestPath, new AssetAttributes(true, true, false, attributes.size(), gzipAttributes.size()));
                                    response.sendFile(gzipFile);
                                }
                            }));
                        } else {
                            response.getHeaders().set(HttpHeaderConstants.CONTENT_LENGTH, (Object)Long.toString(attributes.size()));
                            response.noCompress().sendFile(asset);
                            ProductionAssetHandler.readAttributes(gzipFile, (Action<? super BasicFileAttributes>)((Action)gzipAttributes -> {
                                if (gzipAttributes == null || !gzipAttributes.isRegularFile()) {
                                    fileCache.put(manifestPath, new AssetAttributes(true, false, false, attributes.size(), null));
                                } else {
                                    fileCache.put(manifestPath, new AssetAttributes(true, true, false, attributes.size(), gzipAttributes.size()));
                                }
                            }));
                        }
                    } else {
                        response.send();
                    }
                }
            }));
        }
    }

    private void doIndexFileNext(Context ctx, AssetProperties props) {
        ctx.insert(Registry.single((Object)new AssetProperties(props.getIndexedPath(), null, props.getFormat(), props.getEncoding())), new Handler[]{this});
    }

    private boolean acceptsGzip(Context ctx) {
        String acceptsEncoding = ctx.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT_ENCODING);
        return acceptsEncoding != null && Arrays.asList(acceptsEncoding.split(",")).contains("gzip");
    }

    public static void readAttributes(Path file, Action<? super BasicFileAttributes> then) throws Exception {
        Blocking.get(ProductionAssetHandler.getter(file)).then(then);
    }

    private static Factory<BasicFileAttributes> getter(Path file) {
        return () -> {
            if (Files.exists(file, new LinkOption[0])) {
                return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            }
            return null;
        };
    }
}

