/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.ratpack.internal;

import asset.pipeline.AssetPipeline;
import asset.pipeline.ratpack.internal.AssetProperties;
import java.util.Date;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.Response;
import ratpack.registry.Registry;

public class DevelopmentAssetHandler
implements Handler {
    private static final String COMPILE_PARAM = "compile";

    public void handle(Context ctx) throws Exception {
        AssetProperties props = (AssetProperties)ctx.get(AssetProperties.class);
        byte[] fileContents = this.getFileContents(ctx, props);
        if (fileContents != null) {
            DevelopmentAssetHandler.setNoCache(ctx, fileContents.length);
            ctx.getResponse().contentTypeIfNotSet((CharSequence)props.getFormat());
            ctx.getResponse().send(fileContents);
        } else if (props.getIndexedPath() != null) {
            ctx.insert(Registry.single((Object)new AssetProperties(props.getIndexedPath(), null, props.getFormat(), props.getEncoding())), new Handler[]{this});
        } else {
            ctx.next();
        }
    }

    private byte[] getFileContents(Context context, AssetProperties props) {
        byte[] fileContents = DevelopmentAssetHandler.shouldCompile(context) ? AssetPipeline.serveAsset((String)props.getPath(), (String)props.getFormat(), null, (String)props.getEncoding()) : AssetPipeline.serveUncompiledAsset((String)props.getPath(), (String)props.getFormat(), null, (String)props.getEncoding());
        return fileContents != null && props.getIndexedPath() != null ? this.getFileContents(context, props) : fileContents;
    }

    private static boolean shouldCompile(Context context) {
        return !"false".equals(context.getRequest().getQueryParams().get((Object)COMPILE_PARAM));
    }

    private static void setNoCache(Context context, long contentLength) {
        Response response = context.getResponse();
        response.getHeaders().set((CharSequence)"Cache-Control", (Object)"no-cache, no-store, must-revalidate");
        response.getHeaders().set((CharSequence)"Pragma", (Object)"no-cache");
        response.getHeaders().setDate((CharSequence)"Expires", new Date(0L));
        response.getHeaders().set((CharSequence)"Content-Length", (Object)Long.toString(contentLength));
    }
}

