/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.ratpack.internal;

import asset.pipeline.ratpack.AssetPipelineModule;
import asset.pipeline.ratpack.internal.AssetProperties;
import java.nio.charset.Charset;
import ratpack.file.MimeTypes;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.path.PathBinding;
import ratpack.registry.Registry;

public class AssetPropertiesHandler
implements Handler {
    public void handle(Context ctx) throws Exception {
        AssetPipelineModule.Config config = (AssetPipelineModule.Config)ctx.get(AssetPipelineModule.Config.class);
        String path = AssetPropertiesHandler.getPath(ctx, config.getUrl());
        String indexedPath = AssetPropertiesHandler.getIndexedPath(path, config.getIndexFile());
        String format = indexedPath == null ? AssetPropertiesHandler.getFormat(ctx, path) : AssetPropertiesHandler.getFormat(ctx, indexedPath);
        String encoding = AssetPropertiesHandler.getEncoding(ctx);
        ctx.next(Registry.single((Object)new AssetProperties(path, indexedPath, format, encoding)));
    }

    private static String getIndexedPath(String path, String indexFile) {
        if (path.endsWith("/") || "".equals(path)) {
            return "/".equals(path) ? "/" + indexFile : String.format("%s/%s", path, indexFile);
        }
        return null;
    }

    private static String getFormat(Context context, String path) {
        return ((MimeTypes)context.get(MimeTypes.class)).getContentType(path);
    }

    private static String getEncoding(Context context) {
        String encoding = (String)context.getRequest().getQueryParams().get((Object)"encoding");
        if (encoding == null) {
            encoding = Charset.defaultCharset().name();
        }
        return encoding;
    }

    private static String getPath(Context context, String baseAssetUrl) {
        String path = AssetPropertiesHandler.normalizePath(context.maybeGet(PathBinding.class).map(PathBinding::getPastBinding).orElse(context.getRequest().getPath()));
        if (path.startsWith(baseAssetUrl) && path.length() > baseAssetUrl.length()) {
            return path.substring(baseAssetUrl.length());
        }
        if (path.startsWith(baseAssetUrl) && baseAssetUrl.equals(path)) {
            return "/";
        }
        return path;
    }

    private static String normalizePath(String path) {
        String[] parts = path.split("/");
        String fileName = parts[parts.length - 1];
        if (!fileName.contains(".")) {
            path = path + '/';
        }
        return path;
    }
}

