/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.ratpack;

import asset.pipeline.AssetPipelineConfigHolder;
import asset.pipeline.fs.AssetResolver;
import asset.pipeline.fs.FileSystemAssetResolver;
import asset.pipeline.ratpack.AssetPipelineModule;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import ratpack.file.FileSystemBinding;
import ratpack.server.Service;
import ratpack.server.StartEvent;

public class AssetPipelineService
implements Service {
    public void onStart(StartEvent startEvent) throws Exception {
        FileSystemBinding fileSystemBinding = (FileSystemBinding)startEvent.getRegistry().get(FileSystemBinding.class);
        AssetPipelineModule.Config config = (AssetPipelineModule.Config)startEvent.getRegistry().get(AssetPipelineModule.Config.class);
        if (config.getAssets() != null) {
            AssetPipelineConfigHolder.config = config.getAssets();
        }
        Path path = fileSystemBinding.getFile();
        Path manifest = fileSystemBinding.file("assets/manifest.properties");
        if (manifest != null && Files.exists(manifest, new LinkOption[0])) {
            AssetPipelineConfigHolder.config.put("precompiled", true);
            Properties manifestProps = new Properties();
            InputStream manIs = Files.newInputStream(manifest, new OpenOption[0]);
            manifestProps.load(manIs);
            manIs.close();
            AssetPipelineConfigHolder.manifest = manifestProps;
        } else {
            AssetPipelineConfigHolder.registerResolver((AssetResolver)new FileSystemAssetResolver("application", path.resolve(config.getSourcePath()).toFile().getCanonicalPath()));
        }
    }
}

