/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline.ratpack;

import asset.pipeline.ratpack.AssetPipelineHandler;
import asset.pipeline.ratpack.AssetPipelineService;
import asset.pipeline.ratpack.internal.ProductionAssetCache;
import com.google.inject.Binder;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.Map;
import ratpack.guice.ConfigurableModule;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.handling.Handlers;
import ratpack.registry.Registry;

public class AssetPipelineModule
extends ConfigurableModule<Config> {
    protected void configure() {
        this.bind(AssetPipelineService.class).in(Singleton.class);
        this.bind(AssetPipelineHandler.class).in(Singleton.class);
        this.bind(ProductionAssetCache.class).in(Singleton.class);
        Multibinder.newSetBinder((Binder)this.binder(), HandlerDecorator.class).addBinding().toInstance((registry, rest) -> Handlers.chain((Handler[])new Handler[]{rest, Handlers.chain((Registry)registry, c -> c.all(AssetPipelineHandler.class))}));
    }

    public static class Config {
        private String sourcePath = "../assets";
        private String url = "assets/";
        private String indexFile = "index.html";
        private Map<String, Object> assets;

        public Config sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public Config url(String url) {
            this.url = url;
            return this;
        }

        public String getUrl() {
            return this.url;
        }

        public Config indexFile(String indexFile) {
            this.indexFile = indexFile;
            return this;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public Config assets(Map<String, Object> assets) {
            this.assets = assets;
            return this;
        }

        public Map<String, Object> getAssets() {
            return this.assets;
        }
    }
}

