/*
 * Decompiled with CFR 0.152.
 */
package asset.pipeline;

import asset.pipeline.AssetPipelineConfigHolder;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.TypeChecked;
import java.lang.ref.SoftReference;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPipelineResponseBuilder
implements GroovyObject {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public String uri;
    public String ifNoneMatchHeader;
    public String ifModifiedSinceHeader;
    public Integer statusCode;
    private Date lastModifiedDate;
    public Map<String, String> headers;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1527603852081;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public AssetPipelineResponseBuilder(String string, String string2, String string3, Date date) {
        void lastModifiedDate;
        void ifModifiedSinceHeader;
        void ifNoneMatchHeader;
        void uri;
        MetaClass metaClass;
        Map map;
        int n = 200;
        this.statusCode = n;
        this.headers = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var8_8 = uri;
        this.uri = var8_8;
        void var9_9 = ifNoneMatchHeader;
        this.ifNoneMatchHeader = var9_9;
        void var10_10 = ifModifiedSinceHeader;
        this.ifModifiedSinceHeader = var10_10;
        void var11_11 = lastModifiedDate;
        this.lastModifiedDate = var11_11;
        boolean digestVersion = this.isDigestVersion();
        if (!DefaultTypeTransformation.booleanUnbox((Object)this.checkDateChanged())) {
            int n2 = 304;
            this.statusCode = n2;
        } else if (this.checkETag().booleanValue()) {
            String string4 = "Accept-Encoding";
            DefaultGroovyMethods.putAt(this.headers, (Object)"Vary", (Object)string4);
            if (digestVersion && !uri.endsWith(".html")) {
                String string5 = "public, max-age=31536000";
                DefaultGroovyMethods.putAt(this.headers, (Object)"Cache-Control", (Object)string5);
            } else {
                String string6 = "no-cache";
                DefaultGroovyMethods.putAt(this.headers, (Object)"Cache-Control", (Object)string6);
            }
        }
    }

    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader, String ifModifiedSinceHeader) {
        this(uri, ifNoneMatchHeader, ifModifiedSinceHeader, null);
    }

    public AssetPipelineResponseBuilder(String uri, String ifNoneMatchHeader) {
        this(uri, ifNoneMatchHeader, null, null);
    }

    public AssetPipelineResponseBuilder(String uri) {
        this(uri, null, null, null);
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAA9MamF2YS91dGlsL01hcDsBAAAAAgAAAAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////wD/////AAAACUNsYXNzTm9kZQAAEkxqYXZhL2xhbmcvU3RyaW5nOwD/////AP////8=")
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABNMamF2YS9sYW5nL0ludGVnZXI7AP////8=")
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    public String getCurrentETag() {
        String manifestPath = this.uri;
        if (this.uri.startsWith("/")) {
            String string;
            manifestPath = string = this.uri.substring(1);
        }
        Properties manifest = AssetPipelineConfigHolder.getManifest();
        String string = manifest != null ? manifest.getProperty(manifestPath) : null;
        return StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)"\"", (Object)(DefaultTypeTransformation.booleanUnbox((Object)string) ? string : manifestPath)), (Object)"\"");
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAAFaAP////8=")
    public boolean isDigestVersion() {
        String manifestPath = this.uri;
        if (this.uri.startsWith("/")) {
            String string;
            manifestPath = string = this.uri.substring(1);
        }
        Properties manifest = AssetPipelineConfigHolder.getManifest();
        return !DefaultTypeTransformation.booleanUnbox(manifest != null ? manifest.getProperty(manifestPath, null) : null);
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABNMamF2YS9sYW5nL0Jvb2xlYW47AP////8=")
    public Boolean checkETag() {
        String etagName = this.getCurrentETag();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.ifNoneMatchHeader) && ScriptBytecodeAdapter.compareEqual((Object)this.ifNoneMatchHeader, (Object)etagName)) {
            int n = 304;
            this.statusCode = n;
            return false;
        }
        String string = etagName;
        DefaultGroovyMethods.putAt(this.headers, (Object)"ETag", (Object)string);
        return true;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABNMamF2YS9sYW5nL0Jvb2xlYW47AP////8=")
    public Boolean checkDateChanged() {
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        boolean hasNotChanged = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)this.lastModifiedDate)) {
            String string = this.getLastModifiedDate(this.lastModifiedDate);
            DefaultGroovyMethods.putAt(this.headers, (Object)"Last-Modified", (Object)string);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.ifModifiedSinceHeader) && DefaultTypeTransformation.booleanUnbox((Object)this.lastModifiedDate)) {
            try {
                boolean bl;
                hasNotChanged = bl = ScriptBytecodeAdapter.compareLessThanEqual((Object)this.lastModifiedDate, (Object)sdf.parse(this.ifModifiedSinceHeader));
            }
            catch (Exception e) {
            }
        }
        return !hasNotChanged;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL1N0cmluZzsA/////w==")
    private String getLastModifiedDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String lastModifiedDateTimeString = sdf.format(new Date());
        try {
            String string;
            lastModifiedDateTimeString = string = sdf.format(date);
        }
        catch (Exception e) {
        }
        return lastModifiedDateTimeString;
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABdMZ3Jvb3Z5L2xhbmcvTWV0YUNsYXNzOwD/////")
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AssetPipelineResponseBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL09iamVjdDsA/////w==")
    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(AssetPipelineResponseBuilder.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAAAFWAP////8=")
    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, AssetPipelineResponseBuilder.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    @TypeChecked.TypeCheckingInfo(version=1, inferredType="AAlDbGFzc05vZGUAABJMamF2YS9sYW5nL09iamVjdDsA/////w==")
    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(AssetPipelineResponseBuilder.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        long l;
        long l2;
        AssetPipelineResponseBuilder.__$swapInit();
        __timeStamp__239_neverHappen1527603852081 = l2 = 0L;
        __timeStamp = l = 1527603852081L;
    }

    public /* synthetic */ String this$2$getLastModifiedDate(Date date) {
        return this.getLastModifiedDate(date);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(AssetPipelineResponseBuilder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AssetPipelineResponseBuilder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

