/*
 * Decompiled with CFR 0.152.
 */
package com.bendaschel.sevensegmentview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.RectF;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import java.util.Arrays;
import java.util.List;

public class SevenSegmentView
extends View {
    private static final Path BASE_PATH = SevenSegmentView.makePathFromPoints(Arrays.asList(new Point(4, 1), new Point(5, 0), new Point(4, -1), new Point(-4, -1), new Point(-5, 0), new Point(-4, 1)));
    private static final String KEY_SAVE_STATE = "saved_current_value";
    private static final DIGITS DEFAULT_STATE = DIGITS.ALL_OFF;
    public static final String KEY_SUPER_STATE = "superState";
    private static final RectF SEGMENT_BOUNDS = SevenSegmentView.calculateAllSegmentBounds();
    private static final int COLOR_ON = -65536;
    private static final int COLOR_OFF = Color.argb((int)50, (int)Color.red((int)-65536), (int)0, (int)0);
    private static final boolean ON = true;
    private static final boolean OFF = false;
    private Matrix mCurrentTransformation;
    private Path mTemporaryPath;
    private int mCurrentValue = DIGITS.ALL_OFF.ordinal();
    private Paint mPaint;
    private boolean[] mActiveSegments;

    public SevenSegmentView(Context context) {
        super(context);
        this.init();
    }

    public SevenSegmentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SevenSegmentView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint(1);
        this.mCurrentTransformation = new Matrix();
        this.mTemporaryPath = new Path();
        this.mActiveSegments = SevenSegmentView.DEFAULT_STATE.activeSegments;
    }

    public void setCurrentValue(int currentValue) {
        this.mActiveSegments = currentValue >= 0 && currentValue <= 9 ? DIGITS.values()[currentValue].activeSegments : SevenSegmentView.DEFAULT_STATE.activeSegments;
        this.mCurrentValue = currentValue;
        this.invalidate();
    }

    public int getCurrentValue() {
        return this.mCurrentValue;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        float scaleFactor = this.calculateScaleFactor(widthSize, heightSize, SEGMENT_BOUNDS.width(), SEGMENT_BOUNDS.height());
        int desiredWidth = (int)(SEGMENT_BOUNDS.width() * scaleFactor);
        int desiredHeight = (int)(SEGMENT_BOUNDS.height() * scaleFactor);
        this.setMeasuredDimension(desiredWidth, desiredHeight);
    }

    protected void onDraw(Canvas canvas) {
        this.mCurrentTransformation.reset();
        int canvasWidth = canvas.getWidth();
        int canvasHeight = canvas.getHeight();
        this.mCurrentTransformation.setTranslate((float)(canvasWidth / 2), (float)(canvasHeight / 2));
        int drawHeight = canvasHeight - this.getPaddingBottom() - this.getPaddingTop();
        int drawWidth = canvasWidth - this.getPaddingLeft() - this.getPaddingRight();
        float scaleFactor = this.calculateScaleFactor(drawWidth, drawHeight, SEGMENT_BOUNDS.width(), SEGMENT_BOUNDS.height());
        this.mCurrentTransformation.preScale(scaleFactor, scaleFactor);
        for (SEGMENTS segment : SEGMENTS.values()) {
            segment.path.transform(this.mCurrentTransformation, this.mTemporaryPath);
            int position = segment.ordinal();
            this.mPaint.setColor(this.mActiveSegments[position] ? -65536 : COLOR_OFF);
            canvas.drawPath(this.mTemporaryPath, this.mPaint);
            this.mTemporaryPath.reset();
        }
    }

    private float calculateScaleFactor(float containerWidth, float containerHeight, float childWidth, float childHeight) {
        float heightRatio = containerHeight / childHeight;
        float widthRatio = containerWidth / childWidth;
        return Math.min(widthRatio, heightRatio);
    }

    private static RectF calculateAllSegmentBounds() {
        RectF outerBounds = new RectF();
        RectF segmentBounds = new RectF();
        SEGMENTS.TOP.path.computeBounds(segmentBounds, true);
        for (SEGMENTS segment : SEGMENTS.values()) {
            segment.path.computeBounds(segmentBounds, true);
            outerBounds.union(segmentBounds);
        }
        return outerBounds;
    }

    private static Path makePathFromPoints(List<Point> points) {
        Path path = new Path();
        Point firstPoint = points.get(0);
        List<Point> middlePoints = points.subList(1, points.size());
        path.moveTo((float)firstPoint.x, (float)firstPoint.y);
        for (Point p : middlePoints) {
            path.lineTo((float)p.x, (float)p.y);
        }
        path.close();
        return path;
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, super.onSaveInstanceState());
        bundle.putInt(KEY_SAVE_STATE, this.mCurrentValue);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.setCurrentValue(bundle.getInt(KEY_SAVE_STATE, DEFAULT_STATE.ordinal()));
            state = bundle.getParcelable(KEY_SUPER_STATE);
        }
        super.onRestoreInstanceState(state);
    }

    private static enum DIGITS {
        ZERO(true, true, true, true, true, true, false),
        ONE(false, true, true, false, false, false, false),
        TWO(true, true, false, true, true, false, true),
        THREE(true, true, true, true, false, false, true),
        FOUR(false, true, true, false, false, true, true),
        FIVE(true, false, true, true, false, true, true),
        SIX(true, false, true, true, true, true, true),
        SEVEN(true, true, true, false, false, false, false),
        EIGHT(true, true, true, true, true, true, true),
        NINE(true, true, true, false, false, true, true),
        ALL_OFF(false, false, false, false, false, false, false);

        boolean[] activeSegments;

        private DIGITS(boolean ... activeSegments) {
            this.activeSegments = activeSegments;
        }
    }

    private static enum SEGMENTS {
        TOP(0, 0, 10),
        TOP_RIGHT(90, 5, 5),
        BOTTOM_RIGHT(90, 5, -5),
        BOTTOM(0, 0, -10),
        BOTTOM_LEFT(90, -5, -5),
        TOP_LEFT(90, -5, 5),
        CENTER(0, 0, 0);

        private final Path path;

        private SEGMENTS(int rotate, int translateX, int translateY) {
            Matrix matrix = new Matrix();
            matrix.setTranslate((float)translateX, (float)(-translateY));
            matrix.preRotate((float)rotate);
            this.path = new Path();
            BASE_PATH.transform(matrix, this.path);
        }
    }
}

