/*
 * Decompiled with CFR 0.152.
 */
package com.benasher44.uuid;

import java.nio.ByteBuffer;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u001a\r\u0010\u000b\u001a\u00060\u0002j\u0002`\fH\u0086\b\u001a\u0012\u0010\r\u001a\u00060\u0002j\u0002`\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0012\u0010\u0010\u001a\u00060\u0002j\u0002`\f2\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0016\u0010\u0005\u001a\u00020\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0016\u0010\t\u001a\u00020\u0006*\u00020\u00028\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b*\n\u0010\u0015\"\u00020\u00022\u00020\u0002\u00a8\u0006\u0016"}, d2={"bytes", "", "Ljava/util/UUID;", "getBytes", "(Ljava/util/UUID;)[B", "variant", "", "getVariant", "(Ljava/util/UUID;)I", "version", "getVersion", "uuid4", "Lcom/benasher44/uuid/Uuid;", "uuidFrom", "string", "", "uuidOf", "segmentToLong", "", "start", "end", "Uuid", "uuid"})
public final class UuidKt {
    public static /* synthetic */ void Uuid$annotations() {
    }

    @NotNull
    public static final UUID uuidOf(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        boolean bl = bytes.length == 16;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid UUID bytes. Expected 16 bytes; found " + bytes.length;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        bl2 = false;
        bl3 = false;
        ByteBuffer it = byteBuffer;
        boolean bl5 = false;
        ByteBuffer byteBuffer2 = it;
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"it");
        return new UUID(byteBuffer2.getLong(), it.getLong());
    }

    @NotNull
    public static final UUID uuidFrom(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        if (string.length() != 36) {
            throw (Throwable)new IllegalArgumentException("Invalid UUID string, expected exactly 36 characters but got " + string.length() + ": " + string);
        }
        return new UUID(UuidKt.segmentToLong(string, 0, 19), UuidKt.segmentToLong(string, 19, 36));
    }

    private static final long segmentToLong(String $this$segmentToLong, int start, int end) {
        long result = 0L;
        int i = start;
        do {
            if ($this$segmentToLong.charAt(i) == '-') {
                boolean bl = i == 8 || i == 13 || i == 18 || i == 23;
                boolean bl2 = false;
                boolean bl3 = false;
                if (bl) continue;
                boolean bl4 = false;
                String string = "Invalid UUID string, encountered dash at index " + i + " but it can occur only at 8, 13, 18, or 23: " + $this$segmentToLong;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            result *= (long)16;
            switch ($this$segmentToLong.charAt(i)) {
                case '0': {
                    break;
                }
                case '1': {
                    ++result;
                    break;
                }
                case '2': {
                    result += 2L;
                    break;
                }
                case '3': {
                    result += 3L;
                    break;
                }
                case '4': {
                    result += 4L;
                    break;
                }
                case '5': {
                    result += 5L;
                    break;
                }
                case '6': {
                    result += 6L;
                    break;
                }
                case '7': {
                    result += 7L;
                    break;
                }
                case '8': {
                    result += 8L;
                    break;
                }
                case '9': {
                    result += 9L;
                    break;
                }
                case 'A': 
                case 'a': {
                    result += 10L;
                    break;
                }
                case 'B': 
                case 'b': {
                    result += 11L;
                    break;
                }
                case 'C': 
                case 'c': {
                    result += 12L;
                    break;
                }
                case 'D': 
                case 'd': {
                    result += 13L;
                    break;
                }
                case 'E': 
                case 'e': {
                    result += 14L;
                    break;
                }
                case 'F': 
                case 'f': {
                    result += 15L;
                    break;
                }
                default: {
                    throw (Throwable)new IllegalArgumentException("Invalid UUID string, encountered non-hexadecimal digit `" + $this$segmentToLong.charAt(i) + "` at index " + i + " in: " + $this$segmentToLong);
                }
            }
        } while (++i < end);
        return result;
    }

    @NotNull
    public static final UUID uuid4() {
        int $i$f$uuid4 = 0;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"UUID.randomUUID()");
        return uUID;
    }

    @NotNull
    public static final byte[] getBytes(@NotNull UUID $this$bytes) {
        Intrinsics.checkNotNullParameter((Object)$this$bytes, (String)"$this$bytes");
        byte[] byArray = ByteBuffer.allocate(16).putLong($this$bytes.getMostSignificantBits()).putLong($this$bytes.getLeastSignificantBits()).array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"ByteBuffer.allocate(16).\u2026tSignificantBits).array()");
        return byArray;
    }

    public static final int getVersion(@NotNull UUID $this$version) {
        int $i$f$getVersion = 0;
        Intrinsics.checkNotNullParameter((Object)$this$version, (String)"$this$version");
        return $this$version.version();
    }

    public static final int getVariant(@NotNull UUID $this$variant) {
        int $i$f$getVariant = 0;
        Intrinsics.checkNotNullParameter((Object)$this$variant, (String)"$this$variant");
        return $this$variant.variant();
    }
}

