/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.IScrollingController;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.anchor.IAnchorFactory;
import com.beloo.widget.chipslayoutmanager.anchor.RowsAnchorFactory;
import com.beloo.widget.chipslayoutmanager.gravity.RowGravityModifiersFactory;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;
import com.beloo.widget.chipslayoutmanager.layouter.IOrientationStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.LTRRowsOrientationStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.LayouterFactory;
import com.beloo.widget.chipslayoutmanager.layouter.RTLRowsOrientationStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.RowSquare;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.DecoratorBreakerFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.AbstractCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.ICriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.InfiniteCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.RowsCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.placer.IPlacerFactory;
import com.beloo.widget.chipslayoutmanager.util.StateHelper;

public class RowsStateFactory
implements IStateFactory {
    private ChipsLayoutManager lm;

    public RowsStateFactory(ChipsLayoutManager lm) {
        this.lm = lm;
    }

    private IOrientationStateFactory createOrientationStateFactory() {
        return this.lm.isLayoutRTL() ? new RTLRowsOrientationStateFactory() : new LTRRowsOrientationStateFactory();
    }

    @Override
    public LayouterFactory createLayouterFactory(ICriteriaFactory criteriaFactory, IPlacerFactory placerFactory) {
        IOrientationStateFactory orientationStateFactory = this.createOrientationStateFactory();
        return new LayouterFactory(this.lm, orientationStateFactory.createLayouterCreator(this.lm), new DecoratorBreakerFactory(this.lm.getViewPositionsStorage(), this.lm.getRowBreaker(), this.lm.getMaxViewsInRow(), orientationStateFactory.createDefaultBreaker()), criteriaFactory, placerFactory, new RowGravityModifiersFactory(), orientationStateFactory.createRowStrategyFactory().createRowStrategy(this.lm.getRowStrategyType()));
    }

    @Override
    public AbstractCriteriaFactory createDefaultFinishingCriteriaFactory() {
        return StateHelper.isInfinite(this) ? new InfiniteCriteriaFactory() : new RowsCriteriaFactory();
    }

    @Override
    public IAnchorFactory anchorFactory() {
        return new RowsAnchorFactory(this.lm, this.lm.getCanvas());
    }

    @Override
    public IScrollingController scrollingController() {
        return this.lm.verticalScrollingController();
    }

    @Override
    public ICanvas createCanvas() {
        return new RowSquare(this.lm);
    }

    @Override
    public int getSizeMode() {
        return this.lm.getHeightMode();
    }

    @Override
    public int getStart() {
        return 0;
    }

    @Override
    public int getStart(View view) {
        return this.lm.getDecoratedTop(view);
    }

    @Override
    public int getStart(AnchorViewState anchor) {
        return anchor.getAnchorViewRect().top;
    }

    @Override
    public int getEnd() {
        return this.lm.getHeight();
    }

    @Override
    public int getEnd(View view) {
        return this.lm.getDecoratedBottom(view);
    }

    @Override
    public int getEnd(AnchorViewState anchor) {
        return anchor.getAnchorViewRect().bottom;
    }

    @Override
    public int getEndViewPosition() {
        return this.lm.getPosition(this.lm.getCanvas().getRightView());
    }

    @Override
    public int getStartAfterPadding() {
        return this.lm.getPaddingTop();
    }

    @Override
    public int getStartViewPosition() {
        return this.lm.getPosition(this.lm.getCanvas().getLeftView());
    }

    @Override
    public int getEndAfterPadding() {
        return this.lm.getHeight() - this.lm.getPaddingBottom();
    }

    @Override
    public int getStartViewBound() {
        return this.getStart(this.lm.getCanvas().getTopView());
    }

    @Override
    public int getEndViewBound() {
        return this.getEnd(this.lm.getCanvas().getBottomView());
    }

    @Override
    public int getTotalSpace() {
        return this.lm.getHeight() - this.lm.getPaddingTop() - this.lm.getPaddingBottom();
    }
}

