/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouter;

class RTLUpLayouter
extends AbstractLayouter
implements ILayouter {
    private static final String TAG = RTLUpLayouter.class.getSimpleName();

    private RTLUpLayouter(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    void onPreLayout() {
        int leftOffsetOfRow = -(this.getCanvasRightBorder() - this.viewLeft);
        this.viewLeft = this.rowViews.size() > 0 ? Integer.MAX_VALUE : 0;
        for (Pair rowViewRectPair : this.rowViews) {
            Rect viewRect = (Rect)rowViewRectPair.first;
            viewRect.left -= leftOffsetOfRow;
            viewRect.right -= leftOffsetOfRow;
            this.viewLeft = Math.min(this.viewLeft, viewRect.left);
            this.viewTop = Math.min(this.viewTop, viewRect.top);
            this.viewBottom = Math.max(this.viewBottom, viewRect.bottom);
        }
    }

    @Override
    void onAfterLayout() {
        this.viewLeft = this.getCanvasLeftBorder();
        this.viewBottom = this.viewTop;
    }

    @Override
    boolean isAttachedViewFromNewRow(View view) {
        int bottomOfCurrentView = this.getLayoutManager().getDecoratedBottom(view);
        int leftOfCurrentView = this.getLayoutManager().getDecoratedLeft(view);
        return this.viewTop >= bottomOfCurrentView && leftOfCurrentView < this.viewLeft;
    }

    @Override
    Rect createViewRect(View view) {
        int right = this.viewLeft + this.getCurrentViewWidth();
        int viewTop = this.viewBottom - this.getCurrentViewHeight();
        Rect viewRect = new Rect(this.viewLeft, viewTop, right, this.viewBottom);
        this.viewLeft = viewRect.right;
        return viewRect;
    }

    @Override
    boolean isReverseOrder() {
        return true;
    }

    @Override
    public void onInterceptAttachView(View view) {
        if (this.viewLeft != this.getCanvasLeftBorder() && this.viewLeft + this.getCurrentViewWidth() > this.getCanvasRightBorder()) {
            this.viewLeft = this.getCanvasLeftBorder();
            this.viewBottom = this.viewTop;
        } else {
            this.viewLeft = this.getLayoutManager().getDecoratedRight(view);
        }
        this.viewTop = Math.min(this.viewTop, this.getLayoutManager().getDecoratedTop(view));
    }

    @Override
    public int getStartRowBorder() {
        return this.getViewTop();
    }

    @Override
    public int getEndRowBorder() {
        return this.getViewBottom();
    }

    @Override
    public int getRowLength() {
        return this.getCanvasRightBorder() - this.viewLeft;
    }

    public static final class Builder
    extends AbstractLayouter.Builder {
        private Builder() {
        }

        @Override
        @NonNull
        public RTLUpLayouter createLayouter() {
            return new RTLUpLayouter(this);
        }
    }
}

