/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouterCreator;
import com.beloo.widget.chipslayoutmanager.layouter.RTLDownLayouter;
import com.beloo.widget.chipslayoutmanager.layouter.RTLUpLayouter;

class RTLRowsCreator
implements ILayouterCreator {
    private RecyclerView.LayoutManager layoutManager;

    RTLRowsCreator(RecyclerView.LayoutManager layoutManager) {
        this.layoutManager = layoutManager;
    }

    @Override
    public Rect createOffsetRectForBackwardLayouter(AnchorViewState anchor) {
        Rect anchorRect = anchor.getAnchorViewRect();
        return new Rect(anchorRect == null ? 0 : anchorRect.right, anchorRect == null ? 0 : anchorRect.top, 0, anchorRect == null ? 0 : anchorRect.bottom);
    }

    @Override
    public AbstractLayouter.Builder createBackwardBuilder() {
        return RTLUpLayouter.newBuilder();
    }

    @Override
    public AbstractLayouter.Builder createForwardBuilder() {
        return RTLDownLayouter.newBuilder();
    }

    @Override
    public Rect createOffsetRectForForwardLayouter(AnchorViewState anchor) {
        Rect anchorRect = anchor.getAnchorViewRect();
        return new Rect(0, anchorRect == null ? (anchor.getPosition() == 0 ? this.layoutManager.getPaddingTop() : 0) : anchorRect.top, anchorRect == null ? this.layoutManager.getPaddingRight() : anchorRect.right, anchorRect == null ? (anchor.getPosition() == 0 ? this.layoutManager.getPaddingBottom() : 0) : anchorRect.bottom);
    }
}

