/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.support.annotation.CallSuper;
import android.support.v7.widget.RecyclerView;
import com.beloo.widget.chipslayoutmanager.layouter.IMeasureSupporter;

public class MeasureSupporter
extends RecyclerView.AdapterDataObserver
implements IMeasureSupporter {
    private RecyclerView.LayoutManager lm;
    private boolean isAfterRemoving;
    private int measuredWidth;
    private int measuredHeight;
    private boolean isRegistered;
    private Integer beforeRemovingWidth = null;
    private int autoMeasureWidth = 0;
    private Integer beforeRemovingHeight = null;
    private int autoMeasureHeight = 0;

    public MeasureSupporter(RecyclerView.LayoutManager lm) {
        this.lm = lm;
    }

    @Override
    public void onSizeChanged() {
        this.autoMeasureWidth = this.lm.getWidth();
        this.autoMeasureHeight = this.lm.getHeight();
    }

    boolean isAfterRemoving() {
        return this.isAfterRemoving;
    }

    @Override
    public int getMeasuredWidth() {
        return this.measuredWidth;
    }

    private void setMeasuredWidth(int measuredWidth) {
        this.measuredWidth = measuredWidth;
    }

    @Override
    public int getMeasuredHeight() {
        return this.measuredHeight;
    }

    @Override
    public boolean isRegistered() {
        return this.isRegistered;
    }

    @Override
    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    private void setMeasuredHeight(int measuredHeight) {
        this.measuredHeight = measuredHeight;
    }

    @Override
    @CallSuper
    public void measure(int autoWidth, int autoHeight) {
        if (this.isAfterRemoving()) {
            this.setMeasuredWidth(Math.max(autoWidth, this.beforeRemovingWidth));
            this.setMeasuredHeight(Math.max(autoHeight, this.beforeRemovingHeight));
        } else {
            this.setMeasuredWidth(autoWidth);
            this.setMeasuredHeight(autoHeight);
        }
    }

    @Override
    public void onItemsRemoved(final RecyclerView recyclerView) {
        this.lm.postOnAnimation(new Runnable(){

            private void onFinished() {
                MeasureSupporter.this.isAfterRemoving = false;
                MeasureSupporter.this.lm.requestLayout();
            }

            @Override
            public void run() {
                if (recyclerView.getItemAnimator() != null) {
                    recyclerView.getItemAnimator().isRunning(new RecyclerView.ItemAnimator.ItemAnimatorFinishedListener(){

                        public void onAnimationsFinished() {
                            this.onFinished();
                        }
                    });
                } else {
                    this.onFinished();
                }
            }
        });
    }

    @CallSuper
    public void onItemRangeRemoved(int positionStart, int itemCount) {
        super.onItemRangeRemoved(positionStart, itemCount);
        this.isAfterRemoving = true;
        this.beforeRemovingWidth = this.autoMeasureWidth;
        this.beforeRemovingHeight = this.autoMeasureHeight;
    }
}

