/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;
import com.beloo.widget.chipslayoutmanager.layouter.ILayouter;

class LTRUpLayouter
extends AbstractLayouter
implements ILayouter {
    private LTRUpLayouter(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    Rect createViewRect(View view) {
        int left = this.viewRight - this.getCurrentViewWidth();
        int viewTop = this.viewBottom - this.getCurrentViewHeight();
        Rect viewRect = new Rect(left, viewTop, this.viewRight, this.viewBottom);
        this.viewRight = viewRect.left;
        return viewRect;
    }

    @Override
    boolean isReverseOrder() {
        return true;
    }

    @Override
    void onPreLayout() {
        int leftOffsetOfRow = this.viewRight - this.getCanvasLeftBorder();
        this.viewLeft = 0;
        for (Pair rowViewRectPair : this.rowViews) {
            Rect viewRect = (Rect)rowViewRectPair.first;
            viewRect.left -= leftOffsetOfRow;
            viewRect.right -= leftOffsetOfRow;
            this.viewLeft = Math.max(viewRect.right, this.viewLeft);
            this.viewTop = Math.min(this.viewTop, viewRect.top);
            this.viewBottom = Math.max(this.viewBottom, viewRect.bottom);
        }
    }

    @Override
    void onAfterLayout() {
        this.viewRight = this.getCanvasRightBorder();
        this.viewBottom = this.viewTop;
    }

    @Override
    boolean isAttachedViewFromNewRow(View view) {
        int bottomOfCurrentView = this.getLayoutManager().getDecoratedBottom(view);
        int rightOfCurrentView = this.getLayoutManager().getDecoratedRight(view);
        return this.viewTop >= bottomOfCurrentView && rightOfCurrentView > this.viewRight;
    }

    @Override
    public void onInterceptAttachView(View view) {
        if (this.viewRight != this.getCanvasRightBorder() && this.viewRight - this.getCurrentViewWidth() < this.getCanvasLeftBorder()) {
            this.viewRight = this.getCanvasRightBorder();
            this.viewBottom = this.viewTop;
        } else {
            this.viewRight = this.getLayoutManager().getDecoratedLeft(view);
        }
        this.viewTop = Math.min(this.viewTop, this.getLayoutManager().getDecoratedTop(view));
    }

    @Override
    public int getStartRowBorder() {
        return this.getViewTop();
    }

    @Override
    public int getEndRowBorder() {
        return this.getViewBottom();
    }

    @Override
    public int getRowLength() {
        return this.getCanvasRightBorder() - this.viewRight;
    }

    public static final class Builder
    extends AbstractLayouter.Builder {
        private Builder() {
        }

        @Override
        @NonNull
        public LTRUpLayouter createLayouter() {
            return new LTRUpLayouter(this);
        }
    }
}

