/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.util.Pair;
import android.view.View;
import com.beloo.widget.chipslayoutmanager.layouter.AbstractLayouter;

class LTRDownLayouter
extends AbstractLayouter {
    private boolean isPurged;

    private LTRDownLayouter(Builder builder) {
        super(builder);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    Rect createViewRect(View view) {
        Rect viewRect = new Rect(this.viewLeft, this.viewTop, this.viewLeft + this.getCurrentViewWidth(), this.viewTop + this.getCurrentViewHeight());
        this.viewLeft = viewRect.right;
        this.viewBottom = Math.max(this.viewBottom, viewRect.bottom);
        return viewRect;
    }

    @Override
    boolean isReverseOrder() {
        return false;
    }

    @Override
    void onPreLayout() {
        if (!this.rowViews.isEmpty()) {
            if (!this.isPurged) {
                this.isPurged = true;
                this.getCacheStorage().purgeCacheFromPosition(this.getLayoutManager().getPosition((View)((Pair)this.rowViews.get((int)0)).second));
            }
            this.getCacheStorage().storeRow(this.rowViews);
        }
    }

    @Override
    void onAfterLayout() {
        this.viewLeft = this.getCanvasLeftBorder();
        this.viewTop = this.viewBottom;
    }

    @Override
    boolean isAttachedViewFromNewRow(View view) {
        int topOfCurrentView = this.getLayoutManager().getDecoratedTop(view);
        int leftOfCurrentView = this.getLayoutManager().getDecoratedLeft(view);
        return this.viewBottom <= topOfCurrentView && leftOfCurrentView < this.viewLeft;
    }

    @Override
    public void onInterceptAttachView(View view) {
        this.viewTop = this.getLayoutManager().getDecoratedTop(view);
        this.viewLeft = this.getLayoutManager().getDecoratedRight(view);
        this.viewBottom = Math.max(this.viewBottom, this.getLayoutManager().getDecoratedBottom(view));
    }

    @Override
    public int getStartRowBorder() {
        return this.getViewTop();
    }

    @Override
    public int getEndRowBorder() {
        return this.getViewBottom();
    }

    @Override
    public int getRowLength() {
        return this.viewLeft - this.getCanvasLeftBorder();
    }

    public static final class Builder
    extends AbstractLayouter.Builder {
        private Builder() {
        }

        @Override
        @NonNull
        public LTRDownLayouter createLayouter() {
            return new LTRDownLayouter(this);
        }
    }
}

