/*
 * Decompiled with CFR 0.152.
 */
package com.beloo.widget.chipslayoutmanager.layouter;

import android.view.View;
import com.beloo.widget.chipslayoutmanager.ChipsLayoutManager;
import com.beloo.widget.chipslayoutmanager.IScrollingController;
import com.beloo.widget.chipslayoutmanager.anchor.AnchorViewState;
import com.beloo.widget.chipslayoutmanager.anchor.ColumnsAnchorFactory;
import com.beloo.widget.chipslayoutmanager.anchor.IAnchorFactory;
import com.beloo.widget.chipslayoutmanager.cache.IViewCacheStorage;
import com.beloo.widget.chipslayoutmanager.gravity.ColumnGravityModifiersFactory;
import com.beloo.widget.chipslayoutmanager.gravity.ColumnStrategyFactory;
import com.beloo.widget.chipslayoutmanager.gravity.IRowStrategyFactory;
import com.beloo.widget.chipslayoutmanager.layouter.ColumnSquare;
import com.beloo.widget.chipslayoutmanager.layouter.ColumnsCreator;
import com.beloo.widget.chipslayoutmanager.layouter.ICanvas;
import com.beloo.widget.chipslayoutmanager.layouter.IStateFactory;
import com.beloo.widget.chipslayoutmanager.layouter.LayouterFactory;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.ColumnBreakerFactory;
import com.beloo.widget.chipslayoutmanager.layouter.breaker.DecoratorBreakerFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.AbstractCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.ColumnsCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.ICriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.criteria.InfiniteCriteriaFactory;
import com.beloo.widget.chipslayoutmanager.layouter.placer.IPlacerFactory;
import com.beloo.widget.chipslayoutmanager.util.StateHelper;

public class ColumnsStateFactory
implements IStateFactory {
    private ChipsLayoutManager lm;
    private IRowStrategyFactory rowStrategyFactory;

    public ColumnsStateFactory(ChipsLayoutManager lm) {
        this.lm = lm;
        this.rowStrategyFactory = new ColumnStrategyFactory();
    }

    @Override
    public LayouterFactory createLayouterFactory(ICriteriaFactory criteriaFactory, IPlacerFactory placerFactory) {
        IViewCacheStorage cacheStorage = this.lm.getViewPositionsStorage();
        return this.createColumnLayouterFactory(criteriaFactory, placerFactory, cacheStorage);
    }

    private LayouterFactory createColumnLayouterFactory(ICriteriaFactory criteriaFactory, IPlacerFactory placerFactory, IViewCacheStorage cacheStorage) {
        return new LayouterFactory(this.lm, new ColumnsCreator(this.lm), new DecoratorBreakerFactory(cacheStorage, this.lm.getRowBreaker(), this.lm.getMaxViewsInRow(), new ColumnBreakerFactory()), criteriaFactory, placerFactory, new ColumnGravityModifiersFactory(), this.rowStrategyFactory.createRowStrategy(this.lm.getRowStrategyType()));
    }

    @Override
    public AbstractCriteriaFactory createDefaultFinishingCriteriaFactory() {
        return StateHelper.isInfinite(this) ? new InfiniteCriteriaFactory() : new ColumnsCriteriaFactory();
    }

    @Override
    public IAnchorFactory anchorFactory() {
        return new ColumnsAnchorFactory(this.lm, this.lm.getCanvas());
    }

    @Override
    public IScrollingController scrollingController() {
        return this.lm.horizontalScrollingController();
    }

    @Override
    public ICanvas createCanvas() {
        return new ColumnSquare(this.lm);
    }

    @Override
    public int getSizeMode() {
        return this.lm.getWidthMode();
    }

    @Override
    public int getStart() {
        return 0;
    }

    @Override
    public int getStart(View view) {
        return this.lm.getDecoratedLeft(view);
    }

    @Override
    public int getStart(AnchorViewState anchor) {
        return anchor.getAnchorViewRect().left;
    }

    @Override
    public int getEnd() {
        return this.lm.getWidth();
    }

    @Override
    public int getEnd(View view) {
        return this.lm.getDecoratedRight(view);
    }

    @Override
    public int getEnd(AnchorViewState anchor) {
        return anchor.getAnchorViewRect().right;
    }

    @Override
    public int getEndViewPosition() {
        return this.lm.getPosition(this.lm.getCanvas().getBottomView());
    }

    @Override
    public int getStartAfterPadding() {
        return this.lm.getPaddingLeft();
    }

    @Override
    public int getStartViewPosition() {
        return this.lm.getPosition(this.lm.getCanvas().getTopView());
    }

    @Override
    public int getEndAfterPadding() {
        return this.lm.getWidth() - this.lm.getPaddingRight();
    }

    @Override
    public int getStartViewBound() {
        return this.getStart(this.lm.getCanvas().getLeftView());
    }

    @Override
    public int getEndViewBound() {
        return this.getEnd(this.lm.getCanvas().getRightView());
    }

    @Override
    public int getTotalSpace() {
        return this.lm.getWidth() - this.lm.getPaddingLeft() - this.lm.getPaddingRight();
    }
}

